<?php
/**
 * @package TropedCourses
 */

/*
Plugin Name: Troped Courses
Plugin URI: 
Description: Plugin para el sitio de courses de troped
Version: 0.1
Author: Ricardo Cortes
Author URI: 
License: GLPv2 or later
License URI: 
*/
/*
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

if ( ! defined( 'ABSPATH' ) ) {
	die;
}

function myStartSession() {
    if(!session_id()) {
		session_name("AxisPHP");
        session_start();
    }
}

function myEndSession() {
	if(session_id()) {
		session_unset();
		session_destroy();
	}
}

function mySession() {
	if (is_user_logged_in())
	{ myStartSession(); }
	else
	{ myEndSession(); }
}
add_action('init', 'mySession', 1);


/***** COURSES *****/
function insert_courses_index($atts) {
	#echo "Hola<br/>";
	#echo dirname(__FILE__)."<br/>";
	#require_once($_SERVER['DOCUMENT_ROOT']."/courses//SPT--Common.php"); 
	#include($_SERVER['DOCUMENT_ROOT']."/courses/index.php");
	#include($_SERVER['DOCUMENT_ROOT']."/courses/SPTUI--CWIS/include/SPT--Common.html");
	#include($_SERVER['DOCUMENT_ROOT']."/courses/SPTUI--CWIS/SPT--Home.html");
	
	#include($_SERVER['DOCUMENT_ROOT']."/courses/SPT--Home-wp.php");
	if ( file_exists("./courses/main-courses-wp.php") ) {
		include("./courses/main-courses-wp.php");
	}
	
	#echo '<iframe id="iFrameCourses" src="courses/STP--Home.php" frameborder="1" transparency="transparency" onload="autofitIframe(this);"></iframe>';
}
add_shortcode('courses_index', 'insert_courses_index');
/***** END COURSES *****/

/***** ADVANCED SEARCH *****/
/*
function insert_advanced_search_institution($atts)
{
	if ( file_exists("./courses/advanced-search-wp.php") ) {
		$_GET['op']="Institution";
		include("./courses/advanced-search-wp.php");
	}
}
add_shortcode('advanced_search_institution', 'insert_advanced_search_institution');

function insert_advanced_search_datestart($atts) {
	if ( file_exists("./courses/advanced-search-wp.php") ) {
		$_GET['op']="datestart";
		include("./courses/advanced-search-wp.php");
	}
}
add_shortcode('advanced_search_datestart', 'insert_advanced_search_datestart');
*/

/***** RESUTLADOS DE LA BUSQUEDA *****/
function insert_advanced_search($atts) {
	if ( file_exists("./courses/advanced-search-wp.php") ) {
		include("./courses/advanced-search-wp.php");
	}
}
add_shortcode('advanced_search', 'insert_advanced_search');
/***** END RESUTLADOS DE LA BUSQUEDA *****/

/****** BUSQUEDA AVANZADA *****/
function insert_advanced($atts) {	
	if ( file_exists("./courses/advanced-wp.php") ) {
		$search_filter = isset($atts['op']) ? $atts['op'] : "";
		$search_value = isset($atts['opsel']) ? $atts['opsel'] : "";
		$_GET['op'] = $search_filter;
		$_GET['opsel'] = $search_value;
		include("./courses/advanced-wp.php");
	}
}
add_shortcode('courses_advanced', 'insert_advanced');
/***** END ADVANCED SEARCH *****/

/***** FULL RECORD *****/
function insert_full_record($atts) {
	if ( file_exists("./courses/full-record-wp.php") ) {
		include("./courses/full-record-wp.php");
	}
}
add_shortcode('full_record', 'insert_full_record');

function insert_full_record_resource($atts) {
	if ( file_exists("./courses/full-record-resource-wp.php") ) {
		include("./courses/full-record-resource-wp.php");
	}
}
add_shortcode('full_record_resource', 'insert_full_record_resource');
/***** END FULL RECORD *****/

/***** FULL SEARCH TEXT *****/
function insert_full_search_text($atts) {
	if ( file_exists("./courses/full-search-text-wp.php") ) {
		include("./courses/full-search-text-wp.php");
	}
}
add_shortcode('full_search_text', 'insert_full_search_text');
/***** FULL SEARCH TEXT *****/

/***** INCLUDE JAVASCRIPT *****/
#<script type="text/javascript" src="../wp-content/plugins/troped-courses/courses_scripts.js"></script>
function widget_enqueue_script()
{   
    wp_enqueue_script( 'my_custom_script', plugin_dir_url( __FILE__ ) . 'courses_scripts.js', array('jquery'), '1.0.0', false );
}
add_action('admin_enqueue_scripts', 'widget_enqueue_script');
/***** END INCLUDE JAVASCRIPT *****/

/***** INCLUDE CSS STYLE *****/
#<style><?php require("courses_style.css");?</style>
function utm_user_scripts() {
	$plugin_url = plugin_dir_url( __FILE__ );
	wp_enqueue_style( 'style',  $plugin_url . "/courses_style.css");
}
add_action( 'admin_print_styles', 'utm_user_scripts' );

function courses_styles() {
	$courses_css_url = "/courses/";
	wp_enqueue_style( 'style',  $courses_css_url . "SPTUI--CWIS/Themes/Theme--Geometrid/SPT--Stylesheet.css");
}
#add_action( 'wp_enqueue_scripts', 'courses_styles');
/***** END INCLUDE CSS STYLE *****/

function Troped_Admin_Redirect($obj){
	#Role del usuario de WordPress
	$varRole = njengah_get_current_user_role();
	
	$obj = "SPT--UserLogin-wp.php/?page=".home_url()."/courses/".$obj."&role=".$varRole;
	#$obj = "SPT--UserLogin-wp.php/?page=".$obj;
	
	echo '<iframe id="iFrameCourses" src="../courses/'.$obj.'" frameborder="1" transparency="transparency" onload="autofitIframe(this);"></iframe>';
}

/***** GET USER ROLE *****/
function njengah_get_current_user_role() {
	if( is_user_logged_in() ) { // check if there is a logged in user		
		$user = wp_get_current_user(); // getting & setting the current user 
		$roles = ( array ) $user->roles; // obtaining the role 
		return $roles[0]; // return the role for the current user 
	} else {
		return "0"; // if there is no logged in user return empty array  
	}
}
/***** END GET USER ROLE *****/

/**** DDL INSTITUTIONS ****/
function insert_ddl_institutions($atts) {
	$dbServerName = "localhost";
    $dbUsername = "demotrop_root";
    $dbPassword = "tr0p3d_2020";
    $dbName = "demotrop_courses";
    
    // create connection
    $conn = new wpdb ($dbServerName, $dbUsername, $dbPassword, $dbName);
    
    // check connection
    if ($conn->connect_error) {
        die("Conexión fallida: " . $conn->connect_error);
    }
    echo "Ehorabuena!!! Has conectado con la base de datos correctamente.";
}
add_shortcode('ddl_institution', 'insert_ddl_institutions');
/**** END DDL INSTITUTIONS ****/

/********** Menu de administración de Troped **********/
add_action( 'admin_menu', 'troped_admin_menu' );

function troped_admin_menu() {
	$varCapabilities = "manage_options";	
	add_menu_page( 'Troped Administration Menu', 'Courses Administration', $varCapabilities, 'Top-Menu-Troped-Admin', '', 'dashicons-admin-site', 6  );
	
	add_submenu_page( 'Top-Menu-Troped-Admin', 'Administration', 'Administration', $varCapabilities, 'Top-Menu-Troped-Admin', 'Troped_Administration', 0 );
	add_submenu_page( 'Top-Menu-Troped-Admin', 'Preferences', 'Preferences', $varCapabilities, 'Sub-Menu-Troped-Preferences', 'Troped_Preferences', 1 );
	add_submenu_page( 'Top-Menu-Troped-Admin', 'Metadata Tool', 'Metadata Tool', $varCapabilities, 'Sub-Menu-Troped-MetadataTool', 'Troped_Metadata_Tool', 2 );
	add_submenu_page( 'Top-Menu-Troped-Admin', 'Edit User Account', 'Edit User Account', $varCapabilities, 'Sub-Menu-Troped-Edit-User-Account', 'Troped_Edit_User_Account', 3 );
	add_submenu_page( 'Top-Menu-Troped-Admin', 'Metadata Tool Help', 'Metadata Tool Help', $varCapabilities, 'Sub-Menu-Troped-Metadata-Tool-Help', 'Troped_Metadata_Tool_Help', 4 );
}

function Troped_Preferences(){
	Troped_Admin_Redirect("SPT--Preferences.php");
}

function Troped_Administration(){
	Troped_Admin_Redirect("SPT--SysAdmin.php");
}

function Troped_Metadata_Tool(){
	Troped_Admin_Redirect("MetadataTool/SPT--MDHome.php");
}

function Troped_Edit_User_Account(){
	Troped_Admin_Redirect("SPT--SelectEditUser.php");
}

function Troped_Metadata_Tool_Help(){
	Troped_Admin_Redirect("MetadataTool/SPT--MetadataHelp.php");
}


/********** Menu de administración de Recursos Troped **********/
add_action( 'admin_menu', 'troped_resources_menu' );

function troped_resources_menu() {
	$varCapabilities = njengah_get_current_user_role();
	if ($varCapabilities != "editor") { $varCapabilities = "manage_options"; }
	
	add_menu_page( 'Troped Resources Menu', 'Courses Resources', $varCapabilities, 'Top-Menu-Troped-Resources', '', 'dashicons-admin-site', 7  );
	
	add_submenu_page( 'Top-Menu-Troped-Resources', 'Resources', 'Resources', $varCapabilities, 'Top-Menu-Troped-Resources', 'Troped_Resources', 0 );
	add_submenu_page( 'Top-Menu-Troped-Resources', 'Add New Resource', 'Add New Resource', $varCapabilities, 'Sub-Menu-Add-New-Resource', 'Troped_Add_New_Resource', 1 );
	add_submenu_page( 'Top-Menu-Troped-Resources', 'Edit Resources', 'Edit Resources', $varCapabilities, 'Sub-Menu-Edit-Resources', 'Troped_Edit_Resources', 2 );
	add_submenu_page( 'Top-Menu-Troped-Resources', 'Add New Controlled Name', 'Add New Controlled Name', $varCapabilities, 'Sub-Menu-Add-New-Controlled-Name', 'Troped_Add_New_Controlled_Name', 3 );
	add_submenu_page( 'Top-Menu-Troped-Resources', 'Edit Controlled Names', 'Edit Controlled Names', $varCapabilities, 'Sub-Menu-Edit-Controlled-Names', 'Troped_Edit_Controlled_Names', 4 );
	add_submenu_page( 'Top-Menu-Troped-Resources', 'Edit Option Lists', 'Edit Option Lists', $varCapabilities, 'Sub-Menu-Edit-Option-Lists', 'Troped_Edit_Option_Lists', 5 );
	add_submenu_page( 'Top-Menu-Troped-Resources', 'Add/Edit Classifications', 'Add/Edit Classifications', $varCapabilities, 'Sub-Menu-AddEdit-Classifications', 'Troped_AddEdit_Classifications', 6 );
}

function Troped_Resources(){
	Troped_Admin_Redirect("index.php");
}

function Troped_Add_New_Resource(){
	Troped_Admin_Redirect("SPT--EditResource.php?ID=NEW");
}

function Troped_Edit_Resources(){
	Troped_Admin_Redirect("SPT--Advanced.php?Editing=1");
}

function Troped_Add_New_Controlled_Name(){
	Troped_Admin_Redirect("MetadataTool/SPT--AddControlledName.php");
}

function Troped_Edit_Controlled_Names(){
	Troped_Admin_Redirect("MetadataTool/SPT--EditControlledName.php?FieldId=0");
}

function Troped_Edit_Option_Lists(){
	Troped_Admin_Redirect("MetadataTool/SPT--EditControlledNameList.php?FieldId=1");
}

function Troped_AddEdit_Classifications(){
	Troped_Admin_Redirect("SPT--BrowseResources.php?Editing=1");
}