# Toolbar Extras for Elementor

**General Info**

* [Plugin's own website: toolbarextras.com](https://toolbarextras.com/)
* [Plugin page on WordPress.org: wordpress.org/plugins/toolbar-extras/](https://wordpress.org/plugins/toolbar-extras/)
* [Translate the plugin](https://translate.wordpress.org/projects/wp-plugins/toolbar-extras)
* [**Join plugin's newsletter for insider info, tutorials and more**](https://eepurl.com/gbAUUn)
* [**Become a Patron**](https://www.patreon.com/deckerweb) and support ongoing development, maintenance and support of this plugin
* [**Donate** for the further development & support of the plugin](https://www.paypal.me/deckerweb)
* [Plugin's documentation & knowledge base](https://toolbarextras.com/docs/)
* [Plugin's public roadmap (Trello Board)](https://toolbarextras.com/go/public-roadmap/)
* [Facebook Community User Group](https://www.facebook.com/groups/ToolbarExtras/)

## Changelog of the Plugin

### ⚡ 1.4.9 - 2019-11-28 

* [Change log](https://toolbarextras.com/changelog/version-1-4-9/)
* *New: Successfully tested with WordPress 5.3*
* New: Added **sub items for file types (Mime Types)** to the Media Library within the Site Group - for Images, PDFs, Audio, Video - this allows for really convenient filtering ;-)
* New: Added **full support for the whole "Toolset" suite of plugins** (all Premium, by OnTheGoSystems)
* New: Added **full support for the whole "WPML (Multilingual CMS)" suite of plugins** (all Premium, by OnTheGoSystems)
* Tweak: Let "New Reusable Block" not appear in Network Admin (Multisite)
* Tweak: For "weForms" plugin support, added integration for Pro Version (Add-On)
* Tweak: For "WPForms Pro" plugin support, added integration with 2 more Pro Add-Ons; additionally added/tweaked external resources
* Tweak: For "Church Content" plugin support, moved the whole item collection to the Site Group (Manage Content), refined items, added resources as well as support for the Pro Add-On
* Tweak: For all ChurchThemes.com Themes (Jubilee, Saved, Maranatha, Exodus, Resurrect) - refined support, added new items
* Tweak: For "Kadence Blocks" plugin support, greatly improved Pro version integration, including *Form Blocks* with saved DB entries
* Tweak: For "Genesis Design Palette Pro" plugin support, added new *Block Styles* item
* Tweak: For "Elegant Blocks" plugin support, added new "Clients" sub item
* Tweak: For "Stackable" plugin support, added new resource items
* Tweak: Removed "CoBlocks" plugin support as the plugin no longer has any settings or info page
* Tweak: Improved file includes and organisation for plugin support
* Tweak: For Genesis Framework support, subtle improvements for tweaked admin menus, plus more refinements
* Tweak: For Nginx Server Environments added two (optional) external resource items
* Tweak: Subtle style improvements for WordPress 5.3+ (settings page)
* Tweak: Updated bundled library DDWlib Plugin Installer Recommendations to latest version (v1.5.1)
* Tweak: Updated `.pot` file plus all German translations (formal, informal) and language packs
* Fix: Avoid any fatal error on Multisite (for Dashboard widget)
* Fix: Fixed wrong German translations (grammar, typos)
* Fix: Numerous smaller errors, notices and code inconsistencies

**New, 1.4.9:** *Extended the Theme support for:*

* Jubilee (Premium, by ChurchThemes.com LLC)
* Agent Focused Pro (Premium, by Marcy Diaz for Winning Agent), a Child Theme for Genesis (Note: only version 2.0.0 or higher supported!)
* GutenBooster (free, by Onur Oztaskiran)
* Bstone (free, by Stack Themes), including plugins: *Bstone Demo Importer (free)* and *Bstone Light (free)* (both by Stack Themes)
* Reykjavik (free, by WebMan Design/ Oliver Juhas)
* Primer (free, by GoDaddy)
* Ashe (free, by WP Royal)
* Mesmerize (free, by Extend Themes/ Horea Radu), including plugin: *Mesmerize Companion* (free, by Extend Themes/ Horea Radu)
* Total (free, by Hash Themes)

**New, 1.4.9:** *Extended the Plugin support for Elementor Add-Ons:*

* WunderWP (free, by Artbees)
* Extensions For Elementor (free, by mayanksdudakiya)
* Elementor Addons – Premium Elementor Addons with Templates & Blocks (free, by Oxilab/ biplob018)
* WPHobby Addons for Elementor (free, by WPHobby)
* JetTricks (Premium, by Zemez Jet/ Crocoblock)

**New, 1.4.9:** *Extended the general Plugin support for:*

* Church Content Pro (Premium, by ChurchThemes.com LLC)
* weForms Pro - Professional (Add-On) (Premium, by weDevs)
* Ivory Search (free, by Ivory Search)
* [qTranslate-XT (free, by qTranslate Community)](https://github.com/qtranslate/qtranslate-xt)
* Search & Replace (free, by Inpsyde GmbH)
* Better Search Replace (free, by Delicious Brains)
* Borlabs Cookie (Premium, by Benjamin A. Bornschein, Borlabs)
* AgentPress Listings (free, by StudioPress)
* Sermon Manager for WordPress (free, by WP for Church)
* Sermon Manager Import (free, by Kyle Hornberg)
* Media from FTP (free, by Katsushi Kawamori)
* WPForms Conversational Forms (Add-On) (Premium, by WPForms LLC)
* WPForms Form Pages (Add-On) (Premium, by WPForms LLC)
* WP Toolbelt (free, by Ben Gillbanks) - *Note: This is a **bloat-free** Jetpack alternative!*
* Sticky Header 2020 (free, by Iulia Cazan) - *Adds additional Customizer options for the "Twenty Twenty" theme*

**New, 1.4.9:** *Extended Plugin support for Block Editor Add-Ons (Gutenberg):*

* GutenBee (free, by The CSSIgniter Team)
* Kioken Blocks (free, by Kioken Theme)
* Potter Kit – Custom Blocks and Templates (free, by Potter LLC)
* WPBricks Readymade Custom Gutenberg Blocks (free, by Multidots)
* Foxdell Folio Block Editor Customiser (free, by Foxdell Folio)
* Foxdell Folio BEC Disable Core Blocks (free, by Foxdell Folio)
* Gutenberg (free, by Gutenberg Team)

**New, 1.4.9:** *Toolset & WPML suites of plugins (all Premium, by OnTheGoSystems):*

* Toolset Types
* Toolset Views
* Toolset Forms
* Toolset Access
* Toolset Layouts
* Toolset Module Manager
* Toolset Framework Installer (Reference Sites)
* Toolset WooCommerce Views
* Toolset Forms Commerce
* Toolset Advanced Export
* Toolset Layout Migration
* WPML Multilingual CMS
* WPML Media
* WPML String Translation
* WPML Translation Management
* WPML Sticky Links
* WPML CMS Nav
* WooCommerce Multingual


### ⚡ 1.4.8 - 2019-10-22 

* [Change log](https://toolbarextras.com/changelog/version-1-4-8/)
* New: Added **"News & Updates" Dashboard widget** - only viewable for (Super) Admins, can easily be disabled via "Screen Options" (top right corner) - Note: settings integration will follow, though
* New: Added way **more specific, helpful resources within the WordPress Logo/ About group** (finishing the work that began with plugin version 1.4.5)
* New: Added shortcut to plugin's settings in Multisite Network Admin (only to the main site of the Network, though)
* New: Added **shortcuts to plugin's settings** tabs on the **Elementor "General Settings"** admin page (as extra tab there)
* New: **For [ClassicPress](https://www.classicpress.net/) installs** added new "Toolbar Extras" **info page under "Security"** admin menu (for ClassicPress v1.1.0+)
* New: You can now also leverage **"WPCore Plugin Manager" plugin to bulk install plugins** - if active, new item and sub items appear within the "New Content" Group
* Tweak: Extended "WP About" sub items with more stuff when *Dev Mode* is enabled
* Tweak: Refined "Mailster" plugin support, added new sub items (Setup Wizard, Tests) and one new resource item (Changelog)
* Tweak: Refined "Formidable Forms" plugin support, added new sub items for Pro version and 2 Pro Add-Ons, plus one new resource item (Changelog)
* Tweak: Improved readability of settings page description texts - now they have an enforced `max-width` of 800px (much better on bigger screens/ viewports...!)
* Tweak: Refinements for the Plugin Manager for Add-Ons - info screens, minimum version management, descriptions
* Tweak: Updated bundled library DDWlib Plugin Installer Recommendations to latest version (v1.5.0) - better performance due to the use of transients
* Tweak: Updated bundled library Astra Notices to latest version (v1.1.4)
* Tweak: Properly enqueued inline styles also for Local Dev Environment feature
* Tweak: Properly enqueued inline styles also for "Gravity Forms" plugin support
* Tweak: Minor security improvement for settings page
* Tweak: Minor enhancements throughout the plugin
* Tweak: Where possible, migrated all the plugin's Toolbar items over from Global usage to `$admin_bar` object to be more in line with WP standards
* Tweak: Updated `.pot` file plus all German translations (formal, informal) and language packs
* Tweak: If available, use new WP 5.0+ function `determine_locale()` for even better (user) locale detection
* Fix: CSS issue on Plugins page - info & update action links from other plugins are no longer hidden
* Fix: Fixed admin URL for Genesis Child Themes "Brunch Pro", "Cook'd Pro" and "Foodie Pro"
* Fix: Fixed loading for "Pretty Chic" Child Theme support

**New, 1.4.8:** *Extended the Theme support for:*

* Course Maker Pro (Premium, by brandiD), a Child Theme for Genesis
* Cafe Pro (Premium, by StudioPress), a Child Theme for Genesis
* Pretty Creative (Premium, by Lindsey Riel), a Child Theme for Genesis

**New, 1.4.8:** *Extended the Plugin support for Elementor Add-Ons:*

* Prime Slider Lite Addons for Elementor (free, by BdThemes)
* Happy Elementor Addons (free, by HappyMonster/ weDevs)
* Ruvuv Extension for Elementor (free, by Ruvuv)

**New, 1.4.8:** *Extended the general Plugin support for:*

* Options for Twenty Nineteen (free, by webd.uk) - *Adds additional Customizer options for the "Twenty Nineteen" theme*
* Options for Twenty Seventeen (free, by webd.uk) - *Adds additional Customizer options for the "Twenty Seventeen" theme*
* Customize Twenty Seventeen (free, by BoldThemes) - *Adds additional Customizer options for the "Twenty Seventeen" theme*
* Customize Twenty Sixteen (free, by BoldThemes) - *Adds additional Customizer options for the "Twenty Sixteen" theme*
* Advanced Twenty Seventeen (free, by saturnplugins) - *Adds additional Customizer options for the "Twenty Seventeen" theme*
* Instant Indexing for Google (free, by Rank Math)
* weForms (free, by weDevs)
* Fluent Forms (Pro) (free/Premium, by WP Fluent Forms)
* MailOptin Lite (free, by MailOptin Team)
* WPCore Plugin Manager (free, by Stuart Starr)
* Delete Expired Transients (free, by WebAware) - *for Dev Mode*
* Transient Cleaner (free, by David Artiss) - *for Dev Mode*


### ⚡ 1.4.7 - 2019-09-20

* [Change log](https://toolbarextras.com/changelog/version-1-4-7/)
* *New: Successfully tested with WordPress 5.3 Beta*
* New: Brand new **Import/ Export feature** to export or import the plugin's own settings via a .json file - including (official) Add-Ons, if these are currently active --- this feature allows you to easily transfer/ migrate the plugin's settings over to new installs or just make personal backups
* New: Added **group of "Website Settings" items/ sub items to the Site Group** - this pretty much covers all official/ default WordPress settings pages under "Settings" - now you have handy shortcuts for those important settings (for example *Permalinks*) from the frontend AND the admin! 😁
* New: **"What Template?" feature** - adds a new top-level item to the Toolbar showing you the file name of the current used Template for the currently displayed page/ document, plus template parts, relative path and Parent/ Child Theme name -- ***Note:** currently this can only be enabled with Dev Mode active and `add_theme_support( 'tbex-show-current-template' );` added via [Code Snippet](https://wordpress.org/plugins/code-snippet/) or your (Child) Theme's `functions.php` (in a next plugin major version this gets even better settings integration, yeah!)*
* Tweak: For "Release Notes" under WordPress About (Logo) item, added logic to completely exclude alpha, beta and RC versions; added ClassicPress compat
* Tweak: For "Elementor" Core plugin support, added new resource item (Developer Blog)
* Tweak: For "Astra" theme support, added full compatibility with Astra 2.0+, including for the Pro Add-On - the Astra 1.x versions are still supported as well :)
* Tweak: For "JetEngine" plugin support, added new items since plugin version 2.0.0 or higher, and refined some existing ones; plus more improvements
* Tweak: For "HappyForms" plugin support, tweaked existing items, added support for Pro version, plus "Builder Template Categories" integration
* Tweak: For "Rank Math SEO" plugin support, added WooCommerce items, plus, far better module detection logic
* Tweak: For "ToolKit for Elementor" plugin support, re-positioned New Content item
* Tweak: For "Block Lab" plugin support, added new "Settings" item, plus lots more external resources
* Tweak: For "Element Pack" plugin support, implemented support for brand new lite version of this plugin, plus, added changelog items
* Tweak: Refined support for all "Twenty" default themes, especially for the Customizer deep links
* Tweak: Subtle improvements to our Elementor Finder integration
* Tweak: Migrated almost all our styles to proper enqueuing and/or the usage of wp_add_inline_style() - this is our first part of styling improvements throughout the plugin
* Tweak: Some globally used functions (within the plugin) and files were re-organized for better maintenance
* Tweak: On settings page implemented better semantic markup, as recommended for WP 5.2+
* Tweak: Improved internal resources for Add-Ons; added lots of new helper functions
* Tweak: Updated bundled library DDWlib Plugin Installer Recommendations to latest version (v1.4.2) - code improvements, fixes
* Tweak: Updated `.pot` file plus all German translations (formal, informal) and language packs
* Tweak: Added new screenshots for the newly added features
* Fix: Fixed styling of color picker container, plus Dashicons appearance in our help tabs and other occurrences - all caused by changes in WP 5.2.3+
* Fix: Fixed wrong function name for "Duplicator Pro" plugin support
* Fix: Fixed notices for "Login Designer" plugin support

**New, 1.4.7:** *Extended the Theme support for:*

* Twenty Twenty (free, by the WordPress.org team) - *Note: the new default theme for 2020 and WordPress 5.3+*
* Neve (free, by ThemeIsle), including plugins: *Neve Pro Addon (Premium)* and *Neve Hooks (free)* (both by ThemeIsle)
* Zakra (free, by ThemeGrill), including plugin *ThemeGrill Demo Importer (free)* (both by ThemeGrill)
* Responsive (free), including plugin *Responsive Add Ons (free)* (both by CyberChimps)
* Airi (free, by athemes)

**New, 1.4.7:** *Extended the Plugin support for Elementor Add-Ons:*

* MetForm (free, by WpMet) - *Form Builder for Elementor*
* Element Pack Lite (free, by BdThemes)
* Elements Kit Lite/Pro (free/Premium, by WpMet)
* HT Builder (free, by HasThemes/ HT Plugins)
* HT Builder Pro (Premium, by HasThemes/ HT Plugins)
* The Pack Addons (Premium, by XLDevelopment/ Web Angon/ Ashraf)

**New, 1.4.7:** *Extended the general Plugin support for:*

* HappyForms Pro (Premium, by The Theme Foundry)
* SEO for WooCommerce (free, by Rank Math)
* Flo Forms (free, by Flothemes)
* WP Crontrol (free, by John Blackbourn & crontributors) - *for Dev Mode*
* Advanced Cron Manager (free, by BracketSpace) - *for Dev Mode*

**New, 1.4.7:** *Extended Plugin support for Block Editor Add-Ons (Gutenberg):*

* Block Areas (free, by The WP Rig Contributors)
* BlockyPage Gutenberg Blocks (free, by BlockyPage Team)
* Gutentor (free, by Gutentor)


### ⚡ 1.4.6 - 2019-08-12

* [Change log v1.4.6](https://toolbarextras.com/changelog/version-1-4-6/) // [Change log v1.4.5](https://toolbarextras.com/changelog/version-1-4-5/)
* New: [Brand new Add-On for Give Donations (GiveWP) released!](https://wordpress.org/plugins/toolbar-extras-givewp/)
* New: For all changes see version 1.4.5 below 😁
* Tweak: Hot fix for update issue


### ⚡ 1.4.5 - 2019-08-12

* [Change log](https://toolbarextras.com/changelog/version-1-4-5/)
* New: Added support for Elementor Pro v2.6+ where needed ("Custom Icons" for example)
* New: Added very useful "Changelog" resource item to some supported plugins and themes, including Elementor (free) and Elementor Pro
* New: For optional "Web Group" added new 6 new services for live testing URLs - Facebook Debugger, plus 5 more Google Services!
* New: Added useful sub items to WordPress Logo/ About group, including release notes for WordPress version of your current install (dynamic!)
* New: Added theme support for "Chaplin" (free, by Anders Norén)
* New: Added ["Milestones" Page to plugin website](https://toolbarextras.com/milestones/) to list amazing achievements of this plugin project
* Tweak: For "Essential Addons" plugin support, added new resource items (videos, changelog); removed deprecated item
* Tweak: For "The Plus Addons" plugin support, added new resource items (facebook group, changelog)
* Tweak: For "JetSmartFilters" plugin support, added new items (settings, changelog)
* Tweak: For "CartFlows" plugin support, added new Setup Wizard items; removed WooCommerce dependency (since CartFlows can now also operate without it)
* Tweak: For "WooLentor" plugin support, added new item and pro version integration
* Tweak: Plugin support for "Reusable Blocks – Elementor, Beaver Builder, WYSIWYG" (free, by WebEmpire) rebranded because plugin changed its name/branding etc. (former name was: "Design Sidebar Using Page Builder")
* Tweak: Various smaller addition and tweaks for even better support of our official Add-Ons (helper functions, styles)
* Tweak: Lots of under the hood improvements on code base, and for CSS styles
* Tweak: Updated `.pot` file plus all German translations (formal, informal) and language packs
* Fix: Fixed PHP notice if setting of a default page builder enabled but the appropriate builder was deactivated meanwhile
* Fix: Duplicate function declarations

**New, 1.4.5:** *Extended the Plugin support for Elementor Add-Ons:*

* JetTabs (Premium, by Zemez Jet/ Crocoblock)
* JetBooking (Premium, by Zemez Jet/ Crocoblock) - *A special JetEngine Add-On*
* Social Addons for Elementor (Lite) (free, by WebEmpire)
* ToolKit for Elementor (Premium, by ToolKit for Elementor)
* WooLentor Pro (Premium, by HasThemes/ HT Plugins)

**New, 1.4.5:** *Extended the general Plugin support for:*

* Rank Math SEO (free, by Rank Math)
* Redirections by Rank Math (free, by Rank Math)
* 404 Monitor by Rank Math (free, by Rank Math)
* Schema Markup Rich Snippets (free, by Rank Math)


### ⚡ 1.4.4 - 2019-07-04

* [Change log](https://toolbarextras.com/changelog/version-1-4-4/)
* New: [Brand new Add-On for MainWP Dashboard released!](https://wordpress.org/plugins/toolbar-extras-mainwp/)
* New: Added 31 new Dashicons from WordPress 5.2+ to our list of Dashicons icon picker (on our settings page) - only if your install runs WordPress 5.2 or higher
* New: New resource for "Genesis Customizer" theme - Facebook Group
* New: Added optional "StudioPress/ Genesis Blue" color item for settings color picker palettes (optional, if Genesis is active)
* New: Added optional "WooCommerce Violet" color item for settings color picker palettes (optional, if WooCommerce is active)
* New: Added optional "EDD Cello" and "EDD Blue" color items for settings color picker palettes (optional, if Easy Digital Downloads (EDD) is active)
* Tweak: For "Genesis Customizer Pro" plugin support made the module logic work again to display the additional Customizer deep links
* Tweak: For Genesis theme support, special tweaks for the Customizer redirection of official Genesis theme settings
* Tweak: For "Essential Addons for Elementor" added support for version 3.x, plus new item "Tools"
* Tweak: For "WP Security Audit Log" plugin support added new item "Export/Import"
* Tweak: For "Forminator" plugin support added new settings sub items
* Tweak: For "Hustle" plugin support added new items
* Tweak: Refined resource links for Gutenberg Block Editor
* Tweak: Refined resource links for "Hello Elementor" theme support
* Tweak: Various smaller improvements on code base
* Tweak: Updated `.pot` file plus all German translations (formal, informal) and language packs
* Fix: Various smaller fixes

**New, 1.4.4:** *Extended the general Plugin support for:*

* Form Vibes (free, by WPVibes)
* Tweaks for GeneratePress (free, by John Chapman)
* Activity Log (free, by Activity Log Team)
* User Activity Log (free, by Solwin Infotech)
* Stream (free, by XWP)
* Simple History (free, by Pär Thernström)
* EditorsKit (free, by Jeffrey Carandang/ Phpbits Creative Studio)
* Site Health Manager (free, by Rami Yushuvaev)
* Site Health Tool Manager (free, by William Earnhardt)
* Pods - Custom Content Types and Fields (free, by Pods Framework Team)
* Meta Box (free, by MetaBox.io) + these Add-Ons: MB Custom Post Type, MB Custom Taxonomy, Meta Box Template, Meta Box Builder (2.x & 3.x)
* WPvivid Backup Plugin (free, by WPvivid Team)


### ⚡ 1.4.3 - 2019-05-14

* [Change log](https://toolbarextras.com/changelog/version-1-4-3/)
* *New: Successfully tested with WordPress 5.2*
* *New: Successfully tested with ClassicPress 1.0.1*
* New: [Brand new Add-On for Oxygen Builder released!](https://wordpress.org/plugins/toolbar-extras-oxygen/)
* New: Theme support for "Genesis Customizer" (free, by SEO Themes), including plugins: *Genesis Customizer Core (free)* and *Genesis Customizer Pro (Premium)* (both by SEO Themes) -- *Note: This is an awesome special Child Theme for the Genesis Framework perfectly suited for Non-Coder Designers, Non-Techies and Site Builders! ;-)*
* New: Added plugin support for additional 4 extensions of "Mai Themes for Genesis" - *Mai Favorites*, *Mai Testimonials*, *Mai Styles*, *Mai Ads & Extra Content* (all Premium, by Mike Hemberger, BizBudding Inc.)
* New: Added plugin support for Suki Sites Import (free, by SukiWP/ David Rozando)
* New: For Code Snippets plugin: optionally add all Code Snippets as submenu items, via filter ([see code snippet](https://toolbarextras.com/docs/code-snippets-listing-toolbar/))
* New: Completely refined plugin website supported [Themes](https://toolbarextras.com/theme-support/), [Plugins](https://toolbarextras.com/plugin-support/), [Elementor Add-Ons](https://toolbarextras.com/elementor-addons-support/) and [Gutenberg Block Editor Add-Ons](https://toolbarextras.com/gutenberg-block-editor-support/) listings - all are now powered by dynamic data, are fully updated, and got search filters (for title)
* New: Created [listing of abandoned plugins](https://toolbarextras.com/docs/support-policy-for-abandoned-plugins/) where the integration in Toolbar Extras is set for deprecation and therefore future removal - [see Support Article on plugin's website](https://toolbarextras.com/docs/support-policy-for-abandoned-plugins/)
* New: Integrated with WordPress 5.2+ new Site Health feature: Toolbar Extras now has an extra section on the Debug Info tab - this is especially helpful for support requests
* New: Above mentioned Debug Info also appears on "Debug Info" in "Health Check" plugin for WordPress versions below 5.2 -- *Note: Health Check items won't appear in WP 5.2, though!*
* New: Added Site Health & Debug items to Site Group as well (WP 5.2+ required)
* New: Added few subtle tweaks for even better support for ClassicPress, color item, some labels, Plugin Installer etc.
* New: Added formal German translation for Readme on WordPress.org (this will optionally be shown in plugin installer in Admin)
* Tweak: Set proper parent menu and submenu highlighting relationship for our additional Plugin and Theme uploader menus (via Dev Mode)
* Tweak: Further refined Gutenberg Block Editor support, additional Admin menu item, plus submenu
* Tweak: Enhanced "GeneratePress" theme support - more Customizer deep links, more resources
* Tweak: Refined "Hello Elementor" theme support - to also integrate with new [theme version from wordpress.org](https://wordpress.org/themes/hello-elementor/)
* Tweak: For "AnalogWP Templates" plugin support added their new Style Kits feature as items
* Tweak: For "Envato Elements" plugin support updated their admin URLs, added new resources for the service
* Tweak: For "WPForms" plugin support added another third-party integration; plus other minor enhancements
* Tweak: For "Schema Pro" plugin support added new optional Breadcrumb item
* Tweak: For "Atomic Blocks" plugin support added new Settings item
* Tweak: For "Essentail Premium Addons for Elementor" (by wpcodestar) plugin support added new API Settings item
* Tweak: For "Ultimate Blocks" plugin support added new item and resource
* Tweak: For "A/B Testing for WordPress" plugin support added new item
* Tweak: For "Piotnet Addons for Elementor (PAFE)" added optional "Forms Database" item - optionally also add items to Forms hook place in Site Group
* Tweak: For "Elementor Contact Form DB" plugin support added new items and resources - *Note: [The plugin is finally available on wordpress.org!](https://wordpress.org/plugins/sb-elementor-contact-form-db/)*
* Tweak: Refined plugin support for "Premium Addons for Elementor" (by Leap13) to make it work better (and again)
* Tweak: Enhanced "Genesis Design Palette Pro" plugin support - new "Fonts" item, plus 3 free Add-Ons integrated
* Tweak: Enhanced plugin support for "Mailchimp for WP" - added support for 7 more of their integrations
* Tweak: Enhanced theme & (pro) plugin support for "Suki" theme
* Tweak: Added Twenty Nineteen support to supported themes of "Themer Pro" plugin (since v1.1.0+ of Themer Pro!)
* Tweak: Changed wording for "PithyWP Templates" plugin support after their subtle renaming
* Tweak: Added our "Add-Ons" settings tab to our Elementor Finder feature support
* Tweak: On our "About & Support" admin page, integrated with *Site Health Debug Info* for support purposes
* Tweak: Improved Multisite support for Plugin & Theme Uploader pages
* Tweak: Reorganized compatibility functions/ layer behind the scenes, for plugins etc.
* Tweak: Correct logic behind optional Gallery/Slider plugin hook place so it doesn't appear as empty item any longer
* Tweak: Refined recommended Gutenberg-specific plugins for "Plugin Installer Recommendations" library
* Tweak: Remove "Jetpack Ads" as far as possible (since Jetpack 7.1+)
* Tweak: Remove "WooCommerce Ads/ Suggestions" as far as possible (since WooCommerce 3.6+)
* Tweak: Updated bundled library DDWlib Plugin Installer Recommendations to latest version (v1.4.1) - feature updates
* Tweak: Updated `.pot` file plus all German translations (formal, informal) and language packs

**New, 1.4.3:** *Extended the Plugin support for Elementor Add-Ons:*

* Flexible Elementor Panel (free, by Alex Shram/ Flexible-Elementor-Panel.com)
* Multidomain Support for Elementor (free, by Alex Zappa)
* Bestfreebie Elementor Icons (free, by Bestfreebie)
* The Plus Addons for Elementor Lite/Pro (free/Premium, by POSIMYTH Themes)
* Unlimited Elements for Elementor Lite/Pro (free/Premium, by Blox Themes)
* WooLentor - WooCommerce Elementor Addons + Builder (free, by HT Plugins)
* Advamentor (free, by Themexa)
* DT WooCommerce Page Builder for Elementor (Premium, by DawnThemes)
* Clever Mega Menu for Elementor (free, by CleverSoft)

**New, 1.4.3:** *Extended the general Plugin support for:*

* GP Related Posts (free, by Jon Mather)
* [GP Elements Disable (free, by Jon Mather)](https://github.com/WestCoastDigital/gp-elements-disable)
* WordPress Color Picker Enhancement (free, by P. Roy)
* Advanced Custom Fields (free, by Elliot Condon) - *Note: only ACF version 5.x or higher! (v4.x not supported!)*
* Advanced Custom Fields Pro (Premium, by Elliot Condon)
* Advanced Custom Fields: Extended (free, by ACF Extended) - *Note: a third-party ACF Pro Add-On*
* Advanced Forms (free, by Fabian Lindfors/ Hookturn Digital Pty Ltd) - *Note: a third-party ACF Pro Add-On*
* Custom Field Suite (free, by Matt Gibbs)
* Shortcoder (free, by Aakash Chakravarthy)
* Imagify Image Optimizer (free, by WP Media)
* ShortPixel Image Optimizer (free, by ShortPixel)
* Smush Image Compression and Optimization (free, by WPMU DEV)
* EWWW Image Optimizer (free, by Exactly WWW)
* Compress JPEG & PNG Images (free, by TinyPNG)
* Design Sidebar Using Page Builder (free, by WebEmpire) - *for Elementor, Beaver Builder, Classic Editor*

**New, 1.4.3:** *Extended Plugin support for Block Editor Add-Ons (Gutenberg):*

* CoBlocks (Page Builder Gutenberg Blocks) (free, by CoBlocks)
* Otter Blocks (Gutenberg Blocks and Template Library) (free, by ThemeIsle)
* Block Style Guides for Gutenberg (free, by Robert Gillmer)
* Add RichText Toolbar Button (free, by Technote)


### ⚡ 1.4.2 - 2019-03-31

* [Change log](https://toolbarextras.com/changelog/version-1-4-2/)
* New: Added "Add-Ons" tab to plugin's settings page, featuring official, supported and recommended Add-Ons -- preparing for first official Add-On release(s) ;-)
* New: Lots of additions and refinements under the hood to make official Add-Ons work smarter (extends the groundwork from v1.4.0)
* New: Tweaks and additions for (optional) post type archive items, plus new sub items, including special support for Genesis CPT Archive Settings
* New: [The plugin now has its own Supporter page on Patreon.com](https://www.patreon.com/deckerweb) - become a patron and support ongoing development
* New: [The plugin now hat its own Instagram channel](https://www.instagram.com/toolbarextras) - please follow us and like our content
* New: [The plugin now hat its own Twitter account](https://twitter.com/toolbarextras) - please follow us and like & retweet our tweets
* New: Added generic, reusable class to better support/integrate generic post types from plugins and themes
* New: Added optional "My Plugin Manager" library by Theme Blvd for the upcoming Add-Ons for Toolbar Extras to manage plugin dependencies and suggestions
* *New: Successfully tested with WordPress 5.1.1*
* Tweak: Refined core support for Block Editor (Gutenberg) in some minor areas/ aspects
* Tweak: Refined settings sections internally that only display conditionally for certain supported third-party plugins
* Tweak: Further optimized admin settings pages, including the branding/ styling
* Tweak: Enhanced plugin support for "JetEngine" - integrated new Booking Forms module
* Tweak: Enhanced plugin support for "Essential Addons for Elementor" (by WPDeveloper/ Codetic)
* Tweak: Enhanced plugin support for "Builder Template Categories"
* Tweak: Enhanced plugin support for "MailChimp for WP"
* Tweak: Implemented admin URL change for "Ultimate Addons for Elementor" plugin support
* Tweak: Implemented admin URL change for "Ultimate Addons for Gutenberg" plugin support
* Tweak: Greatly enhanced theme support for "OceanWP" (Customizer deep links)
* Tweak: Added developer resources for "Genesis" theme support
* Tweak: Changed item links for "Mai Theme" theme support (Genesis-specific)
* Tweak: Changed item link for "Epic News Elements" plugin support
* Tweak: Changed resource links for "Element Pack" plugin support where needed
* Tweak: Re-enabled plugin support for "Code Snippets" plugin after latest Code Snippets update(s)
* Tweak: Local Development Environment feature: now also supports the constant `WP_LOCAL_DEV` from WordPress Core
* Tweak: Dev Mode: Added new resource for Child Themes
* Tweak: Replaced "Google+" sharing with "LinkedIn" on the "About & Support" page (as Google+ gets shut down in April 2019)
* Tweak: Small improvements and tweaks to the core plugin
* Tweak: Updated bundled library DDWlib Plugin Installer Recommendations to latest version (v1.3.0) - feature updates
* Tweak: Updated bundled library Persistant Admin notices Removal to latest version (v1.4.3)
* Tweak: Updated bundled library Astra Notices to latest version (v1.1.2)
* Tweak: Updated `.pot` file plus all German translations (formal, informal) and language packs
* Fix: Notice for Element IDs (Dev Mode) on post type archive on frontend

**New, 1.4.2:** *Extended the Theme support for:*

* Layers for Elementor (free, by Elementor Team/ Elementor Ltd.)
* Woostify (free, by BoostifyThemes), including plugins: *Woostify Sites Library (free)* and *Woostify Pro Add-On (Premium)* (both by BoostifyThemes)
* Zita (free, by WpZita team), including plugins: *Zita Site Library (free)* and *Zita Pro Add-On (Premium)* (both by WpZita team)
* Stackable (free, by Gambit Technologies, Inc.)
* Futurio (free, by FuturioWP), including plugins: *Futurio Extra (free)* and *Futurio Pro (Premium)* (both by FuturioWP)
* Jupiter X (Premium, by Artbees), including plugin: *Raven (Premium)*
* Rife Free & Rife Pro (free/Premium, by Apollo13Themes), including plugins *Apollo13 Framework Extensions (free)* and *Rife Elementor Extensions & Templates (free)* (both by Apollo13Themes)
* Sane (free) and Sane Pro (Premium) (both by Elegant Marketplace)
* Storefront (free, by Automattic, Inc.)
* Revolution Pro (Premium, by StudioPress), a Child Theme for Genesis
* Hello Pro 2 (Premium, by brandiD), a Child Theme for Genesis
* Jessica (Premium, by 9seeds, LLC), a Child Theme for Genesis
* Kreativ Pro (Premium, by ThemeSquare), a Child Theme for Genesis
* Divine (Premium, by Restored 316 Designs // Lauren Gaige), a Child Theme for Genesis
* Pretty Chic (Premium, by Lindsey Riel), a Child Theme for Genesis
* Stag Blocks (free, by Codestag)
* Rooten (Premium, by BdThemes)

**New, 1.4.2:** *Extended the Plugin support for Elementor Add-Ons:*

* JetCompareWishlist (Premium, by Zemez Jet/ Crocoblock)
* HT Mega - Ultimate Addons for Elementor (free, by HT Plugins)
* Elementor Forms (Premium, by Elementor Forms)
* RabbitBuilder Global Central JS CSS (free, by RabbitBuilder)
* AnalogWP Templates (free, by AnalogWP)
* Layouts for Elementor (free, by Giraphix Creative)
* WPB Elementor Addons (free, by wpbean)
* Exclusive Addons for Elementor (free, by DevsCred)
* PDF Generator for Elementor (free, by RedefiningTheWeb)
* Essentail Premium Addons for Elementor (free, by wpcodestar)
* Sina Extension for Elementor (free, by shaonsina)
* Smart Fonts for Elementor (free, by codevision)

**New, 1.4.2:** *Extended the general Plugin support for:*

* HTML Forms (free, by ibericode)
* Torro Forms (free, by Awesome UG)
* BuddyForms (free, by ThemeKraft)
* Contact Form X (free, by Jeff Starr)
* Jetpack (free/Premium, by Automattic, Inc./ WordPress.com) - *including additionally added submenu items (otherwise missing), and extensive resources*
* Max Mega Menu (free, by Tom Hemsley)
* QuadMenu (free, by QuadMenu)
* [The SEO Framework - Extension Manager](https://theseoframework.com/extension-manager/) (free, by Sybre Waaijer)
* Shariff Wrapper (free, by Jan-Peter Lambeck & 3UU)
* Post SMTP (free, by Yehuda Hassine) - *Plugin formerly known as Postman*
* WP Mail SMTP (free, by WPForms)
* Instagram Feed (Pro) (free/Premium, by Smash Balloon)
* Genesis Responsive Slider (free, by StudioPress), a plugin for Genesis
* CartFlows (free, by CartFlows Inc) - *For Elementor, Beaver Builder, Divi, Gutenberg Block Editor*
* Pithy Templates (free, by Pithy WP) - *For Elementor currently*

**New, 1.4.2:** *Add-Ons for the Storefront Theme:*

* Storefront Powerpack (Premium, by WooCommerce/ Automattic, Inc.)
* Storefront Blog Customiser (Premium, by WooCommerce/ Automattic, Inc.)
* Storefront Parallax Hero (Premium, by WooCommerce/ Automattic, Inc.)
* Storefront Product Hero (Premium, by WooThemes/ Automattic, Inc.)
* Storefront Pricing Tables (Premium, by WooCommerce/ Automattic, Inc.)
* Storefront Homepage Contact Section (free, by WooThemes/ Automattic, Inc.)
* Storefront Footer Bar (free, by WooThemes/ Automattic, Inc.)
* Storefront Blog Excerpt (free, by Wooassist)
* Storefront Top Bar (free, by Wooassist)
* Storefront Site Logo (free, by Wooassist)
* Storefront Footer Copyright Text (free, by QuadMenu)
* Storefront Hooks Customizer (free, by mikeyarce)
* Storefront Google Fonts (free, by Atlantis Themes)

**New, 1.4.2:** *Extended Plugin support for Block Editor Add-Ons (Gutenberg):*

* Ghost Kit (free, by nK)
* Cosmic Blocks (free, by Cosmic WP)
* WP Block Pack (free, by Falcon Theme)
* Easy Blocks for Gutenberg (free, by Liton Arefin)
* A/B Testing for WordPress (free, by CleverNode)
* Easy Blocks PRO (free, by Seerox)
* WooCommerce Custom Email Blocks (free, by VillaTheme)
* Qubely Blocks (free, by Themeum)
* Bootstrap Blocks for WP Editor (free, by Virgial Berveling)
* Guten-bubble (free, by Chronoir.net)


### ⚡ 1.4.1 - 2019-03-05

* [Change log](https://toolbarextras.com/changelog/version-1-4-1/)
* *New: Successfully tested with WordPress 5.1*
* Tweak: Added new resource link for "Elementor Extras" (by Namogo) plugin support
* Tweak: Added new developer resource link for "WPForms" plugin support
* Tweak: Changed GitHub resource links for Elementor support to new the URLs
* Tweak: Switched the Customizer and Admin link positions for "Nav Menus" in the Site Group
* Tweak: Updated `.pot` file plus all German translations (formal, informal) and language packs
* Fix: Removing of WordPress Widgets from Elementor Live Editor (panel) now works again, especially with Elementor 2.5.0 or higher - thanks to user feedback ([Topic](https://wordpress.org/support/topic/remove-wordpress-widgets-incompatible-with-elementor-2-5/))


### 🎉 1.4.0 - 2019-01-14

* [Change log](https://toolbarextras.com/changelog/version-1-4-0/)
* New: Full support for WordPress 5.0+ new Block Editor (Gutenberg) - set as default "Page Builder" integration (for Toolbar); also supported are popular plugins "Classic Editor" and "Disable Gutenberg" plugins
* New: Lots of additional resource links for Block Editor (Gutenberg) added (can be disabled like other resources)
* New: Support for dozens of Block Editor specific Gutenberg Add-On plugins and themes now built-in - see appropriate changelog sections below -- the add-on support can be disabled via plugin's settings
* New: You can now set a default Page Builder (in General settings tab) - perfect if you are using the new Block Editor (Gutenberg) for posts but Elementor Page Builder for everything else - this is also in preparation for upcoming Add-Ons for other Page Builders
* New: Add new items to the WP Comments Group - as well as the popular newcomer "Thrive Comments" plugin - additional items can be disabled via plugin's settings
* New: Add plugin support for "Thrive Comments" (Premium, by Thrive Themes) - if active it replaces the comments moderation link in the Toolbar with the Thrive Comments Moderation queue, which is only logical (and natural then) - of course this integrates with the before mentioned WP Comments Group support as well :)
* New: Customize the Howdy/Welcome item on top right corner - replace "Howdy" word, or use complete custom strings; set custom URL
* New: Greatly enhanced the "Fallback" item (instead of Main item, in "Build" Group) - if no supported Page Builder active, you can now still set a different icon, name and even URL
* New: For Main Item (Build Group) you can now optionally set a custom URL, including the URL target
* New: Added more detailed help tabs and enhanced help content throughout - also improved user guidance on different areas of the plugin
* New: On user profile pages added short info/description and link to plugin's settings page (to adjust more stuff for the Toolbar)
* New: For Dev Mode - add additional sub page under "Appearance" for the Theme Installer ZIP Uploader - more convenient for admins and site builders testing themes during development phases for example :)
* New: For Dev Mode - add additional sub page under "Plugins" for the Plugin Installer ZIP Uploader - more convenient for admins and site builders installing and/or testing (premium) plugins
* New: For Dev Mode - added (optional) "ID" sub item for viewing Archives, Singles, Taxonomies - makes it easier to determine the ID of a given object/item - and avoids yet another plugin
* New: For Dev Mode - added "Newest Plugins" to the plugin installer sub items in the Toolbar (developers often need to test new plugins, this new item saves them a few clicks!)
* New: For Dev Mode - added "Newest Themes" to the theme installer sub items in the Toolbar (developers often need to test new themes, this new item saves them a few clicks!)
* New: Prepared plugin internally for its first (upcoming) Add-On plugin
* New: Added full support for newest features and changes coming with Elementor v2.4.0+, including Elementor Pro v2.4.0+
* New: Added "Toolbar Extras" integration with "Elementor Finder" feature - the interactive search since Elementor v2.3.0+
* New: Added official and third-party external "Elementor Resources" to the Elementor Finder feature
* New: Added the Elementor Tools tasks for "Regnerating CSS" (clear cache) and re-syncing the (external) Template Library to the Toolbar - ***Note:** this is only available within the Admin context, not on the Frontend Toolbar!*
* New: Added full plugin support for Yoast SEO and Yoast SEO Premium, including re-hooking from the top-level to the Site Group (optional Smart Tweak)
* New: Added "Toolbar Tools" submenu to "Tools" (currently pointing to our "Smart Tweaks")
* New: Added CSS styling to fix the overflow issue from WordPress Core, with too many top-level Toolbar items, for screens/viewports equal or wider than 783px
* New: Added full Theme support for "Suki" (free), including all current features of the optional Suki Pro Add-On plugin (Premium) (both by SukiWP/ David Rozando)
* New: Added plugin support for "Easy Updates Manager" (free, by Easy Updates Manager Team) - plus a Smart Tweak to remove the top-level Toolbar item of the plugin
* New: Successfully tested with latest WordPress versions 5.0.3 and 5.0.2 before
* Tweak: Updated and further improved the styling of the plugin's settings page: easier to visually distinct various settings sections and fields - also included: better support for the "Dark Mode" plugin
* Tweak: Added new external site check service "Load Impact" to the Web Group (optional Smart Tweak)
* Tweak: Added submit/test Site URLs or Singular URLs for "GTmetrix", "Google PageSpeed Insights" and "Load Impact" for the Web Group (optional Smart Tweak)
* Tweak: Again, greatly enhanced plugin support for "Genesis Design Palette Pro" - with sub section links, plus Customizer deep links (if enabled)
* Tweak: Greatly enhanced "Customify" Theme support - added more Toolbar items, as well as all new Pro Modules (via Customify Pro Add-On plugin)
* Tweak: Improved and updated "OceanWP" Theme support, including some Add-Ons (Demos, Wizard, Posts Slider etc.)
* Tweak: Enhanced "SEOPress" plugin support with re-hook setting feature (optional Smart Tweak) to move items from top-level to the Site Group
* Tweak: Switched the Customizer and Admin link positions for "Widgets" in the Site Group
* Tweak: Enhanced "JetEngine" plugin support - which is out of beta - added Meta Boxes, Post Relations
* Tweak: Enhanced "Everest Forms" plugin support - added individual form preview links that are now available within Everest
* Tweak: For "WP Schema Pro" plugin support - respect the advanced setting of menu position (dynamic)
* Tweak: Improved "Mai Lifestyle Pro" Theme support - better integration for its "Mai Theme Engine" plugin, plus integration of "Mai Demo Importer" Add-On
* Tweak: Optimized "Genesis" overall Theme support when using lots of sub items from child theme and various supported plugins 
* Tweak: Enhanced "Astra" Theme support - added EDD Customizer module
* Tweak: Enhanced "Elementor Hello" Theme support
* Tweak: Enhanced "Page Builder Framework" Theme support - new "White Label" feature via WPBF Premium Add-On
* Tweak: Improved string rendering & translations for some of the supported form builder plugins
* Tweak: Improved plugin support for "Livemesh Addons for Elementor Premium"
* Tweak: Enhanced plugin support for "WooCommerce"
* Tweak: Enhanced plugin support for "WPForms" (Lite) and "WPForms Pro"
* Tweak: Enhanced plugin support for "WP Synchro"
* Tweak: For color picker set color palette with appropriate predefined colors (Toolbar color in "Local Development Environment" settings)
* Tweak: For my own plugin, ["Builder Template Categories"](https://wordpress.org/plugins/builder-template-categories/), added it to the full Block Editor (Gutenberg) integration
* Tweak: For Dev Mode - added new resource item (Block Editor Handbook)
* Tweak: Added some new translator inline comments, and improved some existing ones
* Tweak: Updated bundled library Persistant Admin notices Removal to latest version (v1.4.2) - ***Important:** you may need to dismiss the notices once again*
* Tweak: Enhanced plugin recommendations (powered by DDWlib Plugin Installer Recommendations)
* Tweak: Updated `.pot` file plus all German translations (formal, informal) and language packs
* Tweak: Enhanced, improved and corrected Readme.txt file here - also added new FAQ entry
* Fix: Minor HTML markup issues on the settings page

**New, 1.4.0:** *Extended the Theme support for:*

* Atomic Blocks (free, by Atomic Blocks/ Array Themes)
* Editor Blocks (free, by Editor Blocks/ Danny Cooper)
* Twenty Nineteen (free, by the WordPress.org team) - *Note: the new default theme since WordPress 5.0+*
* Mai Law Pro (Child Theme for Genesis) (Premium, by Mike Hemberger, BizBudding Inc.)
* CoBlocks (free, by Rich Tabor of CoBlocks)
* Sydney (free, by athemes)
* Suki (free, by SukiWP/ David Rozando) - including Suki Pro Add-On plugin (Premium, by SukiWP/ David Rozando)
* Visual Composer Starter (free, by The Visual Composer Team)

**New, 1.4.0:** *Extended the Plugin support for Elementor Add-Ons:*

* JetWidgets For Elementor (free, by Crocoblock/ Zemez Jet)
* JetWoo Widgets For Elementor (free, by Crocoblock/ Zemez Jet)
* Custom Icons for Elementor (free, by Michael Bourne)
* Widgets For Elementor (free, by maxster)
* Envato Elements – Template Kits (Beta) (free, by Envato) - *Also integration in New Content installer*
* StylePress for Elementor (free, by David Baker (dtbaker)) - *Note: only for plugin version v1.2.1 or higher!*
* Formentor – Elementor Form Plus (free, by Tziki Trop)
* JetPopup (Premium, by Zemez Jet/ Crocoblock)
* JetSmartFilters (Premium, by Zemez Jet/ Crocoblock)
* JetDesignKit (Premium, by Zemez Jet/ Crocoblock)
* JetWooProductGallery (Premium, by Zemez Jet/ Crocoblock)
* GT3 Elementor Photo Gallery (free, by GT3 Themes)
* Opal Megamenu for Elementor (free, by wpopal)
* Opal Widgets for Elementor (free, by wpopal)
* [Elementor White Label](https://github.com/namncn/elementor-white-label) (free, by Nam Truong, PhoenixDigi Việt Nam)
* [Elementor White Label Pro](https://namncn.com/plugins/elementor-white-label/) (Premium, by Nam Truong, PhoenixDigi Việt Nam)
* Elementor White Label Branding (free, by Ozan Canakli)
* PowerPack Lite for Elementor (free, by IdeaBox Creations)

**New, 1.4.0:** *Introduced Plugin support for Block Editor Add-Ons (Gutenberg):*

* Disable Gutenberg (free, by Jeff Starr)
* Custom Fields for Gutenberg (free, by Jeff Starr)
* Block Lab (free, by Block Lab)
* Advanced Custom Blocks (free, by Rheinard Korf, Luke Carbis, Rob Stinson)
* WP Block Ink (free, by Dave Ryan)
* Lazy Blocks – Gutenberg Blocks Constructor (free, by nK)
* Advanced Gutenberg (free, by JoomUnited)
* Advanced Gutenberg Blocks (free, by Maxime Bernard-Jaquet)
* Amazon Block (free, by Ryo Utsunomiya)
* Block Options (free, by Phpbits Creative Studio)
* Blocks Google Map (free, by Govind Kumar)
* Blocks Layouts (free, by Jordy Meow)
* Atomic Blocks (free, by Atomic Blocks/ Array Themes)
* Editor Blocks (free, by Editor Blocks/ Danny Cooper)
* Disable Gutenberg Blocks (free, by Danny Cooper)
* Cloud Blocks (free, by Frontkom - Fouad Yousefi) - *Also integration in New Content installer*
* Placeholder Block (free, by Square Happiness)
* Ultimate Addons for Gutenberg (free, by Brainstorm Force)
* Gutenberg Ramp (free, by Automattic, Inc.)
* Custom Color Palette for Gutenberg (free, by ThemeZee)
* Ultimate Blocks (free, by Imtiaz Rayhan)
* Theme Support for Gutenberg (free, by wpweaver)
* Enable Gutenberg Theme Support (free, by Israel Escuer, Jose Angel Vidania)
* UltraBlocks Free/Pro (free/Premium, by FestPlugins)
* Kadence Blocks - Gutenberg Page Builder Toolkit (free, by Kadence WP)
* Stag Blocks (free, by Codestag)
* GutenBeGone (free, by Lee Rickler)
* Gutenberg Manager (free, by unCommons Team)
* Unregister Gutenberg Blocks (free, by Luke Kowalski)
* WPBlocks (free, by WPBlocks)
* Gutenberg Templates (Block Templates) (free, by Konstantinos Galanakis)
* Stackable Gutenberg Blocks (free, by Gambit Technologies, Inc.)
* Caxton (free, by PootlePress)
* WE Blocks (free, by wordpresteem)
* Premium Blocks for Gutenberg (free, by Leap13)
* Elegant Blocks (free, by ravisakya, cyclonetheme)

**New, 1.4.0:** *Extended the Genesis Plugin support for:*

* Mai Demo Importer (free, by Mike Hemberger, BizBudding Inc.) - *An Add-On for the "Mai Themes" for Genesis*
* Genesis Super Customizer (free, by Mario Giancini) - *Note: only version 1.2.2 or higher supported*
* Genesis Simple Share (free, by StudioPress)
* Genesis Simple FAQ (free, by StudioPress)
* Genesis Featured Image Header (free, by Scott DeLuzio)
* Easy Genesis (free, by Doug Yuen)
* Easy Genesis - Pages Extension (free, by Doug Yuen)

**New, 1.4.0:** *Extended the general Plugin support for:*

* IconPress Lite (free, by IconPress Team)
* IconPress Pro (Premium, by IconPress Team)
* Iris Color Picker Enhancer (free, by Maeve Lander)
* Custom Swatches for Iris Color Picker (free, by Iceberg Web Design)
* Yoast SEO (free, by Team Yoast)
* Yoast SEO Premium (Premium, by Team Yoast)
* Catch Import Export (free, by Catch Plugins)
* MainWP Child (free, by MainWP)
* MainWP Child Reports (free, by MainWP)
* WP Security Audit Log (free, by WP White Security)
* Thrive Comments (Premium, by Thrive Themes)
* Forminator (Pro) (free/Premium, by WPMU DEV)
* Form Maker (free, by WebDorado Form Builder Team)
* MailPoet 3 (free, by MailPoet)
* MailPoet Newsletters (Previous) (Version 2, Legacy) (free, by MailPoet)
* Mailster (Premium, by EverPress)
* Epic News Elements (Premium, by Jegtheme) - *An Add-On for Elementor, Block Editor (Gutenberg) and WPBakery Page Builder (old Visual Composer)*
* Classic Editor (free, by WordPress Contributors)
* Export Import Menus (free, by Akshay Menariya)
* Entries For WPForms (free, by Sanjeev Aryal)
* Hummingbird (free, by WPMU DEV)
* Hummingbird Pro (Premium, by WPMU DEV)
* Redirection (free, by John Godley)
* Safe Redirect Manager (free, by 10up)
* SEO Redirection (free, by Fakhri Alsadi)
* Easy Updates Manager (free, by Easy Updates Manager Team)
* Easy Login Styler Pro (Premium, by Phpbits Creative Studio)
* Login Designer (free, by Rich Tabor from ThatPluginCompany)
* WP Mobile Menu (free, by Takanakui)
* Simple Links (free, by Mat Lipe)
* Error Log Viewer (free, by BestWebSoft) - for Dev Mode
* The SEO Framework (free, by Sybre Waaijer)


### ⚡ 1.3.10 - 2018-12-30 

* [Change log](https://toolbarextras.com/changelog/version-1-3-10/)
* Tweak: Open plugin's newsletter link in new browser tab
* Fix: Correct function names for plugin support of "Genesis Custom Headers" and "Genesis Extra Settings Transporter"
* Fix: Correct admin URL for Piotnet Addons plugin support


### ⚡ 1.3.9 - 2018-12-23

* [Change log](https://toolbarextras.com/changelog/version-1-3-9/)
* *New: Successfully tested with WordPress 5.0.2*
* New: Added plugin support for my own plugin, Genesis Extra Settings Transporter (free, by David Decker - DECKERWEB)
* New: Added plugin support for my own plugin, WP Document Revisions Simple Downloads (free, by David Decker - DECKERWEB)
* New: Added plugin support for WP Document Revisions (free, by Ben Balter)
* New: Added plugin support for Piotnet Addons For Elementor (PAFE) (Pro) (free/Premium, by Luong Huu Phuoc (Louis Hufer))
* New: Added plugin support for Genesis Custom Headers (free, by Nick Diego)
* New: Added plugin support for Custom Importer & Exporter (free, by Protech.Inc)
* New: [Join my newsletter for DECKERWEB WordPress Plugins](https://eepurl.com/gbAUUn) - insider info, plus tutorials and more useful stuff
* Tweak: Make the Smart Tweaks for unloading translations limited to logged-in users - thanks to user feedback ([Topic](https://wordpress.org/support/topic/elementor-unload-language-only-for-logged-in-user/))
* Tweak: Enhanced settings page feature description for translations unloading Smart Tweak
* Tweak: Added new resource for "Code Snippets" plugin support (Facebook Community User Group)
* Tweak: Updated `.pot` file plus all German translations (formal, informal) and language packs
* Tweak: Enhanced, improved and corrected Readme.txt file here :)


### ⚡ 1.3.8 - 2018-12-11

* [Change log](https://toolbarextras.com/changelog/version-1-3-8/)
* New: Successfully tested with WordPress 5.0.0 major release version
* New: Added our plugin version to the "Right Now" text in the "At a Glance" Dashboard Widget
* New: Added Plugin support for Transients Manager (free, by Pippin Williamson) - for Dev Mode
* Tweak: Refactored the feature for optionally unloading the translations for "Toolbar Extras", "Elementor", "Elementor Pro" plugins - now it should work under all circumstances ([Topic](https://wordpress.org/support/topic/unloading-of-languages-not-working-anymore/))
* Tweak: Enhanced "Page Builder Framework" theme support - new "Custom Sections" via WPBF Premium Add-On
* Tweak: Improved "WPForms" plugin support (Lite & Pro), to include version 1.5.x or higher
* Tweak: Refactored logic for displaying the review link on plugin's settings pages
* Tweak: Submit button tweaks (settings page)
* Tweak: Updated `.pot` file plus all German translations (formal, informal) and language packs


### ⚡ 1.3.7 - 2018-11-20

* [Change log](https://toolbarextras.com/changelog/version-1-3-7/)
* New: Successfully tested with WordPress 5.0 Beta 5
* New: Added Plugin support for Genesis Simple Edits (free, by StudioPress)
* New: Added Plugin support for Genesis Footer Builder (free, by Shivanand Sharma)
* New: Added Plugin support for Genesis Accessible (free, by Rian Rietveld, Robin Cornett)
* New: Added Plugin support for Genesis Grid (free, by Bill Erickson)
* New: Added Markdown Readme.md to `/languages/` folder also (great for Translators and Developers)
* Tweak: Reworked latest post logic for "Display Related Posts for Genesis" Plugin support
* Tweak: Prepare admin notices for upcoming PAnD library changes
* Tweak: Updated bundled library DDWlib Plugin Installer Recommendations to latest version (v1.2.1) - CSS fixes
* Tweak: Updated `.pot` file plus all German translations (formal, informal) and language packs
* Fix: Proper `$media` param for wp_register_style() occurrences
* Fix: Proper file including for some supported Genesis child themes
* Fix: Added forgotten setting from v1.3.0 to the settings updater routine to avoid PHP notice
* Fix: Changed few `translators` comments in code to properly trigger the language pack creation on WordPress.org for some translateable strings


### ⚡ 1.3.6 - 2018-10-30

* [Change log](https://toolbarextras.com/changelog/version-1-3-6/)
* New: Successfully tested with WordPress 5.0 Beta 1
* Tweak: Updated bundled library DDWlib Plugin Installer Recommendations to latest version (v1.2.0) - which brings enhanced CSS styles, including for the "Dark Mode" plugin
* Tweak: Few internal code tweaks and improvements
* Tweak: Enhanced and improved Readme.txt file here - also added new FAQ entry


### ⚡ 1.3.5 - 2018-10-02

* [Change log](https://toolbarextras.com/changelog/version-1-3-5/)
* New: Added plugin support for my very own plugin, Builder Template Categories (free, by David Decker - DECKERWEB) - for all integrations relevant for Toolbar Extras plugin
* New: Added & verified plugin support for WPForms Pro versions (Premium, by WPForms)
* New: Added theme support for Breakthrough (Premium, by StudioPress), a Child Theme for Genesis
* New: Added plugin support for my own plugin, Genesis Widgetized Not Found & 404 (free, by David Decker - DECKERWEB)
* New: Added plugin support for my own plugin, Genesis Layout Extras (free, by David Decker - DECKERWEB)
* New: Added Plugin support for Display Related Posts for Genesis (free, by SEO Themes)
* Tweak: Added "Blog" panel deep link to Page Builder Framework Theme support, Customizer items
* Tweak: Added missing `$page` variable to Theme Uploader tab, to avoid any errors/notices and to exactly fullfill WP Core parameters
* Tweak: Fixed an internal date function so it brings correct results under edge cases
* Tweak: Updated bundled library DDWlib Plugin Installer Recommendations to latest version (v1.1.0) - which brings smaller additions and enhancements, like CSS styles to the upload areas and plugin cards, plus plugin version number on plugin cards
* Tweak: Updated `.pot` file plus all German translations (formal, informal) and language packs


### ⚡ 1.3.4 - 2018-08-30

* [Change log](https://toolbarextras.com/changelog/version-1-3-4/)
* New: Added `composer.json` file to the plugin's root folder - this is great for developers using Composer
* New: Added `README.md` file for plugin's GitHub.com repository to make it more readable there
* New: Added plugin update message also to Plugins page (overview table)
* Tweak: Enhanced "WP-Staging" plugin support - added dynamic list of staging clones, plus, added support for "WP-Staging Pro" version
* Tweak: Enhanced "JetEngine" plugin support - which is out of beta now! (added Meta Boxes)
* Tweak: For "WP Schema Pro" plugin support - respect the advanced setting of menu position (dynamic)
* Tweak: Improved plugin compatibility with sister-plugin "Multisite Toolbar Additions"
* Tweak: Added plugins recommendations library by deckerweb to improve the plugin installer tips (old filter function got removed)
* Tweak: Enhanced, improved and corrected Readme.txt file here
* Tweak: Updated `.pot` file plus all German translations (formal, informal) and language packs


### ⚡ 1.3.3 - 2018-08-08

* [Change log](https://toolbarextras.com/changelog/version-1-3-3/)
* New: Verified support for Business accounts on WordPress.com platform which support installation of other plugins (like Toolbar Extras) - [check the full tutorial on our plugin website](https://toolbarextras.com/docs/how-to-use-toolbar-extras-plugin-on-wordpress-com/)
* Tweak: Improved and corrected Readme.txt file here
* Fix: Respect namespaced classes in "PowerPack Elements" plugin support for their v1.3.4+ release


### ⚡ 1.3.2 - 2018-07-29

* [Change log](https://toolbarextras.com/changelog/version-1-3-2/)
* New: Added "Elements" to the "GeneratePress" Theme support for the Premium Add-On v1.7 or higher (including backwards compat for Page Headers and Hooks)
* New: First few features & tweaks to support the Block Editor (known as "Gutenberg") which is planned for upcoming WordPress 5.0: if "Gutenberg" plugin is active offer an "Editor switch" between "Block Editor" (Gutenberg) and "Classic Editor" when editing any post type content (which in general needs to have post type support for the Editor) -- Please Note: these features are currently only available with `define( 'TBEX_USE_BLOCK_EDITOR_SUPPORT', TRUE );` - support in plugin's settings comes with next major version!
* New: Finally, complete translation of the German plugin page on WordPress.org: [https://de.wordpress.org/plugins/toolbar-extras/](https://de.wordpress.org/plugins/toolbar-extras/) - this translation will also be maintained from now on (note: it can only be in informal German, which is the guideline set by the platform)
* Tweak: On Plugin's settings page, About & Support, enhanced optional System Info
* Tweak: Improved Theme support for "GeneratePress" Theme and its Premium Add-On Plugin
* Tweak: Greatly enhanced plugin support for "Genesis Design Palette Pro"
* Tweak: Added 2 new template types (Single, Archive) to "Jet Theme Parts" template creation - part of the "JetThemeCore" plugin support
* Tweak: Enhanced Astra (Pro) Theme support - Customizer deep links for layouts modules of WooCommerce, LifterLMS, LearnDash
* Tweak: Greatly enhanced plugin support for "Premium Addons for Elementor", plus, added support for their brand new Pro version! -- Note: From now on only the free version 2.5.0 or higher is supported!
* Tweak: Enhanced "Element Pack" plugin support - new settings and resources link
* Tweak: Improved "Genesis Testimonial Slider" plugin support
* Tweak: Once again enhanced "Gravity Forms" plugin support
* Tweak: Enhanced "Duplicator" plugin support (free version)
* Tweak: Added new resources for "Health Check & Troubleshooting" plugin support
* Tweak: Added new resource to "Essential Addons" plugin support
* Tweak: A lot of smaller code improvements, tweaks and fixes
* Tweak: Enhanced, improved and corrected Readme.txt file here - also tweaked formatting/ listing of the included changelogs to improve with translated versions of the readme (WordPress.org Rosetta sites)
* Tweak: Updated `.pot` file plus all German translations (formal, informal) and language packs, including fixes for some translations errors
* Fix: CSS styling for Edit/View Customizer sub-item for singular posts/ post types
* Fix: Proper conditional loading for "Home Page Banner for Astra Theme" plugin support
* Fix: Proper plugin support for "AnyWhere Elementor Pro" Add-On
* Fix: Correct resource link for "UpdraftPlus" plugin support
* Fix: Corrected plugin support for "Health Check & Troubleshooting"
* Fix: Corrected errors in readme.txt here :)
* **New:** *Extended and Enhanced Multisite Support*
  * Multisite is now a "first-class citizen" within Toolbar Extras - this is the begin of prerequisites for a future Multisite Add-On!
  * Added specific support for Network-wide activation on Multisite installs - this then creates the proper plugin defaults on a per site basis
  * Added routine for Multisite installs which have Toolbar Extras plugin activated Network-wide to create the plugin defaults when creating a new Site in the Network
  * Build Group: will no longer appear in Network Admin - as it should have never appeared there (wrong behavior finally fixed!)
  * Site Group: links that don't belong into the Network Admin will no longer appear there
  * User Group: make the items respect Network Admin context
  * Tweak: Made "WP Migrate DB (Pro)" plugin support fully compatible with Multisite (plugin activated Network-wide)
  * Tweak: Made "Local Development" plugin support compatible with Multisite
  * Tweak: Made "GitHub Updater" plugin support compatible with Multisite
* **New:** *Extended the Theme support for:*
  * Niche Pro (Child Theme for Genesis) (Premium, by Design by Bloom)
  * Lifestyle Pro (Child Theme for Genesis) (Premium, by StudioPress)
  * Aspire Pro (Child Theme for Genesis) (Premium, by Appfinite)
  * Atmosphere Pro (Child Theme for Genesis) (Premium, by StudioPress)
  * Digital Pro (Child Theme for Genesis) (Premium, by StudioPress)
  * Executive Pro (Child Theme for Genesis) (Premium, by StudioPress)
  * Gallery Pro (Child Theme for Genesis) (Premium, by Design by Bloom)
  * Maker Pro (Child Theme for Genesis) (Premium, by JT Grauke/ Design by Bloom)
  * Market Theme (Child Theme for Genesis) (Premium, by Restored 316 Designs // Lauren Gaige)
  * Metro Pro (Child Theme for Genesis) (Premium, by StudioPress)
  * Showcase Pro (Child Theme for Genesis) (Premium, by Design by Bloom)
  * Smart Passive Income Pro (Child Theme for Genesis) (Premium, by StudioPress)
* **New:** *Extended the Plugin support for Elementor Add-Ons:*
  * Split Test For Elementor (free, by Rocket Elements)
  * JetEngine (Premium, by Zemez/ Crocoblock) - note: plugin is currently in beta
  * Natalie - Personal Theme Builder for Elementor (Premium, by XLDevelopment/ Ashraf)
  * Dashboard Welcome for Elementor (free, by IdeaBox Creations)
  * Massive Addons for Elementor (free, by Blocksera)
  * Dynamic Content for Elementor (Premium, by Dynamic.ooo)
  * Premium Addons PRO (Premium, by Leap13) - the paid Pro Add-On for "Premium Addons for Elementor"
  * Vakka Addons for Elementor (Premium, by MaxxTheme)
  * Funnelmentals (free, by Web Disrupt)
  * Funnelmentals Premium (Premium, by Web Disrupt)
  * Rife Elementor Extensions & Templates (free, by Apollo13 Themes)
* **New:** *Extended the general Plugin support for:*
  * FormCraft 3 (Premium, by nCrafts)
  * WP Synchro (free, by WPSynchro) - for Dev Mode
  * Log Deprecated Notices (free, by Andrew Nacin) - for Dev Mode
  * Log Viewer (free, by Markus Fischbacher) - for Dev Mode
  * BackWPup (free, by Inpsyde GmbH) - including Multisite support
  * Duplicator Pro (Premium, by Snap Creek) - including Multisite support
  * UpdraftPlus Premium (Premium, by Team Updraft, David Anderson) - including Multisite support
  * WPMU Dev Dashboard (Premium, by WPMU DEV) - including Multisite support
  * Everest Forms (free, by WPEverest)
  * MailChimp for WordPress (free, by ibericode)
  * HappyForms (free, by The Theme Foundry)
  * ARForms (Premium, by Repute InfoSystems)
  * SEOPress (free, by Benjamin Denis)
  * SEOPress Pro (Premium, by Benjamin Denis) - Add-On Plugin
  * All in One Schema Rich Snippets (free, by Brainstorm Force)
  * Schema Pro (Premium, by Brainstorm Force)
  * Schema (free, by Hesham)
  * WP Portfolio (Premium, by Brainstorm Force)
  * PHP Code Snippets (Insert PHP) (free, by Webcraftic)
  * Cool Timeline (free, by Cool Plugins) - as a basis for the by the same author, "Cool Timeline Addon For Elementor" (native Elementor widget)


### ⚡ 1.3.1 - 2018-06-30

* [Change log](https://toolbarextras.com/changelog/version-1-3-1/)
* New: Added two upcoming WooCommerce Template types for a future Elementor Pro version
* Tweak: Added icons to the new Customizer link for "Edit" and "View" singular posts for any public post (feature from v1.3.0)
* Tweak: Changed various admin links for "Phlox" Theme support - Note: [Toolbar Extras always only supports the latest versions of supported Themes & Plugins](https://toolbarextras.com/docs/update-policy-for-supported-themes-and-plugins/)
* Tweak: Enhanced "Gravity Forms" plugin support; also further improved filtering and re-hooking
* Tweak: Added a new resource for "Gravity Forms" plugin support
* Tweak: Updated `.pot` file plus all German translations (formal, informal)
* Tweak: Enhanced, improved and corrected Readme.txt file here :)
* Fix: Proper version check in settings updater for 1.3.x branch
* Fix: Fixing one more instance - proper template type for "Create with Builder" URL for adding new "Single" template (Elementor Pro)
* Fix: "Convert Pro" plugin support - proper check if "Pro Add-On" is active to avoid fatal error
* **New:** *Extended the general Plugin support for:*
  * WP Migrate DB Pro (Premium, by Delicious Brains) - for Dev Mode
  * Contact Form 7 (free, by Takayuki Miyoshi)
  * Caldera Forms (free, by Caldera Labs)
  * Ninja Forms (free, by The WP Ninjas) (only v3.0 or higher supported!)
  * Formidable Forms (Lite) (free, by Strategy11)
  * Formidable Pro (Premium, by Strategy11)
  * WPForms Lite (free, by WPForms)
  * Quform 2 (Premium, by ThemeCatcher) (only v2.0 or higher supported!)
  * Flamingo (free, by Takayuki Miyoshi) - a Contact Form 7 Add-On
  * Ninja Forms - Layout & Styles (Add-On) (Premium, The WP Ninjas)
  * Ninja Forms - File Uploads (Add-On) (Premium, The WP Ninjas)
  * Hustle (free, by WPMU DEV)
  * Bloom (Premium, by Elegant Themes)
  * Decorator – WooCommerce Email Customizer (free, by RightPress)
  * Content Aware Sidebars (free, by Joachim Jensen - DEV Institute)


### 🎉 1.3.0 - 2018-06-25

* [Change log](https://toolbarextras.com/changelog/version-1-3-0/)
* New: General setting to set link target for "Create with Builder" links (add new templates...) - by default this is now set to "_blank" (means new browser tab/ window)
* New: Added Customizer link for "Edit" and "View" singular posts for any public post - also a new General setting included to display those links or not (on by default)
* New: Build own Theme upload "tab" that can be linked to on its own (uses WordPress Core render function for the upload feature itself!) - see Toolbar under: + New > Install Theme > Upload ZIP file
* New: Smart Tweak setting to remove "Media" from New Content group (to gain more space there) (off by default)
* New: Added full support for Crocoblock Subscription Service (Premium, by Zemez) - including Kava Pro, Kava free, plus all Jet Plugins with settings pages - this also includes 1-Click template creation for Jet Theme Parts (via JetThemeCore)
* New: Successfully tested with "Dark Mode" (free, by Daniel T. James) plugin - which may land in WordPress Core soon... :) - all CSS styles that Toolbar Extras adds are fully compatible
* Tweak: On plugin's settings page/ tabs added visual separation of settings sections (horizontal lines)
* Tweak: All Customizer deep links that customize the Blog archive/page of a site now use the set Blog URL as the preview URL/page within the Customizer - this applies to all supported themes that have such Customizer panel, section or control
* Tweak: Added new plugin "Home Page Banner for Astra Theme" (free, by Brainstorm Force) to Astra Theme support (Customizer deep link)
* Tweak: Added new plugin "Ocean Stick Anything" (free, by OceanWP) to OceanWP Theme support (settings link)
* Tweak: Added "Integrations" settings to OceanWP theme support
* Tweak: Added new official OceanWP Premium Add-On "Cookie Notice" to OceanWP theme support (Customizer deep link)
* Tweak: Added new "WooCommerce" integration to "Page Builder Framework" Theme support
* Tweak: Added new Elementor developer resource
* Tweak: Added new resource for supported Theme "Page Builder Framework"
* Tweak: Improved plugin support for "Local Development" plugin (free, by Andy Fragen)
* Tweak: Improved plugin support for "Revolution for Elementor Premium" plugin (Premium, by Jan Thielemann)
* Tweak: Styling improvement for resources in Dev Mode
* Tweak: Started a process to reduce the amount of strings: further re-use of strings where possible; reducing the amount of unique strings from supported plugins and themes
* Tweak: Updated `.pot` file plus all German translations (formal, informal)
* Fix: Proper template type for "Create with Builder" URL for adding new "Single" template (Elementor Pro)
* Fix: Proper Link title labels for "White Label Branding for Elementor" plugin support
* **New:** *Extended the Theme support for:*
  * Kava Pro (Premium, by Zemez/ Crocoblock) - including the "Kava Extra" plugin
  * Phlox (free, by averta) - including the free Add-Ons "Phlox Core Elements" and "Phlox Portfolio"
  * Buildwall (Premium, by Zemez)
  * Resurrect (Premium, by ChurchThemes.com LLC)
  * Exodus (Premium, by ChurchThemes.com LLC)
  * Saved (Premium, by ChurchThemes.com LLC)
  * Maranatha (Premium, by ChurchThemes.com LLC)
  * Risen (Premium, by Steven Gliebe/ ChurchThemes.com LLC) - note: legacy theme!
  * AgentPress Pro (Child Theme for Genesis) (Premium, by StudioPress)
  * Altitude Pro (Child Theme for Genesis) (Premium, by StudioPress)
  * Author Pro (Child Theme for Genesis) (Premium, by StudioPress)
  * Daily Dish Pro (Child Theme for Genesis) (Premium, by StudioPress)
  * Infinity Pro (Child Theme for Genesis) (Premium, by StudioPress)
  * Magazine Pro (Child Theme for Genesis) (Premium, by StudioPress)
  * Parallax Pro (Child Theme for Genesis) (Premium, by StudioPress)
  * Wellness Pro (Child Theme for Genesis) (Premium, by StudioPress)
* **New:** *Extended the Plugin support for Elementor Add-Ons:*
  * JetThemeCore (Premium, by Zemez/ Crocoblock)
  * Briefcase Elementor Widgets (Premium, by BriefcaseWP)
  * Kadence WooCommerce Elementor (free, by Kadence WP)
  * Kadence WooCommerce Elementor Pro (Premium, by Kadence WP)
  * Elementor Google Map Extended Pro (Premium, by InternetCSS)
* **New:** *Extended the general Plugin support for:*
  * Kava Extra (Premium, by Zemez/ Crocoblock)
  * Jet Data Importer (Premium, by Zemez/ Crocoblock)
  * Jet Plugins Wizard (Premium, by Zemez/ Crocoblock)
  * Home Page Banner for Astra Theme (free, by Brainstorm Force)
  * OceanWP Sticky Header (free, by Oren Hahiashvili)
  * Front Page Builder (free, by Themes4WP)
  * Customify Pro Add-On (Premium, by PressMaximum)
  * Phlox Core Elements Add-On (free, by averta)
  * Phlox Portfolio Add-On (free, by averta)
  * Church Content (free, by ChurchThemes.com)
  * GP Social Share (free, by Jon Mather)
  * GP Back To Top (free, by Mai Dong Giang (Peter Mai))
  * Ocean Stick Anything (free, by OceanWP)
  * Cherry Data Importer (Premium, by Zemez)
  * Cherry Plugins Wizard (Premium, by Zemez)
  * Display Featured Image for Genesis (free, by Robin Cornett)


### ⚡ 1.2.1 - 2018-06-09

* [Change log](https://toolbarextras.com/changelog/version-1-2-1/)
* Tweak: Improved logic for some Smart Tweaks so any items are always hidden when the supported plugin is not active (important for the re-hook tweaks)
* Tweak: Improved plugin support for "JetWooBuilder" with the adding of its WooCommerce settings page
* Tweak: Improved plugin support for "DHWC Elementor" with the adding of its Template settings
* Tweak: Removed "Push Notifications" from OceanWP theme support as this feature is now only available in a third-party stand-alone plugin
* Tweak: Improved "Gravity Forms" plugin support and the re-hooking Smart Tweak/ integration
* Tweak: Some string & formatting optimizations
* Tweak: Updated `.pot` file plus all German translations (formal, informal)
* Fix: Removed duplicate item for Elementor Core support in code
* Fix: Proper default status "no" in setting description for Frontend Toolbar color Smart Tweak
* Fix: Proper check for white label settings in "Ultimate Addons for Elementor" plugin support


### 🎉 1.2.0 - 2018-05-31

* [Change log](https://toolbarextras.com/changelog/version-1-2-0/)
* New: General setting to remove all title attributes (Tooltips) from links in the Toolbar, including from all items added by Toolbar Extras (Toolbar Extras Settings > General)
* New: Smart Tweak setting to re-hook "WP Rocket" items from the top-level to the Site Group > More Stuff (off by default) (Plugin: WP Rocket - Premium, by WP Rocket)
* New: Smart Tweak setting to re-hook "Autoptimize" items from the top-level to the Site Group > More Stuff (off by default) (Plugin: Autoptimize - free, by ?)
* New: Smart Tweak setting to re-hook "Swift Performance" (Premium) or "Swift Performance Lite" (free) items from the top-level to the Site Group > More Stuff (off by default) (Plugin: Swift Performance - free/Premium, by ?)
* New: Smart Tweak setting to remove new "User" from New Content group (to gain more space there) (off by default)
* New: Smart Tweak setting specifically for WooCommerce plugin to remove new "Order" and new "Coupon" from New Content Group (to gain more space there) (off by default)
* New: Smart Tweak setting to optionally unload translations for Elementor and Elementor Pro (so it falls back to English default strings) (off by default)
* New: Smart Tweak setting to optionally unload translations for this plugin, Toolbar Extras (so it falls back to English default strings) (off by default)
* New: Smart Tweak setting to optionally remove all WordPress Widgets from the Elementor Live Editor (left-hand Elementor Panel) (off by default)
* New: Thanks to the amazing user community, this plugin is now available in 3 different English language variants: `en_GB` (for the UK), `en_CA` (for Canada) and `en_AU` (for Australia)
* Tweak: Made support for "Dynamik Website Builder" Child Theme compatible with their newest version 2.4.0/2.4.1 or higher (versions 2.3.4 or lower are still supported, though)
* Tweak: Added preview links for "Dynamik Website Builder" theme support
* Tweak: Improved full view (preview) links for "Genesis DevKit" plugin support, and same for "Freelancer DevKit" plugin support
* Tweak: Updated Smart Tweak for "All In One SEO Pack" plugin to also support their Pro version
* Tweak: Updated the plugin's few CSS styles for the Toolbar so that they work better on tablets and smartphones
* Tweak: Improved the Customizer support for "OceanWP" Theme, including full support activating/ deactivating Customizer panels via "Ocean Extra" plugin
* Tweak: Added more Pro resources for "Page Builder Framework" Premium Add-On
* Tweak: Added Developer resources for the "Astra" Theme
* Tweak: Added more resources for "PowerPack Elements" plugin support
* Tweak: Made the "Use Admin Color Scheme also for Frontend" Smart Tweak turned off by default. Makes more sense. (*Note:* [Also be aware of this Knowledge Base article on the topic](https://toolbarextras.com/docs/conflicts-with-body-background-color/))
* Tweak: Updated `.pot` file plus all German translations (formal, informal)
* Tweak: Changed plugin author avatar image to local file instead of external hashed Gravatar image
* Tweak: Enhanced, improved and corrected Readme.txt file here :)
* **New:** *Extended the Theme support for:*
  * Customify (free, by WPCustomify/ PressMaximum)
  * Flexia (free) - including Flexia Core (free) and Flexia Pro (Premium) plugins (all three by Codedic)
  * Eletheme (free, by Liviu Duda)
  * Essence Pro (Child Theme for Genesis) (Premium, by StudioPress)
  * Corporate Pro (Child Theme for Genesis) (Premium, by SEO Themes)
  * Business Pro (Child Theme for Genesis) (Premium, by SEO Themes)
  * Studio Pro (Child Theme for Genesis) (Premium, by SEO Themes)
  * Academy Pro (Child Theme for Genesis) (Premium, by StudioPress)
  * Authority Pro (Child Theme for Genesis) (Premium, by StudioPress)
  * Outfitter Pro (Child Theme for Genesis) (Premium, by StudioPress)
  * Boss Pro (Child Theme for Genesis) (Premium, by Design by Bloom)
  * Refined Pro (Child Theme for Genesis) (Premium, by Restored 316 Designs // Lauren Gaige)
  * Monochrome Pro (Child Theme for Genesis) (Premium, by StudioPress)
  * Slush Pro (Child Theme for Genesis) (Premium, by zigzagpress)
  * Foodie Pro (Child Theme for Genesis) (Premium, by Feast Design Co.)
  * Cook'd Pro (Child Theme for Genesis) (Premium, by Feast Design Co.)
  * Brunch Pro (Child Theme for Genesis) (Premium, by Feast Design Co.)
  * Genesis Sample (the default Child Theme for Genesis) (Premium, by StudioPress) - only for version 2.6.0 or higher
* **New:** *Extended the Plugin support for Elementor Add-Ons:*
  * White Label Branding for Elementor (Premium, by IdeaBox Creations) - including Toolbar Extras support for some of the white label features (where applicable)
  * JetWooBuilder (Product Templates for WooCommerce) (Premium, by Zemez/ Crocoblock)
  * JetBlocks (Premium, by Zemez/ Crocoblock)
  * DHWC Elementor (Product Templates for WooCommerce) (Premium, by Sitesao Team)
  * Revolution for Elementor (free/Premium, by Jan Thielemann)
  * Archivescode Addons for Elementor (free, by Archivescode)
  * Contact Form DB (free, by Michael Simpson)
  * Eleslider (free, by wpmasters)
  * SJ Elementor Addon (free, by sandesh055)
* **New:** *Extended the general Plugin support for:*
  * Lightweight Sidebar Manager (free, by Brainstorm Force)
  * TM Timeline (free, by Jetimpex/ Zemez)
  * Convert Pro (Premium, by Brainstorm Force)
  * Convert Pro Addon (Premium, by Brainstorm Force)
  * Convert Plus (Premium, by Brainstorm Force)
  * OptinMonster API (free/Premium, by OptinMonster Team/ Retyp, LLC)
  * Testimonial Rotator (free, by Hal Gatewood)
  * Widget Options (free/Premium, by Phpbits Creative Studio)


### ⚡ 1.1.3 - 2018-04-30

* [Change log](https://toolbarextras.com/changelog/version-1-1-3/)
* New: [Launched plugin's own website at toolbarextras.com](https://toolbarextras.com/) with full listing of theme and plugin support, features, blog as well as documentation, knowledge base and changelogs
* New: Added plugin support for "Genesis DevKit" (Premium, by Cobalt Apps)
* Tweak: Added appropriate EDD Customizer deep links for the "StartWP Extended" plugin support
* Tweak: Added settings page link for "Genesis Testimonial Slider" plugin support
* Tweak: Added preview links for "Freelancer DevKit" plugin support
* Tweak: Added preview links for "Themer Pro" plugin support
* Tweak: Added preview links for "Extender Pro" plugin support
* Tweak: Add "&use-location" query_arg to create new menu for Toolbar (link in plugins page notice)
* Tweak: Updated `.pot` file plus all German translations (formal, informal)
* Tweak: Added or updated URLs throughout the plugin and Readme file to use links to the plugin's own website where appropriate
* Fix: Proper filter name for 'tbex_filter_meta_target'


### ⚡ 1.1.2 - 2018-04-23

* [Change log](https://toolbarextras.com/changelog/version-1-1-2/)
* Tweak: Made support for "Genesis Extender" plugin compatible with their newest version 1.9.0 or higher (versions below v1.9.0 are still supported, though)
* Fix: Proper dismissal parameter for admin notices
* Fix: Re-added /assets/ folder within plugin - really sorry for that mistake in v1.1.1!


### ⚡ 1.1.1 - 2018-04-20

* [Change log](https://toolbarextras.com/changelog/version-1-1-1/)
* New: Added theme support for "Kava Theme" (free, by Zemez & Crocoblock)
* New: Added plugin support for "WidgetKit for Elementor" (free, by Themesgrove)
* New: Added plugin support for "Genesis Extender" (Premium, by Cobalt Apps)
* Tweak: Added new settings to plugin support for "Extra Privacy for Elementor" (free, by Marian Heddesheimer)
* Tweak: Removed "Widget" Template type from Add New items (Elementor Pro), as Widgets (Global Widgets) cannot be created that way at all (only from the Live Builder itself)
* Tweak: Updated `.pot` file plus all German translations (formal, informal)
* Fix: Proper template type for "New Page Template with Builder" (Elementor Core)
* Fix: Proper array for the 'tbex_filter_elementor_template_types' filter
* Fix: Changed update settings functionality & checks for the new options added in v1.1.0
* Fix: Add Thickbox JS & CSS on settings page if needed (for video tour)


### 🎉 1.1.0 - 2018-04-18

* [Change log](https://toolbarextras.com/changelog/version-1-1-0/)
* New: Successfully tested with Elementor Pro 2.0 final release (and many Beta versions before)
* New: Successfully tested with "Laragon" app on Windows 10 - automatic detection of local sites with `.test` domain worked great
* New: Added button to Video feature introduction tour on settings page welcome message
* New: Added links to YouTube tutorial videos on tab "About & Support" on plugin's settings page
* New: Smart Tweak setting to re-hook "NextGen Gallery" items from the top-level to the Site Group > Galleries (off by default)
* New: Smart Tweak setting to re-hook "iThemes Security" items from the top-level to the Site Group (off by default)
* New: Smart Tweak setting to remove "All In One SEO Pack" items from the top-level because they have no real use at all (on by default)
* Tweak: Improved "Add new Template with Builder" for all Elementor Template Types since Elementor 2.0/ Pro 2.0 - Special Thanks to the Elementor Dev Team! ;-)
* Tweak: Respect white label settings for Elementor Add-On "PowerPack Elements" (and only show if those settings were not hidden)
* Tweak: Only show "Astra Pro" white label settings if those settings were not hidden
* Tweak: Only show "Ultimate Addons for Elementor" white label settings if those settings were not hidden
* Tweak: Added Google Maps settings options for "Ultimate Addons for Elementor" (since v1.1.0 of this Add-On)
* Tweak: Extended plugin support for the "WooCommerce" plugin
* Tweak: Improved the support for re-hooking the "Smart Slider 3" plugin items
* Tweak: Improved and enhanced the "About & Support" page content
* Tweak: Improved uninstall functionality: properly delete all (site) Transients
* Tweak: Updated `.pot` file plus all German translations (formal, informal)
* Tweak: Enhanced, improved and corrected Readme.txt file here :)
* Fix: White label name for OceanWP for Library in "New Content" Group
* Fix: Inline documentation and typo fixes all around
* **New:** *Extended the Theme support for:*
  * Page Builder Framework (free & Premium, by David Vongries & MapSteps)
  * StartWP (free, by Munir Kamal)
  * Dynamik Website Builder for Genesis (Premium, by Cobalt Apps)
  * Freelancer Framework (free, by Cobalt Apps)
  * GBeaver (Child Theme for Genesis) (Premium, by WP Beaver World)
  * Beaver Builder Theme (Premium, by FastLine Media LLC)
  * Hestia (free, by Themeisle)
  * Tiny Hestia (Child Theme for Hestia) (free, by Themeisle)
  * Ofeo (Child Theme for Hestia) (free, by Themeisle)
  * Christmas Hestia (Child Theme for Hestia) (free, by Themeisle)
* **New:** *Extended the Plugin support for Elementor Add-Ons:*
  * Premium Addons for Elementor (free, by Leap13)
  * Elements Plus! (free, by The CSSIgniter Team)
  * Elementor Custom Skin (free, by Liviu Duda)
  * Power-Ups for Elementor (free, by WpPug)
  * Press Elements (free/Premium, by Press Elements & Rami Yushuvaev)
  * JetElements (Premium, by Zemez)
  * JetMenu (Premium, by Zemez)
  * JetBlog (Premium, by Zemez)
  * JetReviews (Premium, by Zemez)
  * Total Recipe Generator for Elementor (Premium, by SaurabhSharma)
  * PT Elementor Addons Lite (free, by ParamThemes)
  * Elementor Addon Elements (free, by WebTechStreet)
  * Elementor Addons & Templates – Sizzify Lite (free, by Themeisle)
  * Orbit Fox Companion (free, by Themeisle)
  * Elementor Google Map Extended (free, by InternetCSS)
* **New:** *Extended the general Plugin support for:*
  * WP Show Posts (free/Pro, by Tom Usborne)
  * StartWP Extended (free, by Munir Kamal)
  * Freelancer DevKit (Add-On) (Premium, by Cobalt Apps)
  * Themer Pro (Premium, by Cobalt Apps)
  * Extender Pro (Premium, by Cobalt Apps)
  * Envira Gallery Lite/Pro (free/Premium, by Envira Gallery Team)
  * Soliloquy Sliders Lite/Pro (free/Premium, by Soliloquy Team)
  * Cherry Testimonials (free, by Zemez)
  * Cherry Team Members (free, by Zemez)
  * Cherry Services List (free, by Zemez)
  * Cherry Projects (free, by Zemez)
  * FooGallery (free, by FooPlugins)
  * MaxGalleria (free, by Max Foundry)


### ⚡ 1.0.2 - 2018-04-05

* [Change log](https://toolbarextras.com/changelog/version-1-0-2/)
* New: Added first language packs via WordPress.org translations platform - for German (de_DE - informal) and German Formal (de_DE_formal) - thanks to Team WordPress DE! ;-)
* New: Added plugin support for "Cleaner Plugin Installer".
* Tweak: Improved localization on plugin activation.
* Fix: Fallback function for main item, now with proper URL, plus slightly tweaked string text.
* Fix: Fatal error related to "Dev Mode" in Multisite context.


### ⚡ 1.0.1 - 2018-04-04

* [Change log](https://toolbarextras.com/changelog/version-1-0-1/)
* Tweak: Improved localization functions.
* Tweak: Improved Readme.txt


### 🎉 1.0.0 - 2018-04-03

* [Change log](https://toolbarextras.com/changelog/version-1-0-0/)
* *Plugin launch. Everything's new!*
* New: Including support for 17 Themes/ Frameworks (which all work well with Elementor, including the Theme Builder since Pro v2.0+)
* New: Including support for 19 Add-On plugins (free + Premium) for Elementor
* New: Including support for 35 general useful plugins for Non-Coder site builders as well as developers
* New: Including support for 10 Genesis specific plugins


### Version 2018-03-31

* Initial private release on GitHub
