<?PHP
#
#   FILE:  SPT--AccessPreferences.php
#
#   FUNCTIONS PROVIDED:
#       ShowScreenEnhanceSettings()
#       ShowStructuralPresentationSettings()
#       ShowAlternativesToVisualSettings()
#       ShowAlternativesToTextSettings()
#       ShowAlternativesToAuditorySettings()
#
#   FORM FIELDS EXPECTED:
#       F_screenEnhanceGeneric
#       F_structuralPresentation
#       F_alternativesToVisual
#       F_alternativesToText
#       F_alternativesToText
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.wisc.edu
#

require_once("include/SPT--Common.php");
PageTitle("Accessibility Preferences");


# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function ShowScreenEnhanceSettings()          {  return isset($_POST["F_screenEnhanceGeneric"]);  }
function ShowStructuralPresentationSettings() {  return isset($_POST["F_structuralPresentation"]);  }
function ShowAlternativesToVisualSettings()   {  return isset($_POST["F_alternativesToVisual"]);  }
function ShowAlternativesToTextSettings()     {  return isset($_POST["F_alternativesToText"]);  }
function ShowAlternativesToAuditorySettings() {  return isset($_POST["F_alternativesToAuditory"]);  }

function GetFontSize()                  {  global $User;  return $User->PrefFontSize();  }

function PrintFontSize()
{
    global $CustomFontSize;
    
    $StandardFontSizes = array(
            "" => "default",
            "10" => "10px",
            "11" => "11px",
            "12" => "12px",
            "14" => "14px",
            "16" => "16px",
            "18" => "18px",
            "20" => "20px",
            "24" => "24px",
            "custom" => "custom",
            );
    $CurrentFontSize = GetFontSize();
    $CustomFontSize = "";
    if (isset($StandardFontSizes[$CurrentFontSize]))
    {
        $SelectedFontSize = $CurrentFontSize;
    }
    else
    {
        if ($CurrentFontSize < 1)
        {
            $SelectedFontSize = "";
        }
        else
        {
            $SelectedFontSize = "custom";
            $CustomFontSize = $CurrentFontSize;
        }
    }
    PrintOptionList("F_FontSize", $StandardFontSizes, $SelectedFontSize);
}

function PrintFontFace()
{
    global $CustomFontFace;
    global $User;
    
    $StandardFontFaces = array(
            "" => "default",
            "Helvetica" => "Helvetica",
            "Arial" => "Arial",
            "Times" => "Times",
            "Serif" => "Serif",
            "Sans Serif" => "Sans Serif",
            "monospaced" => "monospaced",
            "custom" => "custom"
            );
    $CurrentFontFace = $User->PrefFontTypeFace();
    $CustomFontFace = "";
    if (isset($StandardFontFaces[$CurrentFontFace]))
    {
        $SelectedFontFace = $CurrentFontFace;
    }
    else
    {
        $SelectedFontFace = "custom";
        $CustomFontFace = $CurrentFontFace;
    }
    PrintOptionList("F_FontFace", $StandardFontFaces, $SelectedFontFace);
}

function PrintFontColor()
{
    global $CustomFontColor;
    global $User;
    
    $StandardFontColors = array(
            "" => "default",
            "Black" => "Black",
            "Dark Grey" => "Dark Grey",
            "Dark Green" => "Dark Green",
            "Dark Blue" => "Dark Blue",
            "Yellow" => "Yellow",
            "Light Grey" => "Light Grey",
            "White" => "White",
            "custom" => "custom"
            );
    $CurrentFontColor = $User->PrefFontColor();
    $CustomFontColor = "";
    if (isset($StandardFontColors[$CurrentFontColor]))
    {
        $SelectedFontColor = $CurrentFontColor;
    }
    else
    {
        $SelectedFontColor = "custom";
        $CustomFontColor = $CurrentFontColor;
    }
    PrintOptionList("F_FontColor", $StandardFontColors, $SelectedFontColor);
}

function PrintBackgroundColor()
{
    global $CustomBackgroundColor;
    global $User;
    
    $StandardBackgroundColors = array(
            "" => "default",
            "Black" => "Black",
            "Dark Grey" => "Dark Grey",
            "Dark Green" => "Dark Green",
            "Dark Blue" => "Dark Blue",
            "White" => "White",
            "Light Grey" => "Light Grey",
            "custom" => "custom"
            );
    $CurrentBackgroundColor = $User->PrefBackgroundColor();
    $CustomBackgroundColor = "";
    if (isset($StandardBackgroundColors[$CurrentBackgroundColor]))
    {
        $SelectedBackgroundColor = $CurrentBackgroundColor;
    }
    else
    {
        $SelectedBackgroundColor = "custom";
        $CustomBackgroundColor = $CurrentBackgroundColor;
    }
    PrintOptionList("F_BackgroundColor", $StandardBackgroundColors, 
        $SelectedBackgroundColor);
}

function PrintAudioDescriptionLanguage()
{
    global $User;
    
    $Languages = array(
            "English" => "English",
            "Spanish" => "Spanish",
            "French" => "French",
            "Italian" => "Italian",
            "Japanese" => "Japanese",
            "Mandarin" => "Mandarin",
            "Cantonese" => "Cantonese"
            );
    $SelectedLanguage = $User->PrefAudioDescriptionLanguage();
    PrintOptionList("F_AudioDescriptionLang", $Languages, $SelectedLanguage);
}

function PrintImageDescriptionLanguage()
{
    global $User;
    
    $Languages = array(
            "English" => "English",
            "Spanish" => "Spanish",
            "French" => "French",
            "Italian" => "Italian",
            "Japanese" => "Japanese",
            "Mandarin" => "Mandarin",
            "Cantonese" => "Cantonese"
            );
    $SelectedLanguage = $User->PrefVisualDescriptionLanguage();
    PrintOptionList("F_AltTextLang", $Languages, $SelectedLanguage);
}

function PrintSignLanguage()
{
    global $User;
    
    $Languages = array(
        "None" => "None",
        "American - ASL" => "American - ASL",
        "Australian - Ausian" => "Australian - Ausian",
        "British - BSL" => "British - BSL",
        "Danish - DSL" => "Danish - DSL",
        "French - LSF" => "French - LSF",
        "German - DGS" => "German - DGS",
        "Irish - ISL" => "Irish - ISL",
        "Italian - LIS" => "Italian - LIS",
        "Japanese - JSL" => "Japanese - JSL",
        "Malaysian - MSL" => "Malaysian - MSL",
        "Mexican - LSM" => "Mexican - LSM",
        "Native-American" => "Native-American",
        "Netherlands - NGT" => "Netherlands - NGT",
        "Norwegian - NSL" => "Norwegian - NSL",
        "Quebec - LSQ" => "Quebec - LSQ",
        "Russian - RSL" => "Russian - RSL",
        "Singapore - SLS" => "Singapore - SLS",
        "Spanish - LSE" => "Spanish - LSE",
        "Swedish - SWL" => "Swedish - SWL"
            );
    $SelectedLanguage = $User->PrefSignLanguage();
    PrintOptionList("F_SignLanguage", $Languages, $SelectedLanguage);
}

function PrintCaptionType()
{
    global $User;
    
    $CaptionTypes = array(
            UIPREF_CAPTIONTYPE_NONE => "None",
            UIPREF_CAPTIONTYPE_VERBATIM => "Verbatim",
            UIPREF_CAPTIONTYPE_REDUCEDREADINGLEVEL => "Reduced Reading Level",
            );
    $SelectedCaptionType = $User->PrefCaptionType();
    PrintOptionList("F_CaptionType", $CaptionTypes, $SelectedCaptionType);
}

function PrintAudioDescriptionLevel()
{
    global $User;
    
    $AudioDescriptions = array(
            UIPREF_AUDIODESCRIPTION_NONE => "None",
            UIPREF_AUDIODESCRIPTION_STANDARD => "Standard",
            UIPREF_AUDIODESCRIPTION_EXPANDED => "Expanded",
            );
    $SelectedAudioDescription = $User->PrefAudioDescriptionLevel();
    PrintOptionList("F_AudioDescription", $AudioDescriptions, $SelectedAudioDescription);
}

function PrintCaptionRate()
{
    global $User;
    print(($User->PrefCaptionRate() > 0) ? $User->PrefCaptionRate() : 120);
}

function PrintCheckedIfAvoidRed()
{
    global $User;
    
    if ($User->PrefColorAvoidanceFlags() & UIPREF_AVOID_RED)
        print " checked=\"checked\"";
}

function PrintCheckedIfAvoidRedGreen()
{
    global $User;
    
    if ($User->PrefColorAvoidanceFlags() & UIPREF_AVOID_REDGREEN)
        print " checked=\"checked\"";
}

function PrintCheckedIfAvoidBlueYellow()
{
    global $User;
    
    if ($User->PrefColorAvoidanceFlags() & UIPREF_AVOID_BLUEYELLOW)
        print " checked=\"checked\"";
}

function PrintCheckedIfAvoidGreenYellow()
{
    global $User;
    
    if ($User->PrefColorAvoidanceFlags() & UIPREF_AVOID_GREENYELLOW)
        print " checked=\"checked\"";
}

function PrintCheckedIfAvoidOrange()
{
    global $User;
    
    if ($User->PrefColorAvoidanceFlags() & UIPREF_AVOID_ORANGE)
        print " checked=\"checked\"";
}

function PrintCheckedIfAvoidRedBlack()
{
    global $User;
    
    if ($User->PrefColorAvoidanceFlags() & UIPREF_AVOID_REDBLACK)
        print " checked=\"checked\"";
}

function PrintCheckedIfAvoidPurpleGrey()
{
    global $User;
    
    if ($User->PrefColorAvoidanceFlags() & UIPREF_AVOID_PURPLEGREY)
        print " checked=\"checked\"";
}

function PrintCheckedIfUseMaximumContrast()
{
    global $User;
    
    if ($User->PrefColorAvoidanceFlags() &  UIPREF_AVOID_USEMAXMONOCHR)
        print " checked=\"checked\"";
}

function PrintSelectedIfDensityNoPreference()
{
    global $User;
    
    if ($User->PrefContentDensity() &  UIPREF_CONTENTDENSITY_NOPREFERENCE)
        print " selected";
}

function PrintSelectedIfDetailed()
{
    global $User;
    
    if ($User->PrefContentDensity() &  UIPREF_CONTENTDENSITY_DETAILED)
        print " selected";
}

function PrintSelectedIfOverview()
{
    global $User;
    
    if ($User->PrefContentDensity() &  UIPREF_CONTENTDENSITY_OVERVIEW)
        print " selected";
}

function PrintSelectedIfViewNoPreference()
{
    global $User;
    
    if ($User->PrefContentView() &  UIPREF_CONTENTVIEW_NOPREFERENCE)
        print " selected";
}

function PrintSelectedIfTextIntensive()
{
    global $User;
    
    if ($User->PrefContentView() &  UIPREF_CONTENTVIEW_TEXTINTENSIVE)
        print " selected";
}

function PrintSelectedIfImageIntensive()
{
    global $User;
    
    if ($User->PrefContentView() &  UIPREF_CONTENTVIEW_IMAGEINTENSIVE)
        print " selected";
}

function PrintCheckedIfYes()
{
    global $User;
    
    if ($User->PrefUseGraphicAlternatives())
        print " checked=\"checked\"";
}

function PrintCheckedIfNo()
{
    global $User;
    
    if (!$User->PrefUseGraphicAlternatives())
        print " checked=\"checked\"";
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

# set any values implied by selections on previous page
global $User;
if (ShowAlternativesToAuditorySettings() 
    && ($User->PrefCaptionType() == UIPREF_CAPTIONTYPE_NONE))
{
    $User->PrefCaptionType(UIPREF_CAPTIONTYPE_VERBATIM);
}
if (ShowAlternativesToVisualSettings() 
    && ($User->PrefAudioDescriptionLevel() == UIPREF_AUDIODESCRIPTION_NONE))
{
    $User->PrefAudioDescriptionLevel(UIPREF_AUDIODESCRIPTION_STANDARD);
}

# do not continue if nothing has been selected
if($_POST["Submit"] == "Continue" && 
    !ShowScreenEnhanceSettings() &&
    !ShowStructuralPresentationSettings() &&
    !ShowAlternativesToVisualSettings() &&
    !ShowAlternativesToTextSettings() &&
    !ShowAlternativesToAuditorySettings())
{
    $Session->PassVariable("Submit", "Continue");
    PrintAutoRefreshPage("Access Preferences Saved", 
                            "SPT--AccessPreferencesDetailedComplete.php");
    exit;
}

include("include/SPT--StandardHtmlPageLoad.php");

?>
