<?PHP

#
#   FILE:  Scout--EventLog.php
#
#   METHODS PROVIDED:
#       EventLog()
#           - constructor
#       SomeMethod($SomeParameter, $AnotherParameter)
#           - short description of method
#
#   AUTHOR:  Edward Almasy
#
#   Copyright 2007 Internet Scout
#   http://scout.wisc.edu
#


class EventLog {

    # ---- PUBLIC INTERFACE --------------------------------------------------

    # object constructor
    function __construct($DB, $UserId = -1, $LoggingEnabled = TRUE)
    {
        $this->DB = $DB;
        $this->Enabled = $LoggingEnabled;
        $this->UserId = intval($UserId);
    }

    # log event
    function Log($Type, $DataOne = "", $DataTwo = "")
    {
        # if logging is turned on
        if ($this->Enabled)
        {
            # write event out to log
            $this->DB->Query("INSERT INTO EventLog"
                    ." (EventType, EventDate, UserId, DataOne, DataTwo) VALUES"
                    ." (".intval($Type).", NOW(), ".$this->UserId.","
                        ." '".addslashes($DataOne)."',"
                        ." '".addslashes($DataTwo)."')");
        }
    }

    # retrieve specified range of events
    # arguments: FindEvents($StartDate, $EndDate, 
    #       $StartIndex, $EventCount, $EventType, $EventType, ...)
    # all arguments are optional;  pass NULL for unbounded date;  dates are inclusive
    function FindEvents()
    {
        # retrieve arguments (if supplied)
        $StartDate = NULL;
        $EndDate = NULL;
        $StartIndex = 0;
        $EventCount = 100;
        $Types = array();
        $Args = func_get_args();
        if (count($Args)) {  $StartDate = array_shift($Args);  }
        if (count($Args)) {  $EndDate = array_shift($Args);  }
        if (count($Args)) {  $StartIndex = array_shift($Args);  }
        if (count($Args)) {  $EventCount = array_shift($Args);  }
        while (count($Args))
        {
            $Types[] = array_shift($Args);
        }

        # add start and/or end date to query condition (if supplied)
        $Conditions = "";
        if ($StartDate)
        {  
            $Conditions .= " EventDate >= '".addslashes($StartDate)."'";
        }
        if ($EndDate) 
        {  
            $Conditions .= (strlen($Conditions) ? " AND" : "")
                    ." EventDate <= '".addslashes($EndDate)."'";
        }

        # add event types to query condition (if supplied)
        $SubCondition = "";
        foreach ($Types as $Type)
        {
            $SubCondition .= (strlen($SubCondition) ? " OR" : "")
                    ." EventType = ".intval($Type);
        }
        if (strlen($SubCondition))
        {
            $Conditions .= (strlen($Conditions) ? " AND" : "")
                    ." (".$SubCondition.")";
        }

        # if user privilege exclusions have been specified
        if (isset($this->ExcludedPrivilegesForFind))
        {
            # add beginning of exclusion conditions and subquery
            $Conditions .= (strlen($Conditions) ? " AND" : "")
                    ." UserId NOT IN (SELECT UserId FROM APUserPrivileges WHERE ";

            # add subquery condition for each exclusion
            $Connector = "";
            foreach ($this->ExcludedPrivilegesForFind as $Exclusion)
            {
                $Conditions .= $Connector."Privilege "
                        .$Exclusion["Operator"]." ".$Exclusion["Value"];
                $Connector = " OR ";
            }

            # close out subquery condition
            $Conditions .= ")";
        }

        # if SQL query conditions have been specified
        if (isset($this->ConditionsForFind))
        {
            # add conditions to condition string
            foreach ($this->ConditionsForFind as $Condition)
            {
                $Conditions .= (strlen($Conditions) ? " AND " : " ").$Condition;
            }
        }

        # build event query
        $Query = "SELECT * FROM EventLog"
                .(strlen($Conditions) ? " WHERE ".$Conditions : "")
                ." ORDER BY EventDate DESC LIMIT ".$StartIndex.", ".$EventCount;

        # run query and retrieve event information
        $this->DB->Query($Query);
        $Events = array();
        while ($EventInfo = $this->DB->FetchRow()) {  $Events[] = $EventInfo;  }

        # return event information to caller
        return $Events;
    }

    # specify privilege to include or exclude from FindEvents results
    # (pass NULL, NULL to clear all exclusions)
    function ExcludeUsersWithPrivilegesForFind($Operator, $Value)
    {
        # if caller requested clear
        if (($Operator === NULL) && ($Value === NULL))
        {
            # clear exclusions
            unset($this->ExcludedPrivilegesForFind);
        }
        else
        {
            # add specified exclusion
            $Exclusion["Operator"] = $Operator;
            $Exclusion["Value"] = $Value;
            $this->ExcludedPrivilegesForFind[] = $Exclusion;
        }
    }

    # specify SQL condition(s) to apply to FindEvents
    # (multiple conditions are ANDed)
    # (pass NULL to clear all conditions)
    function AddSqlConditionForFind($Conditions)
    {
        # if caller requested clear
        if ($Conditions === NULL)
        {
            # clear all conditions
            unset($this->ConditionsForFind);
        }
        else
        {
            # convert condition to array if only one specified
            if (!is_array($Conditions)) {  $Conditions = array($Conditions);  }

            # add conditions to list
            $this->ConditionsForFind = isset($this->ConditionsForFind)
                    ? array_merge($this->ConditionsForFind, $Conditions)
                    : $Conditions;
        }
    }

    # limit FindEvents() results to specified user
    function LimitFindToUser($UserId = NULL)
    {
        if ($UserId === NULL)
        {
            $UserId = $this->UserId;
        }
        $this->AddSqlConditionForFind("UserId = ".intval($UserId));
    }
    
    # modify existing event
    function ModifyEvents($EventType, $EventDate, $UserId, 
            $DataOne = NULL, $DataTwo = NULL, $Condition = NULL)
    {
        if ($DataOne || $DataTwo)
        {
            $this->DB->Query("UPDATE EventLog SET"
                    .($DataOne ? " DataOne = '".addslashes($DataOne)."'" : "")
                    .(($DataOne && $DataTwo) ? ", " : "")
                    .($DataTwo ? " DataTwo = '".addslashes($DataTwo)."'" : "")
                    ." WHERE EventType = '".addslashes($EventType)."'"
                        ." AND EventDate = '".addslashes($EventDate)."'"
                        ." AND UserId = '".addslashes($UserId)."'");
        }
    }


    # ---- PRIVATE INTERFACE -------------------------------------------------

    var $DB;
    var $Enabled;
    var $UserId;
    var $ExcludedPrivilegesForFind;
    var $ConditionsForFind;

}


?>
