<?PHP

#
#   FILE:  SPT--Qualifier.php
#
#   METHODS PROVIDED:
#       Qualifier($QualifierId = NULL)
#           - constructor (no ID creates new qualifier)
#       Delete()
#           - remove qualifier from database
#       Id()
#           - get attribute
#       Name($NewValue = DB_NOVALUE)
#       Url($NewValue = DB_NOVALUE)
#           - get/set attributes
#
#   AUTHOR:  Edward Almasy
#
#   Part of the Scout Portal Toolkit
#   Copyright 2003 Internet Scout Project
#   http://scout.wisc.edu
#

require_once(dirname(__FILE__)."/SPT--Common.php");


class Qualifier {

    # ---- PUBLIC INTERFACE --------------------------------------------------

    # object constructor (no ID creates new qualifier)
    function Qualifier($QualifierId = NULL)
    {
        # create our own database handle
        $this->DB = new SPTDatabase();
        $DB =& $this->DB;
        
        # if ID supplied
        if ($QualifierId !== NULL)
        {
            # save ID
            $this->Id = intval($QualifierId);

            # attempt to load qualifier info from database
            $DB->Query("SELECT * FROM Qualifiers"
                    ." WHERE QualifierId = '".$this->Id."'");

            # if row was loaded
            if ($DB->NumRowsSelected() > 0)
            {
                # set attributes to values returned by database
                $this->DBFields = $DB->FetchRow();
            }
        }
        else
        {
            # determine next qualifier ID
            $HighestId = $DB->Query("SELECT QualifierId FROM Qualifiers"
                                    ." ORDER BY QualifierId DESC LIMIT 1", "QualifierId");
            $this->Id = ($HighestId > 0) ? ($HighestId + 1) : 1;
            
            # add record to database with that ID
            $DB->Query("INSERT INTO Qualifiers SET QualifierId = ".$this->Id);
        }
    }
    
    # remove qualifier from database
    function Delete()
    {
        # delete record from database
        $this->DB->Query("DELETE FROM Qualifiers WHERE QualifierId = ".$this->Id);
    }
    
    # get attribute
    function Id() {  return $this->Id;  }
    
    # get/set attributes
    function Name($NewValue = DB_NOVALUE) {  return $this->UpdateValue("QualifierName", $NewValue);  }
    function Namespaces($NewValue = DB_NOVALUE) {  return $this->UpdateValue("QualifierNamespace", $NewValue);  }
    function Url($NewValue = DB_NOVALUE) {  return $this->UpdateValue("QualifierUrl", $NewValue);  }
    

    # ---- PRIVATE INTERFACE -------------------------------------------------

    var $Id;
    var $DB;
    var $DBFields;
    
    # convenience function to supply parameters to Database->UpdateValue()
    function UpdateValue($FieldName, $NewValue)
    {
        return $this->DB->UpdateValue("Qualifiers", $FieldName, $NewValue,
                               "QualifierId = '".$this->Id."'", $this->DBFields);
    }
}


?>
