<?PHP

#
#   FILE:  SPT--Message.php
#
#   FUNCTIONS PROVIDED:
#       Message->Message($MessageId)
#           - constructor
#       Message->MessageId()
#       Message->ParentId()
#       Message->ParentyType()
#       Message->DatePosted()
#       Message->PosterId()
#       Message->Subject()
#       Message->Body()
#           - methods to retrieve resource attributes
#
#   Part of the Scout Portal Toolkit
#   Copyright 2002 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once(dirname(__FILE__)."/../Axis--User.php");


class Message {

    # ---- PUBLIC INTERFACE --------------------------------------------------

    # object constructor
    function __construct($MessageId = NULL)
    {
        # locate class in database
        $this->DB = new SPTDatabase();
        $DB =& $this->DB;
        # if ID supplied
        if ($MessageId !== NULL)
        {
            $this->MessageId = intval($MessageId);
            $DB->Query("SELECT * FROM Messages WHERE MessageId = ".$MessageId);

            # if row was loaded
            if ($DB->NumRowsSelected() > 0)
            {
                # set attributes to values returned by database
                $this->DBFields = $DB->FetchRow();
            }
        }
        else
        {
            # add record to database with that ID
            $DB->Query("INSERT INTO Messages (MessageId) VALUES (NULL)");
            $this->MessageId = $DB->Query("SELECT LAST_INSERT_ID()"
                    ." AS MessageId FROM Messages", "MessageId");
        }
    }

    # remove message from database
    function Delete()
    {
        $this->DB->Query("DELETE FROM Messages WHERE MessageId = ".$this->MessageId);
    }
    
    # get attribute 
    function MessageId()    {  return $this->MessageId;  }
    function PosterName()
    {
        $PosterName = new User($this->DB, (int)$this->PosterId());
        return $PosterName->Get("UserName");
    }
    function PosterEmail()
    {
        $PosterName = new User($this->DB, (int)$this->PosterId());
        return $PosterName->Get("EMail");
    }

    # get/set attributes
    function ParentId($NewValue = DB_NOVALUE) {  return $this->UpdateValue("ParentId", $NewValue);  }
    function ParentType($NewValue = DB_NOVALUE) {  return $this->UpdateValue("ParentType", $NewValue);  }
    function DatePosted($NewValue = DB_NOVALUE) {  return $this->UpdateValue("DatePosted", $NewValue);  }
    function PosterId($NewValue = DB_NOVALUE) {  return $this->UpdateValue("PosterId", $NewValue);  }
    function Subject($NewValue = DB_NOVALUE) {  return $this->UpdateValue("Subject", $NewValue);  }
    function Body($NewValue = DB_NOVALUE) {  return $this->UpdateValue("Body", $NewValue);  }

    # ---- PRIVATE INTERFACE -------------------------------------------------

    var $MessageId;
    var $DB;
    var $DBFields;

    # convenience function to supply parameters to Database->UpdateValue()
    function UpdateValue($FieldName, $NewValue)
    {
        return $this->DB->UpdateValue("Messages", $FieldName, $NewValue,
               "MessageId = '".$this->MessageId."'", $this->DBFields, TRUE);
    }
}

?>
