<?PHP

#
#   FILE:  SPT--FileFactory.php
#
#   METHODS PROVIDED:
#       FileFactory()
#           - constructor
#       SomeMethod($SomeParameter, $AnotherParameter)
#           - short description of method
#
#   AUTHOR:  
#
#   Part of the Scout Portal Toolkit
#   Copyright 2007 Internet Scout
#   http://scout.wisc.edu
#

require_once(dirname(__FILE__)."/SPT--ItemFactory.php");
require_once(dirname(__FILE__)."/SPT--File.php");


class FileFactory extends ItemFactory {

    # ---- PUBLIC INTERFACE --------------------------------------------------

    # object constructor
    function __construct($FieldId = NULL)
    {
        # set up item factory base class
        #$this->ItemFactory("File", "Files", "FileId", "FileName", $FieldId);
		parent::__construct("File", "Files", "FileId", "FileName", $FieldId);
    }

    # retrieve all files (names or objects) for specified resource
    # (array index is file IDs)
    function GetFilesForResource($ResourceOrResourceId, $ReturnObjects = TRUE)
    {
        # start out assuming that no files will be found
        $ReturnValue = array();

        # convert resource to ID if necessary
        if (is_object($ResourceOrResourceId)) 
                {  $ResourceOrResourceId = $ResourceOrResourceId->Id();  }

        # retrieve names and IDs of files associated with resource
        $this->DB->Query("SELECT FileId, FileName FROM Files"
                ." WHERE ResourceId = ".$ResourceOrResourceId
                        .($this->FieldId ? " AND FieldId = ".$this->FieldId : ""));
        $FileNames = $this->DB->FetchColumn("FileName", "FileId");

        # if files were found
        if (count($FileNames))
        {
            # if caller asked us to return objects
            if ($ReturnObjects)
            {
                # for each file
                foreach ($FileNames as $FileId => $FileName)
                {
                    # create file object and add it to array
                    $ReturnValue[$FileId] = new File($FileId);
                }
            }
            else
            {
                # return array of file names with IDs as index
                $ReturnValue = $FileNames;
            }
        }

        # return resulting array of files or file names to caller
        return $ReturnValue;
    }

    # create copy of File and return to caller
    function Copy($FileToCopy)
    {
        return new File($FileToCopy->GetNameOfStoredFile(),
                $FileToCopy->ResourceId(),
                $FileToCopy->FieldId(),
                $FileToCopy->Name());
    }


    # ---- PRIVATE INTERFACE -------------------------------------------------

}


?>
