<?PHP

# initialize page generation time clock
$PageGenerationBeginTime = getmicrotime();

# load database access settings
require_once(dirname(__FILE__)."/SPT--Config.php");
require_once(dirname(__FILE__)."/SPT--SPTUser.php");
require_once(dirname(__FILE__)."/SPT--SystemConfiguration.php");
require_once(dirname(__FILE__)."/SPT--SPTDatabase.php");

# define privilege levels for SPT
define("PRIV_SYSADMIN", 1);
define("PRIV_NEWSADMIN", 2);
define("PRIV_RESOURCEADMIN", 3);
define("PRIV_FORUMADMIN", 4);
define("PRIV_CLASSADMIN", 5);
define("PRIV_NAMEADMIN", 6);
define("PRIV_RELEASEADMIN", 7);
define("PRIV_USERADMIN", 8);
define("PRIV_POSTTOFORUMS", 9);
define("PRIV_POSTCOMMENTS", 10);
define("PRIV_USERDISABLED", 11);
define("PRIV_MYRESOURCEADMIN", 12);
define("PRIV_COLLECTIONADMIN", 13);
$PrivDescriptions = array(
        PRIV_SYSADMIN        => "System Administrator",
        PRIV_NEWSADMIN       => "News Administrator",
        PRIV_RESOURCEADMIN   => "Master Resource Administrator",
        PRIV_MYRESOURCEADMIN => "Personal Resource Administrator",
        PRIV_FORUMADMIN      => "Forum Administrator",
        PRIV_CLASSADMIN      => "Classification Administrator",
        PRIV_NAMEADMIN       => "Controlled Name Administrator",
        PRIV_RELEASEADMIN    => "Release Flag Administrator",
        PRIV_USERADMIN       => "User Account Administrator",
        PRIV_COLLECTIONADMIN => "Collection Administrator",
        # following are user permissions, not admin privileges
        PRIV_POSTTOFORUMS    => "Can Post To Forums",
        PRIV_POSTCOMMENTS    => "Can Post Resource Comments",
        PRIV_USERDISABLED    => "User Account Disabled"
        );
$G_PrivDescriptions = $PrivDescriptions;

# define display locations for RSS feed imports
define("RSSDISP_ALLPAGES",1);
define("RSSDISP_FRONTPAGE",2);
define("RSSDISP_ADMINPAGE",4);
define("RSSDISP_MTOOLPAGE",8);



class ErrorList {

    # ---- PUBLIC INTERFACE --------------------------------------------------

    # object constructor
    function ErrorList()
    {
        $this->Messages = array();
        $this->FormMessages = array();
    }

    function AddMessage($Text, $FormFieldName = NULL)
    {
        if ($FormFieldName)
        {
            $this->FormMessages[$FormFieldName] = $Text;
        }
        else
        {
            $this->Messages[] = $Text;
        }
    }

    function GetMessagesAsUList()
    {
        $Text = "<ul>\n";
        foreach ($this->Messages as $Message)
        {
            $Text .= sprintf("<li>%s</li>\n", $Message);
        }
        foreach ($this->FormMessages as $Message)
        {
            $Text .= sprintf("<li>%s</li>\n", $Message);
        }
        $Text .= "</ul>\n";

        return $Text;
    }

    function HasErrors()
    {
        return (count($this->Messages) + count($this->FormMessages)) ? true : false;
    }

    function GetMessageForField($FormFieldName)
    {
        if (isset($this->FormMessages[$FormFieldName]))
        {
            return $this->FormMessages[$FormFieldName];
        }
        else
        {
            return NULL;
        }
    }


    # ---- PRIVATE INTERFACE -------------------------------------------------

    var $Messages;
    var $FormMessages;

}

# load system, session, and user information
$DB        = new SPTDatabase();
$SysConfig = new SystemConfiguration($DB);
$G_SysConfig =& $SysConfig;
$Session   = new Session($DB);
$User      = new SPTUser();
$G_User    =& $User;
if ($G_User->IsLoggedIn())
{
    $G_User->LastLocation(basename($_SERVER["SCRIPT_FILENAME"]));
}

# load technical info if user is system administrator
if ($User->HasPriv(PRIV_SYSADMIN)) 
{
    if (file_exists("VERSION"))
    {
        $VersionArray = file("VERSION");
    }
    elseif (file_exists("../VERSION"))
    {
        $VersionArray = file("../VERSION");
    }
    else
    {
        $SPT_SoftwareVersion = "--";
        $SPT_SoftwareVersionToDisplay = $SPT_SoftwareVersion;
    }
    if (!isset($SPT_SoftwareVersion))
    {
        # SPT <--> CWIS version mapping
        # (this must match the similar maps in:
        #     SPT--InstallComplete.php,
        #     include/SPT--Common.php,
        #     SPT--BuildRelease, and
        #     sptinstall)
        $SPT_SPTCWISVersionMap = array(
                "1.1.4" => "0.9.0",
                "1.1.5" => "0.9.1",
                "1.1.6" => "0.9.2",
                "1.1.7" => "0.9.3",
                "1.1.8" => "0.9.4",
                "1.2.0" => "1.0.0",
                "1.2.1" => "1.0.1",
                "1.2.2" => "1.1.0",
                "1.2.3" => "1.1.1",
                );
        $SPT_SoftwareVersion = chop($VersionArray[0]);
        if (SoftwareIsCWIS() && (floatval($SPT_SoftwareVersion) < 1.3))
        {
            $SPT_SoftwareVersionToDisplay = $SPT_SPTCWISVersionMap[$SPT_SoftwareVersion];
        }
        else
        {
            $SPT_SoftwareVersionToDisplay = $SPT_SoftwareVersion;
        }
    }
}

# get around register_globals possibly being set to OFF
if (isset($_POST))
{
    foreach ($_POST as $VarName => $VarValue)
    {
        if (!empty($VarValue))
        {
            $$VarName = $VarValue;
        }
    }
}
if (isset($_GET))
{
    foreach ($_GET as $VarName => $VarValue)
    {
        if (!empty($VarValue))
        {
            $$VarName = $VarValue;
        }
    }
}

# strip PHP-inserted backslashes out of any incoming form variables
if (get_magic_quotes_gpc() && count($_POST))
{
    foreach ($_POST as $Key => $Value)
    {  
        if (isset($$Key))
        {  
            if (is_string($$Key))
            {  
                $$Key = stripslashes($Value);  $_POST[$Key] = $$Key;  
            }
        }
    }
}
if (get_magic_quotes_gpc() && count($_GET))
{
    foreach ($_GET as $Key => $Value)
    {  
        if (isset($$Key))
        {  
            if (is_string($$Key))
            {  
                $$Key = stripslashes($Value);  $_GET[$Key] = $$Key;  
            }
        }
    }
}

function SoftwareIsCWIS()
{
    global $SPT_DefaultUI;
    return ($SPT_DefaultUI == "SPTUI--CWIS") ? TRUE : FALSE;
}

function UserIsLoggedIn()
{
    global $User;
    return $User->IsLoggedIn();
}

function LogMsg($Msg)
{
    $Output = fopen("/tmp/PhpLogMsg.log", "a");
    fwrite($Output, date("Y-m-d H:i  ").$Msg."\n");
    fclose($Output);
}

function FindUIFile($FileName)
{
    global $User;
    global $SysConfig;
    global $SPT_DefaultUI;
    global $NavDirCorrection;

    # if user is logged in and multiple UIs are allowed or user is sys admin
    if ($User->IsLoggedIn() && ($SysConfig->AllowMultipleUIsEnabled() || $User->HasPriv(PRIV_SYSADMIN)))
    {
        # use UI selected by user
        $ActiveUI = $User->Get("ActiveUI");
    }
    else
    {
        # use default system UI
        $ActiveUI = $SysConfig->DefaultActiveUI();
    }

    # if file is in active UI directory
    if (file_exists($ActiveUI."/".$FileName))
    {
        # use file from active UI directory
        $FileName = $ActiveUI."/".$FileName;
    }
    else
    {
        # if file is in default UI directory
        if (file_exists($SPT_DefaultUI."/".$FileName))
        {
            # use file from default UI directory
            $FileName = $SPT_DefaultUI."/".$FileName;
        }
    }

    # return (possibly) revised name to caller
    return $FileName;
}

function GetCurrentThemeDir()
{
    global $SysConfig;
    global $User;

    # if accessibility wizard is enabled 
    #     and user has accessibility attribute selected that requires accessible theme
    if ($SysConfig->AccessibilityWizardEnabled()
        && (($User->PrefFontSize() > 0)
            || (strlen($User->PrefFontTypeFace()))
            || (strlen($User->PrefFontColor()))
            || (strlen($User->PrefBackgroundColor()))
            || ($User->PrefColorAvoidanceFlags() > 0)))
    {
        # print accessible theme
        return "Theme--Accessible";
    }
    else
    {
        # print configured theme
        return $SysConfig->CurrentTheme();
    }
}

function CorrespondingHtmlFile()
{
    global $NavDirCorrection;

    # replace ".php" with ".html" in our file name
    $FileName = preg_replace("/\.php$/", ".html", GetScriptFileName());

    # select file from UI directory if available
    $FileName = FindUIFile($FileName);

    # return resulting file name to caller
    return $FileName;
}

function CheckAuthorization($AuthFlag = NULL, $AuthFlag2 = NULL, $AuthFlag3 = NULL, $AuthFlag4 = NULL, $AuthFlag5 = NULL, $AuthFlag6 = NULL)
{
    # pull in global values in case page loaded assumes they're available
    global $DB;
    global $Session;
    global $User;
    global $G_User;
    global $SysConfig;

    # provide relative path to base SPT directory
    if (InMetadataTool())
        $NavDirCorrection = "../";
    else
        $NavDirCorrection = "";

    if ($User->IsLoggedIn()
            && (!$AuthFlag || $User->HasPriv($AuthFlag, $AuthFlag2, $AuthFlag3, $AuthFlag4, $AuthFlag5, $AuthFlag6)))
    {
        return;
    }
    else
    {
        include("include/SPT--UnauthorizedAccess.php");
        exit();
    }
}

function CheckEditResource( $LocalResource=NULL )
{
    global $User;
    global $Resource;
    global $Result;
    
    if ( $User->HasPriv(PRIV_RESOURCEADMIN, PRIV_RELEASEADMIN) )
        return true;

    else if ( $User->HasPriv( PRIV_MYRESOURCEADMIN ) )
    {

        if ( is_array( $LocalResource ) )
            return $User->Get( "UserId" ) ==
                   $LocalResource["Added By Id"]->Get("UserId");
        else if ( is_array( $Result ) )
            return $User->Get( "UserId" ) ==
                   $Result["Added By Id"]->Get("UserId");
        
        else if ( is_object($LocalResource) )
            return $User->Get( "UserName" ) == 
                   $LocalResource->Get("Added By Id");
        else if ( is_object($Resource) )
            return $User->Get( "UserName" ) == $Resource->Get("Added By Id");

        else
        {
            print "Resource is not and object.";
            return false;
        }
    }
    else
        return false;
}

function ErrorOut($Message)
{
    # pull in global values in case files loaded assume they're available
    global $DB;
    global $Session;
    global $User;
    global $G_User;
    global $SysConfig;

    # provide relative path to base SPT directory
    if (InMetadataTool())
        $NavDirCorrection = "../";

    include(FindUIFile("include/SPT--StandardPageStart.html"));
    print($Message);
    include(FindUIFile("include/SPT--StandardPageEnd.html"));
    exit(0);
}

function getmicrotime()
{
    list($usec, $sec) = explode(" ", microtime()); 
    return ((float)$usec + (float)$sec); 
}

function PrintErrorMessageList()
{
    global $ErrorMessages;

    if (isset($ErrorMessages))
    {
        if ($ErrorMessages->HasErrors())
        {
            print($ErrorMessages->GetMessagesAsUList());
        }
    }
}

function PageTitle($NewTitle = NULL)
{
    global $SysConfig;
    static $Title;

    if (isset($NewTitle))
    {  
        if (strlen($SysConfig->PortalName()) > 0)
        {
            $Title = $SysConfig->PortalName()." - ".$NewTitle;  
        }
        else
        {
            $Title = $NewTitle;  
        }
    }
    return $Title;
}

function GetActiveUIOptionList($Selected)
{
    # start out with empty list
    $Text = "";

    # for each file in current directory
    $Dir = dir(".");
    while (($DirEntry = $Dir->read()) !== FALSE)
    {
        # if file is UI directory
        if (is_dir($DirEntry) && preg_match("/SPTUI--[a-zA-Z]+/", $DirEntry))
        {
            # read UI name (if available)
            $UIName = "";
            $UINameFile = $DirEntry."/NAME";
            if (is_readable($UINameFile))
            {
                $FHandle = fopen($UINameFile, "r");
                $UIName = fgets($FHandle, 64);
                fclose($FHandle);
            }
            if (strlen($UIName) < 1) {  $UIName = $DirEntry;  }

            # print option tag for UI
            if ($DirEntry == $Selected) {  $Select = " selected";  } else {  $Select = "";  }
            $Text .= "<option value=\"${DirEntry}\"${Select}>${UIName}</option>\n";
        }
    }

    # return list to caller
    return $Text;
}

function GetThemeOptionList($Selected)
{
    # start out with empty list
    $Text = "";

    # for each file in current interface directory
    global $SysConfig;
    $Dir = dir("./".$SysConfig->DefaultActiveUI()."/Themes");
    while (($DirEntry = $Dir->read()) !== FALSE)
    {
        # if file is directory
        $FullDirName = "./".$SysConfig->DefaultActiveUI()."/Themes/".$DirEntry;
        if (is_dir($FullDirName) && preg_match("/Theme--[a-zA-Z]+/", $DirEntry))
        {
            # read UI name (if available)
            $UIName = "";
            $UINameFile = $FullDirName."/NAME";
            if (is_readable($UINameFile))
            {
                $FHandle = fopen($UINameFile, "r");
                $UIName = fgets($FHandle, 64);
                fclose($FHandle);
            }
            if (strlen($UIName) < 1) {  $UIName = $DirEntry;  }

            # print option tag for UI
            if ($DirEntry == $Selected) {  $Select = " selected";  } else {  $Select = "";  }
            $Text .= "<option value=\"${DirEntry}\"${Select}>${UIName}</option>\n";
        }
    }

    # return list to caller
    return $Text;
}

# Character set encoding hard-coded here for now
function GetCharacterSetOptionList($Selected)
{
    $CharSets = array("ISO-8859-1", "UTF-8");

    $Text = "";
    foreach ($CharSets as $CharSet)
    {
        if ($Selected == $CharSet)
            $Select = " selected";
        else
            $Select = NULL;
            
        $Text .= "<option value=\"$CharSet\"$Select>$CharSet</option>\n";
    }
    return $Text;
}

function InMetadataTool()
{
    global $Editing;

    if ((strstr($_SERVER["SCRIPT_NAME"], "/MetadataTool/")
                    && (strstr($_SERVER["SCRIPT_NAME"], "SPT--ImportData") == FALSE)
                    && (strstr($_SERVER["SCRIPT_NAME"], "SPT--EditControlledNameTypes") == FALSE))
            || (strstr($_SERVER["SCRIPT_NAME"],
                    "SPT--BrowseResources.php") && $Editing)
            || (strstr($_SERVER["SCRIPT_NAME"],
                    "SPT--Advanced.php") && $Editing)
            || (strstr($_SERVER["SCRIPT_NAME"],
                    "SPT--AdvancedSearch.php") && $Editing))
    {
        return TRUE;
    }
    else
    {
        return FALSE;
    }
}

function SearchTermHandlingIsAnd()
{
    global $SysConfig;
    return ($SysConfig->SearchTermsRequired()); 
}

function CloseTags($Tag, $Text)
{
    # if there are a greater number of opening tags than closing tags
    if (preg_match_all("/<".$Tag.">/i", $Text, $Dummy) > preg_match_all("/<\\/".$Tag.">/i", $Text, $Dummy))
    {
        # add closing tag to text
        $Text .= "</".$Tag.">";
    }

    # return (possibly) revised text to caller
    return $Text;
}

function GetHtmlTranslatedString($Value)
{
    $Value = stripslashes($Value);
    $Value = str_replace(array("&", ">", "<", "\"", "'"),
                        array("&amp;", "&gt;", "&lt;", "&quot;", "&#039;"),
                        $Value);
    return $Value;
}

# retrieve PHP configuration settings via call to phpinfo()
function GetPhpInfo()
{
    # grab PHP info page
    ob_start();
    phpinfo();
    $InfoPage = ob_get_contents();
    ob_end_clean();   
  
    # start by assuming that no info is available
    $Info = array();
  
    # for each section on page
    $PageChunks = explode("<h2", $InfoPage);
    foreach ($PageChunks as $PageChunk)
    {
        # look for module/section name
        preg_match("/<a name=\"module_([^<>]*)\">/", $PageChunk, $Piece);

        # if we found module/section
        if (count($Piece) > 1)
        {
            # save module/section name
            $ModuleName = trim($Piece[1]);
        }
        else
        {
            # assume no module/section name
            $ModuleName = "";
        }

        # pull out info values from HTML tables
        preg_match_all("/<tr[^>]*><td[^>]*>(.*)<\/td><td[^>]*>(.*)<\/td>/Ux", 
                       $PageChunk, $LocalValue);
        preg_match_all("/<tr[^>]*><td[^>]*>(.*)<\/td><td[^>]*>(.*)<\/td><td[^>]*>(.*)<\/td>/Ux", 
                       $PageChunk, $MasterValue);

        # store "local" info values
        foreach ($LocalValue[0] as $MatchString => $Dummy)
        {
            $MatchString = trim($MatchString);
            $Info[$ModuleName][trim(strip_tags($LocalValue[1][$MatchString]))] = 
                    array(trim(strip_tags($LocalValue[2][$MatchString])));
        }

        # store "master" info values
        foreach ($MasterValue[0] as $MatchString => $Dummy)
        {
            $MatchString = trim($MatchString);
            $Info[$ModuleName][trim(strip_tags($MasterValue[1][$MatchString]))] = 
                    array(trim(strip_tags($MasterValue[2][$MatchString])), trim(strip_tags($MasterValue[3][$MatchString])));
        }               
    }

    # return info to caller
    return $Info;
}

# debugging output utility function (should not be used in production code)
function PrintForDebug($VarName, $VarValue)
{
    print("<pre>".$VarName.":\n");
    print_r($VarValue);
    print("</pre>\n");
}

# return our URL
function OurUrl()
{
    $Url = "http://".(($_SERVER["SERVER_NAME"] != "127.0.0.1")
                ? $_SERVER["SERVER_NAME"]
                : $_SERVER["HTTP_HOST"])
            .$_SERVER["SCRIPT_NAME"];
    return $Url;
}

# return our base URL with trailing slash
function OurBaseUrl()
{
    $BaseUrl = "http://".(($_SERVER["SERVER_NAME"] != "127.0.0.1")
                ? $_SERVER["SERVER_NAME"]
                : $_SERVER["HTTP_HOST"])
            .dirname($_SERVER["SCRIPT_NAME"]);
    if (substr($BaseUrl, -1) != "/")
    {
        $BaseUrl .= "/";
    }
    return $BaseUrl;
}

# attempt to truncate a string as neatly as possible with
#        respect to word breaks and punctuation
function NeatlyTruncateString($String, $MaxLength)
{
    $StringEnd = strlen($String) - 1;
    if ($StringEnd >= $MaxLength)
    {
        while (($StringEnd >= $MaxLength)
                || ((strchr(".!?,;: ", $String[$StringEnd]) === FALSE)
                        && ($StringEnd > 0)))
        {
            $StringEnd--;
        }
        while (strchr(",;: ", $String[$StringEnd])) {  $StringEnd--;  }
        if ($StringEnd <= 0) {  $StringEnd = $MaxLength;  }
        $String = substr($String, 0, ($StringEnd + 1));
        if (strchr(".!?", $String[$StringEnd]) === FALSE)
        {
            $String .= "...";
        }
    }
    return $String;
}

# retrieve file name of currently executing root script 
function GetScriptFileName()
{
    return basename(GetFullScriptFileName());
}

# retrieve full file name of currently executing root script (with directory)
function GetFullScriptFileName()
{
    if (isset($_SERVER["PATH_TRANSLATED"])
             && strlen($_SERVER["PATH_TRANSLATED"]))
    {
        $ScriptFileName = $_SERVER["PATH_TRANSLATED"];
    }
    elseif (isset($_SERVER["SCRIPT_FILENAME"])
             && strlen($_SERVER["SCRIPT_FILENAME"]))
    {
        $ScriptFileName = $_SERVER["SCRIPT_FILENAME"];
    } 
    elseif (isset($_SERVER["PATH_INFO"])
             && strlen($_SERVER["PATH_INFO"]))
    {
        $ScriptFileName = $_SERVER["PATH_INFO"];
    }
    else
    {
        exit("ERROR:  unable to determine script file name (GetScriptFileName())");
    }
    return $ScriptFileName;
}

# retrieve host name for given IP address (returns IP if no host name)
function GetHostName($IpAddress)
{
    static $HostNames;
    if (!isset($HostNames[$IpAddress]))
    {
        $HostNames[$IpAddress] = preg_match("/\b(?:[0-9]{1,3}\.){3}[0-9]{1,3}\b/",
                $IpAddress) ? gethostbyaddr($IpAddress) : $IpAddress;
    }
    return $HostNames[$IpAddress];
}


?>
