<?PHP

#
#   FILE:  Scout--OAIClient.php
#
#   METHODS PROVIDED:
#       OAIClient()
#           - constructor
#       SomeMethod($SomeParameter, $AnotherParameter)
#           - short description of method
#
#   AUTHOR:  Edward Almasy
#
#   Part of the Scout Portal Toolkit
#   Copyright 2005 Internet Scout Project
#   http://scout.wisc.edu
#

require_once("Scout--XMLParser.php");


class OAIClient {

    # ---- PUBLIC INTERFACE --------------------------------------------------

    # object constructor
    function __construct($ServerUrl)
    {
        # set default debug level
        $this->DebugLevel = 0;
        
        # save OAI server URL
        $this->ServerUrl = $ServerUrl;

        # set default metadata prefix
        $this->MetadataPrefix = "oai_dc";

        # set default set specification for queries
        $this->SetSpec = NULL;
    }

    # get/set server URL
    function ServerUrl($NewValue = NULL) 
    {  
        if ($NewValue != NULL) 
        {  
            $this->ServerUrl = $NewValue;  
        }  
        return $this->ServerUrl;  
    }
    
    # get/set metadata prefix
    function MetadataPrefix($NewValue = NULL) 
    {  
        if ($NewValue != NULL) 
        {  
            $this->MetadataPrefix = $NewValue;  
        }  
        return $this->MetadataPrefix;  
    }

    # get/set set specification for queries
    function SetSpec($NewValue = "X-NOSETSPECVALUE-X")
    {  
        if ($NewValue != "X-NOSETSPECVALUE-X")
        {  
            $this->SetSpec = $NewValue;  
        }  
        return $this->SetSpec;  
    }

    # query server for records
    function GetRecords($StartDate = NULL, $EndDate = NULL)
    {
        # if we have resumption token from prior query
        if (isset($this->ResumptionToken))
        {
            # use resumption token as sole argument
            $Args["resumptionToken"] = $this->ResumptionToken;
        }
        else
        {
            # set up arguments for query
            $Args["metadataPrefix"] = $this->MetadataPrefix;
            if ($StartDate) {  $Args["from"] = $StartDate;  }
            if ($EndDate)   {  $Args["until"] = $EndDate;  }
            if ($this->SetSpec) {  $Args["set"] = $this->SetSpec;  }
        }

        # query server for XML text
        $XmlText = $this->PerformQuery("ListRecords", $Args);
        if ($this->DebugLevel > 8) {  print("\n<pre>OAIClient::GetRecords()  XmlText = \n");  print_r(htmlspecialchars($XmlText));  print("</pre>\n");  }

        # create XML parser and pass it text
        $Parser = new XMLParser();
        $Parser->ParseText($XmlText);
        if ($this->DebugLevel > 9) {  print("\n<pre>OAIClient::GetRecords()  Parser = \n");  print_r($Parser);  print("</pre>\n");  }

        # if records were found
        $Records = array();
        $ItemCount = $Parser->SeekTo("oai-pmh", "listrecords", "record");
        if ($ItemCount)
        {
            # for each record
            $Index = 0;
            do
            {
                # grab record identifier and date
                $Records[$Index]["identifier"] = $Parser->GetData("header", "identifier");
                $Records[$Index]["datestamp"] = $Parser->GetData("header", "datestamp");

                # grab metadata
                $SeekResult = $Parser->SeekTo("metadata");
                if ($SeekResult)
                {
                    $SeekResult = $Parser->SeekToChild();
                    if ($SeekResult)
                    {
                        $Records[$Index]["format"] = $Parser->GetTagName();
                        $SeekResult = $Parser->SeekToChild();
                        if ($SeekResult)
                        {
                            $TagName = $Parser->GetTagName();
                            do
                            {
                                $Records[$Index]["metadata"][$TagName][] =
                                        $Parser->GetData();
                            } while ($TagName = $Parser->NextTag());
                            $Parser->SeekToParent();
                        }
                        $Parser->SeekToParent();
                    }
                    $Parser->SeekToParent();
                }

                # grab search info (if any)
                $SeekResult = $Parser->SeekTo("about");
                if ($SeekResult)
                {
                    $SeekResult = $Parser->SeekTo("searchInfo");
                    if ($SeekResult)
                    {
                        $SeekResult = $Parser->SeekToChild();
                        if ($SeekResult)
                        {
                            $TagName = $Parser->GetTagName();
                            do
                            {
                                $Records[$Index]["about"]["SEARCHINFO"][$TagName][] =
                                        $Parser->GetData();
                            } while ($TagName = $Parser->NextTag());
                            $Parser->SeekToParent();
                        }
                        $Parser->SeekToParent();
                    }
                    $Parser->SeekToParent();
                }

                $Index++;
            }
            while ($Parser->NextItem());
        }

        # look for resumption token and save if found
        $Parser->SeekToRoot();
        $SeekResult = $Parser->SeekTo(
                "oai-pmh", "listrecords", "resumptiontoken");
        if ($SeekResult !== NULL)
        {
            $this->ResumptionToken = $Parser->GetData();
        }
        else
        {
            unset($this->ResumptionToken);
        }

        # return records to caller
        return $Records;
    }

    # check whether more records are available after last GetRecords()
    function MoreRecordsAvailable()
    {
        return isset($this->ResumptionToken);
    }

    # clear any additional records available after last GetRecords()
    function ResetRecordPointer()
    {
        unset($this->ResumptionToken);
    }
 

    # ---- PRIVATE INTERFACE -------------------------------------------------

    var $ServerUrl;
    var $MetadataPrefix;
    var $SetSpec;
    var $DebugLevel;
    var $ResumptionToken;
    
    # set current debug output level (0-9)
    function SetDebugLevel($NewLevel)
    {
        $this->DebugLevel = $NewLevel;
    }
    
    # perform OAI query and return resulting data to caller
    function PerformQuery($QueryVerb, $Args)
    {
        # open stream to OAI server
        $QueryUrl = $this->ServerUrl."?verb=".$QueryVerb;
        foreach ($Args as $ArgName => $ArgValue)
        {
            $QueryUrl .= "&".urlencode($ArgName)."=".urlencode($ArgValue);
        }
        $FHndl = fopen($QueryUrl, "r");

        # if stream was successfully opened
        $Text = "";
        if ($FHndl !== FALSE)
        {
            # while lines left in response
            while (!feof($FHndl))
            {
                # read line from server and add it to text to be parsed
                $Text .= fread($FHndl, 10000000);
            }
        }

        # close OAI server stream
        fclose($FHndl);

        # return query result data to caller
        return $Text;
    }
}


?>
