<?PHP
#
#   FILE:  SPT--ViewLog.php
#
#   FUNCTIONS PROVIDED:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function supplied for use in HTML file
#
#   FUNCTIONS EXPECTED:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function that HTML file must supply
#
#   OPTIONAL FUNCTIONS:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function that HTML file may supply
#
#   FORM FIELDS EXPECTED:
#       F_FormFieldName
#           - brief description of form field purpose and/or content
#
#   Part of the Scout Portal Toolkit
#   Copyright 2007 Internet Scout
#   http://scout.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--SPTEventLog.php");
PageTitle("View Log Entries");


# ----- CONFIGURATION  -------------------------------------------------------

# ----- EXPORTED FUNCTIONS ---------------------------------------------------
# (functions intended for use in corresponding HTML file)

# ----- LOCAL FUNCTIONS ------------------------------------------------------
# (functions intended for use only within this file)

# ----- MAIN -----------------------------------------------------------------

# set up possible search option values
$G_LogTypes = array(
        "Search" => "Search",
        "Failed Search" => "Failed Search",
#        "Login" => "Login",
#        "Account Signup" => "Account Signup",
#        "OAI Harvest" => "OAI Harvest",
        );

# retrieve type of log to display
$G_CurrentLogType = isset($_POST["F_LogType"]) ? $_POST["F_LogType"] 
        : (isset($_GET["LT"]) ? $_GET["LT"] : "Search");

# check to make sure user has required permissions to view this type of log
switch ($G_CurrentLogType)
{
    case "Search":
    case "Failed Search":
    case "OAI Harvest":
        CheckAuthorization(PRIV_SYSADMIN, PRIV_COLLECTIONADMIN);
        break;

    case "Login":
    case "Account Signup":
        CheckAuthorization(PRIV_SYSADMIN, PRIV_USERADMIN);
        break;

    default:
        CheckAuthorization(PRIV_SYSADMIN);
        break;
}

# retrieve log display mode and starting point within log
$G_CurrentLogOption = isset($_POST["F_LogOption"]) ? $_POST["F_LogOption"] 
        : (isset($_GET["LO"]) ? $_GET["LO"] : "Non-Priv");
$G_StartingIndex = isset($_GET["SI"]) ? $_GET["SI"] : 0;
$G_EntriesPerPage = 25;

# handle any action requests
$Log = new SPTEventLog();
if (isset($_GET["AC"]))
{
    switch ($_GET["AC"])
    {
        case "Spam":
            if ($G_User->HasPriv(PRIV_SYSADMIN))
            {
                $Log->ModifyEvents($_GET["ET"], $_GET["ED"], $_GET["UI"], NULL, "-1");
            }
            break;
    }
}

# load requested log entries
$Log = new SPTEventLog();
switch ($G_CurrentLogType)
{
    case "Search":
    case "Failed Search":
        $G_LogOptions = array(
                "Anon" => "Anon",
                "Non-Priv" => "Non-Priv",
                "Privileged" => "Privileged",
                "All" => "All",
                );
        $G_CurrentLogOption = $G_CurrentLogOption ? $G_CurrentLogOption : "Non-Priv";
        switch ($G_CurrentLogOption)
        {
            case "Anon":
                $Log->AddSqlConditionForFind("UserId < 0");
                break;
        
            case "Non-Priv":
                $Log->ExcludeUsersWithPrivilegesForFind("<", PRIV_POSTTOFORUMS);
                $Log->ExcludeUsersWithPrivilegesForFind(">", PRIV_USERDISABLED);
                break;
        
            case "Privileged":
                $Log->AddSqlConditionForFind("UserId IN"
                        ." (SELECT UserId FROM APUserPrivileges"
                                ." WHERE Privilege < ".PRIV_POSTTOFORUMS
                                ." OR Privilege > ".PRIV_USERDISABLED.")");
                break;
        }
        if ($G_CurrentLogType == "Failed Search")
        {
            $Log->AddSqlConditionForFind("DataTwo = 0");
        }
        else
        {
            $Log->AddSqlConditionForFind("DataTwo >= 0");
        }
        $G_EventInfo = $Log->FindEvents(NULL, NULL, $G_StartingIndex,
                ($G_EntriesPerPage + 1),
                SPTEVENT_SEARCH, SPTEVENT_ADVANCEDSEARCH);
        break;

    case "OAI Harvest":
        $G_LogOptions = array(
                "All" => "All",
                "Exclude Resumes" => "Exclude Resumes",
                );
        $G_CurrentLogOption = $G_CurrentLogOption ? $G_CurrentLogOption : "All";
        switch ($G_CurrentLogOption)
        {
            case "Exclude Resumes":
                $Log->AddSqlConditionForFind(
                        "DataTwo NOT LIKE '%ResumptionToken%'");
                break;
        }
        $G_EventInfo = $Log->FindEvents(NULL, NULL, $G_StartingIndex,
                ($G_EntriesPerPage + 1), SPTEVENT_OAIHARVEST);
        foreach ($G_EventInfo as $Index => $Info)
        {
            $Args = explode("&", $Info["DataTwo"]);
            foreach ($Args as $Arg)
            {
				if ($Arg != "") {
					list($VarName, $VarValue) = explode("=", $Arg);
					if (isset($VarValue) && strlen($VarValue))
					{
						$G_EventInfo[$Index]["Args"][strtolower($VarName)] = 
								trim(urldecode($VarValue));
					}
				}
            }
        }
        break;

    default:
        $G_EventInfo = array();
        break;
}

# check for whether we need paging links
if (count($G_EventInfo) > $G_EntriesPerPage)
{
    $G_MoreEntriesAvailable = TRUE;
    array_pop($G_EventInfo);
}
else
{
    $G_MoreEntriesAvailable = FALSE;
}

include("include/SPT--StandardHtmlPageLoad.php");

?>
