
-- synonym support in OSMASE
CREATE TABLE SearchWordSynonyms (
    WordIdA             INT,
    WordIdB             INT,
    INDEX               (WordIdA, WordIdB)
);

-- attached files           
CREATE TABLE Files (
    FileId                  INT NOT NULL AUTO_INCREMENT,
    ResourceId              INT NOT NULL,
    FieldId                 INT NOT NULL,
    FileName                TEXT,
    FileComment             TEXT,
    FileLength              INT,
    FileType                INT,
    SecretString            TEXT,
    INDEX                   (ResourceId),
    INDEX                   (FileId),
    INDEX                   (ResourceId, FieldId)
);
ALTER TABLE MetadataFields CHANGE COLUMN FieldType FieldType 
        ENUM("Text", "Number", "Date", "TimeStamp", "Paragraph", "Flag", 
        "Tree", "ControlledName", "Option", "User", "Still Image", "File");

ALTER TABLE ControlledNames ADD INDEX (FieldId);
ALTER TABLE ControlledNames ADD INDEX (ControlledName(16));
ALTER TABLE VariantNames ADD INDEX (VariantName(16));

-- support for server traffic stats packages
ALTER TABLE SystemConfiguration ADD COLUMN AddAWStatsScript INT DEFAULT 0;
ALTER TABLE SystemConfiguration ADD COLUMN AddGoogleAnalytics INT DEFAULT 0;
ALTER TABLE SystemConfiguration ADD COLUMN GoogleAnalyticsCode TEXT;

-- updated user registration support
ALTER TABLE SystemConfiguration ADD COLUMN PasswordResetMailSubject TEXT;
ALTER TABLE SystemConfiguration ADD COLUMN PasswordResetMailBody TEXT;
UPDATE SystemConfiguration SET PasswordResetMailSubject = 'Change Password On X-PORTALNAME-X';
UPDATE SystemConfiguration SET PasswordResetMailBody = 'Someone (presumably you) has asked to change your password on X-PORTALNAME-X for the account X-USERNAME-X.\n\nTo change your password, please click on this link:\n\n  X-RESETURL-X\n\nIf that link doesn\'t work you can also go to this address:\n\n  X-MANUALRESETURL-X\n\nAnd enter your user name and password reset code:\n\n  Name:  X-USERNAME-X\n  Code:  X-RESETCODE-X\n\nYour password will remain the same until changed via one of the above links.\n\nFor reference, the password change request came from address X-IPADDRESS-X.';
UPDATE SystemConfiguration SET PasswordMailSubject = 'New Login for X-PORTALNAME-X (X-USERNAME-X)';
UPDATE SystemConfiguration SET PasswordMailBody = '\nThank you for signing up on X-PORTALNAME-X!\n\nTo activate your new login, please click on the link below:\n\n   X-ACTIVATIONURL-X\n\nIf the link doesn\'t work you can also go to this address:\n\n   X-MANUALACTIVATIONURL-X\n\nAnd enter your user name and activation code:\n\n   Name:  X-USERNAME-X\n   Code:  X-ACTIVATIONCODE-X\n\nWe\'re looking forward to seeing you online!';
ALTER TABLE APUsers ADD COLUMN RegistrationConfirmed INT DEFAULT 0;


