<?php

#
#   FILE:  SPT--Home.php
#
#   FUNCTIONS PROVIDED:
#       PrintAnnouncementsTableRows()
#           - outputs HTML for News & Announcements table
#       PrintNewResourceTableRows()
#           - outputs HTML for New Resources table
#       NumAnnouncementRows()
#           - returns the number or Announcements to be displayed 
#
#   FUNCTIONS EXPECTED:
#       PrintAnnouncementRow($Headline, $DatePosted, $PosterName, $Text, 
#                   $EditOkay, $EditLink)
#           - called to print line in News & Announcements table
#       PrintNoAnnouncementsMessage()
#           - called to print message that there were no announcements
#       PrintNewResourceRow($Title, $Description, $FullRecordLink, $Url, 
#                   $DateOfRecordCreation, $DateRecordAdded, $Contributor, 
#                   $EditOkay, $EditUrl, $DateLastVerified, $DateLastModified)
#           - called to print line in New Resources table
#       PrintNoResourcesMessage()
#           - called to print message that there were no resources to display
#
#   Part of the Scout Portal Toolkit
#   Copyright 2003 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--Resource.php");
PageTitle("Home");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function AnnouncementsEnabled()
{
    global $SysConfig;

    return $SysConfig->AnnouncementsEnabled();
}

function PrintPrevAnnouncementLink()
{
    global $SysConfig;
    global $AnnouncementOffset;

    $NumAnnouncements = $SysConfig->NumAnnounceOnHomePage();
    $Offset = $AnnouncementOffset + $NumAnnouncements;

    print "SPT--Home.php?AnnouncementOffset=$Offset";
}

function PrintNextAnnouncementLink()
{
    global $SysConfig;
    global $AnnouncementOffset;

    $NumAnnouncements = $SysConfig->NumAnnounceOnHomePage();
    $Offset = $AnnouncementOffset - $NumAnnouncements;

    print "SPT--Home.php?AnnouncementOffset=$Offset";
}

function NextAnnouncementsAvailable()
{
    global $SysConfig;
    global $AnnouncementOffset;

    $NumAnnouncements = $SysConfig->NumAnnounceOnHomePage();
    return ($AnnouncementOffset >= $NumAnnouncements) ? TRUE : FALSE;
}

function PreviousAnnouncementsAvailable()
{
    global $MoreAnnouncements;
    return $MoreAnnouncements;
}

function PrintNumberOfAnnouncements()
{
    global $SysConfig;
    print $SysConfig->NumAnnounceOnHomePage();
}

function PrintAnnouncementsTableRows()
{
    global $User;
    global $DB;
	global $SysConfig;
	global $MoreAnnouncements;
    global $AnnouncementOffset;

    # if function to supply announcement DB query is available
    if (function_exists("SupplyAnnouncementDisplayQuery"))
    {
        # obtain query from function
        $DisplayQuery = SupplyAnnouncementDisplayQuery(
                $MaxNumberOfDaysToGoBackForAnnouncements,
                $SysConfig->NumAnnounceOnHomePage());
    }
    else
    {
        # use default query
        $DisplayQuery = "SELECT * FROM Announcements "
                ."ORDER BY DatePosted DESC "
                ."LIMIT ${AnnouncementOffset}, "
                ."999999999";
    }

    # query database for appropriate announcements
    $AnnouncementDB = new SPTDatabase();
    $AnnouncementDB->Query($DisplayQuery);

    # determine number of announcements to display
    $MaxNumberOfAnnouncementsToDisplay=min($SysConfig->NumAnnounceOnHomePage(),
        $AnnouncementDB->NumRowsSelected());

    # determine if previous link should be displayed or not
    $MoreAnnouncements = ($AnnouncementDB->NumRowsSelected() <=
            $MaxNumberOfAnnouncementsToDisplay) ? false : true;

    # if announcements found
    if ($AnnouncementDB->NumRowsSelected() > 0)
    {
        $Index = 0;
        # for each announcement
        while ($Index++ < $MaxNumberOfAnnouncementsToDisplay)
        {
            $Announcement = $AnnouncementDB->FetchNextRowArray();
            
            # format date for display
            $DatePosted = date("M j", strtotime($Announcement["DatePosted"]));

            # get name of person who posted announcement
            $Poster = new User($DB, (int)$Announcement["PosterId"]);
            $PosterName = $Poster->Get("UserName");
            if (strlen($PosterName) < 1) {  $PosterName = "(unknown)";  }

            # print row with announcement info
            PrintAnnouncementRow(
                    $Announcement["AnnouncementHeading"],
                    $DatePosted,
                    $PosterName,
                    $Announcement["AnnouncementText"],
                    $User->HasPriv(PRIV_NEWSADMIN),
                    "SPT--EditAnnouncement.php?F_Editing=1&F_Id=".
                    $Announcement["AnnouncementId"]);
        }
    }
    else
    {
        # print row with "no announcements" notice
        PrintNoAnnouncementsMessage();
    }
}

function NumAnnouncementRows()
{
    global $DB;
	global $SysConfig;
    global $_GET;

    # if function to supply announcement DB query is available
    if (function_exists("SupplyAnnouncementDisplayQuery"))
    {
        # obtain query from function
        $DisplayQuery = SupplyAnnouncementDisplayQuery(
                $MaxNumberOfDaysToGoBackForAnnouncements,
                $SysConfig->NumAnnounceOnHomePage());
    }
    else
    {
        # use default query
        $DisplayQuery = "SELECT * FROM Announcements "
                ."ORDER BY DatePosted DESC "
                ."LIMIT 0, "
                ."999999999";
    }

    # query database for appropriate announcements
    $AnnouncementDB = new SPTDatabase();
    $AnnouncementDB->Query($DisplayQuery);
    return $AnnouncementDB->NumRowsSelected();

}


function PrintPrevResourceLink()
{
    global $SysConfig;
    global $ResourceOffset;

    $NumResources = $SysConfig->NumResourcesOnHomePage();
    $Offset = $ResourceOffset + $NumResources;

	if (strpos($_SERVER['REQUEST_URI'],".php") > 0)
	{
		print "SPT--Home.php?ResourceOffset=$Offset";
	}
    else
	{
		print "?ResourceOffset=$Offset";
	}
}

function PrintNextResourceLink()
{
    global $SysConfig;
    global $ResourceOffset;

    $NumResources = $SysConfig->NumResourcesOnHomePage();
    $Offset = $ResourceOffset - $NumResources;
	
	if (strpos($_SERVER['REQUEST_URI'],".php") > 0)
	{
		print "SPT--Home.php?ResourceOffset=$Offset";
	}
    else
	{
		print "?ResourceOffset=$Offset";
	}
}

function NextResourcesAvailable()
{
    global $SysConfig;
    global $ResourceOffset;

    $NumResources = $SysConfig->NumResourcesOnHomePage();
    return ($ResourceOffset >= $NumResources) ? TRUE : FALSE;
}

function PreviousResourcesAvailable()
{
    global $MoreResources;
    return $MoreResources;
}

function PrintNumberOfResources()
{
    global $SysConfig;
    print $SysConfig->NumResourcesOnHomePage();
}

function PrintNewResourceTableRows()
{
    global $User;
    global $DB;
    global $MoreResources;
	global $SysConfig;
    global $ResourceOffset;

    $MaxDescriptionLength = 250;
    $MaxUrlLength = 60;

    if (is_null($ResourceOffset))
        $ResourceOffset = 0;

    # default values
    $MaxNumberOfResourcesToDisplay = $SysConfig->NumResourcesOnHomePage();
    $MaxNumberOfDaysToGoBackForResources = 3650;

    # if function to supply new resources is available
    if (function_exists("Local_GetNewResources"))
    {
        # call function to supply new resources
        $Resources = Local_GetNewResources(
                ($MaxNumberOfResourcesToDisplay + 1),
                $ResourceOffset,
                $MaxNumberOfDaysToGoBackForResources);
    }
    # backward compatibility to look for query string in UI file
    else if (function_exists("SupplyResourceDisplayQuery"))
    {
                # obtain query from function
        $DisplayQuery = SupplyResourceDisplayQuery(
                $MaxNumberOfDaysToGoBackForResources,
                $MaxNumberOfResourcesToDisplay);

        # query database for appropriate resources
        $ResourceDB = new SPTDatabase();
        $ResourceDB->Query($DisplayQuery);
        # set resource count
        $ResourceCount = $ResourceDB->NumRowsSelected();
        # get resources
        $Resources = array();
        while ($Resource = $ResourceDB->FetchNextRowArray())
        {
            array_push($Resources, new Resource($Resource["ResourceId"]));
        }
    }
    else
    {
        # retrieve resources using factory
        # NOTE:  Retrieves one more resource than is needed because we need
        #       to know if there are more resources.)
        $ResourceFact = new ResourceFactory();
        $Resources = $ResourceFact->GetRecentlyReleasedResources(
                ($MaxNumberOfResourcesToDisplay + 1), 
                $ResourceOffset, $MaxNumberOfDaysToGoBackForResources);
    }

    # determine whether "Previous" link should be displayed
    $ResourceCount = count($Resources);
    $MoreResources = ($ResourceCount <= $MaxNumberOfResourcesToDisplay) ? FALSE : TRUE;

    # if resources found
    if ($ResourceCount)
    {
        # drop last resource if we have one more than is needed
        if ($ResourceCount > $MaxNumberOfResourcesToDisplay) {  array_pop($Resources);  }

        # for each resource
        foreach ($Resources as $Resource)
        {
			# display resource
			if (strpos($_SERVER['REQUEST_URI'],".php") > 0)
			{
				PrintNewResourceRow($Resource,
                    "SPT--FullRecord.php?ResourceId=".$Resource->Id(),
                    $Resource->UserCanEdit($User),
                    "MetadataTool/SPT--DBEntry.php?ResourceId=".$Resource->Id(),
                    $Resource->ScaledCumulativeRating());
			}
			else
			{
				PrintNewResourceRow($Resource,
                    "../full-record-resource?ResourceId=".$Resource->Id(),
                    $Resource->UserCanEdit($User),
                    "MetadataTool/SPT--DBEntry.php?ResourceId=".$Resource->Id(),
                    $Resource->ScaledCumulativeRating());
			}
            
        }
    }
    else
    {
        # print row with "no resources" notice
        PrintNoResourcesMessage();
    }
}


# ----- MAIN -----------------------------------------------------------------
global $ResourceOffset;
global $AnnouncementOffset;

if (isset($_GET["ResourceOffset"]))
    $ResourceOffset = intval($_GET["ResourceOffset"]);
else
    $ResourceOffset = 0;

if (isset($_GET["AnnouncementOffset"]))
    $AnnouncementOffset = intval($_GET["AnnouncementOffset"]);
else
    $AnnouncementOffset = 0;

# load header, set the character set
#header("Content-type: text/html; charset=".$SysConfig->DefaultCharacterSet(), true);

# (we don't use CorrespondingHtmlFile() here because 
#       we may be accessed as "index.php")
include(FindUIFile("include/SPT--StandardPageStart.html"));
include(FindUIFile("SPT--Home.html"));
include(FindUIFile("include/SPT--StandardPageEnd.html"));

?>
