<?php
#
#   FILE:  SPT--EditRSSImport.php
#
#   FUNCTIONS PROVIDED:
#       None
#
#   FUNCTIONS EXPECTED:
#       None
#
#   Part of the Scout Portal Toolkit
#   Copyright 2001 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
PageTitle("Edit RSS Import Configuration");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function PrintTitle()
{
    global $Entry;

    print $Entry["Title"];
}

function PrintURL()
{
    global $Entry;

    print $Entry["URL"];
}

function PrintNumberItemsToDisplay()
{
    global $Entry;

    print $Entry["NumberItemsToDisplay"];
}

function PrintDisplay($onChange=0)
{
    global $Entry;

    $Enabled = $Entry['Enabled'] ? 1 : 0;

    ?><input type="checkbox" name="F_Enabled" value="1" <?PHP

    if ($onChange)
        echo "onChange=\"this.form.submit(); return true;\"";

    if ($Entry['Enabled'])
        echo " checked";
    ?>><?PHP

    return 1;
}

function PrintDisplayLocations()
{
    global $Entry;

    $DisplayOptionsArray = array(RSSDISP_ALLPAGES=>"All Pages",
                                 RSSDISP_FRONTPAGE=>"Front Page",
                                 RSSDISP_ADMINPAGE=>"Portal Administration Page",
                                 RSSDISP_MTOOLPAGE=>"Metadata Tool Page");

    //Create multiple select
    ?><select name="F_DisplayLocations[]" size="<?PHP echo sizeof($DisplayOptionsArray); ?>" multiple><?PHP
	#Remplazar: while (list($name, $value) = each($directives)) -> foreach($directives as $name => $value)
    #while (list($Key, $Val) = each($DisplayOptionsArray))
	foreach($DisplayOptionsArray as $Key => $Val)
    {
        ?><option value="<?PHP echo $Key; ?>"<?PHP

        if ($Entry['DisplayLocations'] & $Key)
            echo " selected";

        ?>><?PHP echo $Val; ?></option><?PHP
    }
}

function PrintRefreshRateOptions()
{
    global $Entry;

    $RefreshRatesArray = array( "86400" => "1 Day",
                                "43200" => "12 Hours" ,
                                "21600" => "6 Hours" ,
                                "14400" => "4 Hours" ,
                                "3600" => "1 Hour" ,
                                "1800" => "30 Minutes",
                                "900" => "15 Minutes",
                                "600" => "10 Minutes",
                                "300" => "5 Minutes",
                                "120" => "2 Minutes",
                                "60" => "1 Minute");

    //Fill in select
	#Remplazar: while (list($name, $value) = each($directives)) -> foreach($directives as $name => $value)
    #while (list($Key, $Val) = each($RefreshRatesArray))
	foreach($RefreshRatesArray as $Key => $Val)
    {
        ?><option value="<?PHP echo $Key; ?>"<?PHP

        if ($Entry['RefreshRate'] == $Key)
            echo " selected";

        ?>><?PHP echo $Val; ?></option><?PHP
    }
}

function DisplayRSSFeeds()
{
    global $Entry;

    $DB = new SPTDatabase();

    $DB->Query("SELECT * FROM RSSFeeds ORDER BY Title");

    ?><table class="DBEditorTable">
    <tr>
        <td align="center"><strong>Display</strong></td>
        <td style="padding: 0px 10px;"><strong>Title/URL</strong></td>
        <td><strong>Loc</strong></td>
        <td>&nbsp;</td>
    </tr>
    <?PHP

    $RSSFeedsArray = array();

    while ($Entry= $DB->FetchRow())
    {
        if (!$Entry['Enabled'])
            $RowClass = "class=\"FieldDisabled\"";
        else
            $RowClass = "";

        $DispStrArr = array();
        if ($Entry['DisplayLocations'] & RSSDISP_ALLPAGES)
            array_push($DispStrArr,"All");

        if ($Entry['DisplayLocations'] & RSSDISP_FRONTPAGE)
            array_push($DispStrArr,"Front");

        if ($Entry['DisplayLocations'] & RSSDISP_ADMINPAGE)
            array_push($DispStrArr,"Admin");

        if ($Entry['DisplayLocations'] & RSSDISP_MTOOLPAGE)
            array_push($DispStrArr,"MTool");

        ?>
        <form method="POST" action="SPT--EditRSSImportComplete.php">
        <input type="hidden" name="F_RSSId" value="<?PHP echo $Entry['RSSId']; ?>" />
        <tr <?PHP echo $RowClass; ?>>
            <td align="center" nowrap><?PHP PrintDisplay(1); ?></td>
            <td nowrap style="padding: 5px 10px;"><?PHP echo $Entry['Title']."<br/>".$Entry['URL']; ?></td>
            <td><?PHP echo implode(" | ",$DispStrArr); ?></td>
            <td nowrap>
                <input type="submit" name="Submit" value="Edit" />
                <input type="submit" name="Submit" value="Delete" /></td>
        </tr>
        </form>
        <?PHP
    }

    ?></table><?PHP

}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

# check if current user is authorized
CheckAuthorization(PRIV_SYSADMIN);

$DB = new SPTDatabase();

if (@!$Session->IsRegistered("RSSId"))
    @$Session->RegisterVariable("RSSId");

$RSSId = $Session->Get("RSSId");


$Query = "Select * from RSSFeeds WHERE RSSId='$RSSId'";
$DB->Query($Query);

# only one entry
$Entry = $DB->FetchNextRowArray();

include("include/SPT--StandardHtmlPageLoad.php");

?>
