<?php
#
#   FILE:  SPT--DBAddFieldComplete.php
#
#   FUNCTIONS PROVIDED:
#
#   FUNCTIONS EXPECTED:
#       None
#
#   Part of the Scout Portal Toolkit
#   Copyright 2001 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--CommonSearch.php");
require_once("include/SPT--MetadataSchema.php");
require_once("include/SPT--Classification.php");
require_once("include/SPT--ControlledName.php");
require_once("include/SPT--ClassificationFactory.php");
require_once("include/SPT--ControlledNameFactory.php");

#PageTitle("Add Database Field Complete");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------


# ----- LOCAL FUNCTIONS ------------------------------------------------------

# populate the tree field with data from specified file
function PopulateTree($Field, $FileName)
{
    $DB = new SPTDatabase();

    if (!file_exists($FileName))
        return FALSE;

    $FP = fopen($FileName, 'r');

    while (!feof($FP))
    {
        $ClassificationName = fgets($FP, 16384);

        # last line read, exit
        if (empty($ClassificationName))
            break;
            
        $NewClass = new Classification(NULL, $ClassificationName,
                            $Field->Id());
    }
    return TRUE;
}

# save form field data to the field object
function SaveFormData()
{
    global $Session, $Field;
    global $F_FieldType, $F_FieldName, $F_Enabled, $F_Optional, $F_Viewable;  
    global $F_DefaultValue,$F_UsesQualifiers, $F_HasItemLevelQualifiers;  
    global $F_DefaultQualifier, $F_IncludeInKeywordSearch;  
    global $F_IncludeInAdvancedSearch, $F_SearchWeight, $F_TextFieldSize;  
    global $F_MaxLength, $F_MinValue, $F_MaxValue, $F_DateFormat;
    global $F_ParagraphRows, $F_ParagraphCols, $F_FlagOnLabel, $F_FlagOffLabel;     global $F_AllowMultiple, $F_Description, $F_DefaultAltText, $F_MaxHeight;  
    global $F_MaxWidth, $F_MaxPreviewHeight, $F_MaxPreviewWidth;  
    global $F_MaxThumbnailHeight, $F_MaxThumbnailWidth;  
    global $F_UseForOaiSets;

    # set the attributes
    $Field->Name($F_FieldName);
    $Field->Enabled($F_Enabled);
    $Field->Optional($F_Optional);
    $Field->Viewable($F_Viewable);
    $Field->UsesQualifiers($F_UsesQualifiers);
    $Field->HasItemLevelQualifiers($F_HasItemLevelQualifiers);
    if ($F_DefaultQualifier == "--")
        $F_DefaultQualifier = NULL;
    $Field->DefaultQualifier($F_DefaultQualifier);
    $Field->DefaultValue($F_DefaultValue);
    $Field->IncludeInKeywordSearch($F_IncludeInKeywordSearch);
    $Field->IncludeInAdvancedSearch($F_IncludeInAdvancedSearch);
    $Field->UseForOaiSets($F_UseForOaiSets);

    if (!empty($F_Description)) $Field->Description($F_Description);
    if (!empty($F_DateFormat)) $Field->DateFormat($F_DateFormat);
    if (!empty($F_FlagOnLabel)) $Field->FlagOnLabel($F_FlagOnLabel);
    if (!empty($F_FlagOffLabel)) 
        $Field->FlagOffLabel($F_FlagOffLabel);
    if (!empty($F_DefaultAltText)) 
        $Field->DefaultAltText($F_DefaultAltText);
    
    if (is_numeric($F_SearchWeight))
    {
        # force search weight between 1 and 20
        if ($F_SearchWeight < 1) $F_SearchWeight = 1;
        if ($F_SearchWeight > 20) $F_SearchWeight = 20;
        $Field->SearchWeight($F_SearchWeight);
    }
    if (is_numeric($F_TextFieldSize)) $Field->TextFieldSize($F_TextFieldSize);
    if (is_numeric($F_MaxLength)) $Field->MaxLength($F_MaxLength);
    if (is_numeric($F_MinValue)) $Field->MinValue($F_MinValue);
    if (is_numeric($F_MaxValue)) $Field->MaxValue($F_MaxValue);
    if (is_numeric($F_ParagraphRows)) $Field->ParagraphRows($F_ParagraphRows);
    if (is_numeric($F_ParagraphCols)) $Field->ParagraphCols($F_ParagraphCols);
    if (is_numeric($F_AllowMultiple)) $Field->AllowMultiple($F_AllowMultiple);
    if (is_numeric($F_MaxHeight)) $Field->MaxHeight($F_MaxHeight);
    if (is_numeric($F_MaxWidth)) $Field->MaxWidth($F_MaxWidth);
    if (is_numeric($F_MaxPreviewHeight)) 
        $Field->MaxPreviewHeight($F_MaxPreviewHeight);
    if (is_numeric($F_MaxPreviewWidth)) 
        $Field->MaxPreviewWidth($F_MaxPreviewWidth);
    if (is_numeric($F_MaxThumbnailHeight))
        $Field->MaxThumbnailHeight($F_MaxThumbnailHeight);
    if (is_numeric($F_MaxThumbnailWidth)) 
        $Field->MaxThumbnailWidth($F_MaxThumbnailWidth);

    # save privilege settings
    if (isset($_POST["F_ViewPriv"]))
            {  $Field->ViewingPrivilege($_POST["F_ViewPriv"]);  }
    if (isset($_POST["F_AuthorPriv"]))
            {  $Field->AuthoringPrivilege($_POST["F_AuthorPriv"]);  }
    if (isset($_POST["F_EditPriv"]))
            {  $Field->EditingPrivilege($_POST["F_EditPriv"]);  }
}

# add new field
function AddNewField()
{
    global $ErrorMessage;
    global $F_FieldId;
    global $Session, $Field;
    global $F_FieldType, $F_FieldName, $F_Enabled, $F_Optional, $F_Viewable;  
    global $F_DefaultValue,$F_UsesQualifiers, $F_HasItemLevelQualifiers;  
    global $F_DefaultQualifier, $F_IncludeInKeywordSearch;  
    global $F_IncludeInAdvancedSearch, $F_SearchWeight, $F_TextFieldSize;  
    global $F_MaxLength, $F_MinValue, $F_MaxValue, $F_DateFormat;
    global $F_ParagraphRows, $F_ParagraphCols, $F_FlagOnLabel, $F_FlagOffLabel;     global $F_AllowMultiple, $F_Description, $F_DefaultAltText, $F_MaxHeight;  
    global $F_MaxWidth, $F_MaxPreviewHeight, $F_MaxPreviewWidth;  
    global $F_MaxThumbnailHeight, $F_MaxThumbnailWidth;  
    global $F_UseForOaiSets;

#   echo "FieldType=$F_FieldType, FieldName=$F_FieldName<br>";

    # test for required fields
    CheckRequiredFields();

    # check for NULL which indicates error or duplicate name
    if (is_null($Field))
    {
        $ErrorMessage = "ERROR: Unable to add field, duplicate field name.";
        SetErrorMessage();
    }

    # set the attributes
    $Field->Name($F_FieldName);
    if ($Field->Status() != MDFSTAT_OK)
    {
        if ($Field->Status() == MDFSTAT_DUPLICATENAME)
        {
            $ErrorMessage = "ERROR: Duplicate field name.";
            SetErrorMessage();
        }
        else if ($Field->Status() == MDFSTAT_ILLEGALNAME)
        {
            $ErrorMessage = "ERROR: Illegal field name.";
            SetErrorMessage();
        }
    }
    $Field->Enabled($F_Enabled);
    $Field->Optional($F_Optional);
    $Field->Viewable($F_Viewable);
    $Field->UsesQualifiers($F_UsesQualifiers);
    $Field->HasItemLevelQualifiers($F_HasItemLevelQualifiers);
    if ($F_DefaultQualifier == "--")
        $F_DefaultQualifier = NULL;
    $Field->DefaultQualifier($F_DefaultQualifier);
    $Field->IncludeInKeywordSearch($F_IncludeInKeywordSearch);
    $Field->IncludeInAdvancedSearch($F_IncludeInAdvancedSearch);
    $Field->UseForOaiSets($F_UseForOaiSets);

    if (!empty($F_Description)) $Field->Description($F_Description);
    if (!empty($F_DateFormat)) $Field->DateFormat($F_DateFormat);
    if (!empty($F_FlagOnLabel)) $Field->FlagOnLabel($F_FlagOnLabel);
    if (!empty($F_FlagOffLabel)) 
        $Field->FlagOffLabel($F_FlagOffLabel);
    if (!empty($F_DefaultAltText)) 
        $Field->DefaultAltText($F_DefaultAltText);
    
    if (is_numeric($F_SearchWeight))
    {
        # force search weight between 1 and 20
        if ($F_SearchWeight < 1) $F_SearchWeight = 1;
        if ($F_SearchWeight > 20) $F_SearchWeight = 20;
        $Field->SearchWeight($F_SearchWeight);
    }
    if (is_numeric($F_TextFieldSize)) $Field->TextFieldSize($F_TextFieldSize);
    if (is_numeric($F_MaxLength)) $Field->MaxLength($F_MaxLength);
    if (is_numeric($F_MinValue)) $Field->MinValue($F_MinValue);
    if (is_numeric($F_MaxValue)) $Field->MaxValue($F_MaxValue);
    if (is_numeric($F_ParagraphRows)) $Field->ParagraphRows($F_ParagraphRows);
    if (is_numeric($F_ParagraphCols)) $Field->ParagraphCols($F_ParagraphCols);
    if (is_numeric($F_AllowMultiple)) $Field->AllowMultiple($F_AllowMultiple);
    if (is_numeric($F_MaxHeight)) $Field->MaxHeight($F_MaxHeight);
    if (is_numeric($F_MaxWidth)) $Field->MaxWidth($F_MaxWidth);
    if (is_numeric($F_MaxPreviewHeight)) 
        $Field->MaxPreviewHeight($F_MaxPreviewHeight);
    if (is_numeric($F_MaxPreviewWidth)) 
        $Field->MaxPreviewWidth($F_MaxPreviewWidth);
    if (is_numeric($F_MaxThumbnailHeight))
        $Field->MaxThumbnailHeight($F_MaxThumbnailHeight);
    if (is_numeric($F_MaxThumbnailWidth)) 
        $Field->MaxThumbnailWidth($F_MaxThumbnailWidth);

    # all new fields are by default NOT required by SPT
    $Field->RequiredBySPT("0");
    
    # now set the type
    $Field->Type($F_FieldType);

    # convert the field from temp to real
    $Field->IsTempItem(FALSE);
    $F_FieldId = $Field->Id();
}

# update an existing field
function UpdateField()
{
    global $Session, $ErrorMessage, $Field, $ErrorMessage;
    global $F_FieldType, $F_FieldName, $F_Enabled, $F_Optional, $F_Viewable;  
    global $F_DefaultValue,$F_UsesQualifiers, $F_HasItemLevelQualifiers;  
    global $F_DefaultQualifier, $F_IncludeInKeywordSearch;  
    global $F_IncludeInAdvancedSearch, $F_SearchWeight, $F_TextFieldSize;  
    global $F_MaxLength, $F_MinValue, $F_MaxValue, $F_DateFormat;
    global $F_ParagraphRows, $F_ParagraphCols, $F_FlagOnLabel, $F_FlagOffLabel;     global $F_AllowMultiple, $F_Description, $F_DefaultAltText, $F_MaxHeight;  
    global $F_MaxWidth, $F_MaxPreviewHeight, $F_MaxPreviewWidth;  
    global $F_MaxThumbnailHeight, $F_MaxThumbnailWidth;  
    global $F_UseForOaiSets;

#    echo "FieldType=$F_FieldType, FieldName=$F_FieldName<br>";

    # test for required fields
    CheckRequiredFields();

    # check for valid name
    $Field->Name($F_FieldName);
    if ($Field->Status() != MDFSTAT_OK)
    {
        if ($Field->Status() == MDFSTAT_DUPLICATENAME)
        {
            $ErrorMessage = "ERROR: Duplicate field name.";
            SetErrorMessage();
        }
        else if ($Field->Status() == MDFSTAT_ILLEGALNAME)
        {
            $ErrorMessage = "ERROR: Illegal field name.";
            SetErrorMessage();
        }
    }

    # percolate DefaultQualifier for tree fields
    if ($F_FieldType == MDFTYPE_TREE)
    {
        SetQualifierIdForClassifications();
    }

    # set DefaultQualifier for Controlled Name fields
    if ($F_FieldType == MDFTYPE_CONTROLLEDNAME)
    {
        SetQualifierIdForControlledNames();
    }
    
    # set the attributes
    $Field->Enabled($F_Enabled);
    $Field->Optional($F_Optional);
    $Field->Viewable($F_Viewable);
    $Field->UsesQualifiers($F_UsesQualifiers);
    $Field->HasItemLevelQualifiers($F_HasItemLevelQualifiers);
    if ($F_DefaultQualifier == "--")
        $F_DefaultQualifier = NULL;
    $Field->DefaultQualifier($F_DefaultQualifier);
    $Field->IncludeInKeywordSearch($F_IncludeInKeywordSearch);
    $Field->IncludeInAdvancedSearch($F_IncludeInAdvancedSearch);
    $Field->UseForOaiSets($F_UseForOaiSets);
    $Field->Type($F_FieldType);

    $Field->Description($F_Description);
    $Field->DefaultValue($F_DefaultValue);
    $Field->DateFormat($F_DateFormat);
    $Field->FlagOnLabel($F_FlagOnLabel);
    $Field->FlagOffLabel($F_FlagOffLabel);
    $Field->DefaultAltText($F_DefaultAltText);

    if (is_numeric($F_SearchWeight))
    {
        # force search weight between 1 and 20
        if ($F_SearchWeight < 1) $F_SearchWeight = 1;
        if ($F_SearchWeight > 20) $F_SearchWeight = 20;
        $Field->SearchWeight($F_SearchWeight);
    }

    if (is_numeric($F_TextFieldSize)) $Field->TextFieldSize($F_TextFieldSize);
    if (is_numeric($F_MaxLength)) $Field->MaxLength($F_MaxLength);
    if (is_numeric($F_MinValue)) $Field->MinValue($F_MinValue);
    if (is_numeric($F_MaxValue)) $Field->MaxValue($F_MaxValue);
    if (is_numeric($F_ParagraphRows)) $Field->ParagraphRows($F_ParagraphRows);
    if (is_numeric($F_ParagraphCols)) $Field->ParagraphCols($F_ParagraphCols);
    if (is_numeric($F_AllowMultiple)) $Field->AllowMultiple($F_AllowMultiple);
    if (is_numeric($F_MaxHeight)) $Field->MaxHeight($F_MaxHeight);
    if (is_numeric($F_MaxWidth)) $Field->MaxWidth($F_MaxWidth);
    if (is_numeric($F_MaxPreviewHeight))
        $Field->MaxPreviewHeight($F_MaxPreviewHeight);
    if (is_numeric($F_MaxPreviewWidth))
        $Field->MaxPreviewWidth($F_MaxPreviewWidth);
    if (is_numeric($F_MaxThumbnailHeight))
        $Field->MaxThumbnailHeight($F_MaxThumbnailHeight);
    if (is_numeric($F_MaxThumbnailWidth))
        $Field->MaxThumbnailWidth($F_MaxThumbnailWidth);
}

# delete a field
function DeleteField()
{
    global $F_FieldId, $Schema, $SysConfig;

    # must re-assign browsing field id if that's what is being deleted
    if ($SysConfig->BrowsingFieldId() == $F_FieldId)
    {
        $Fields = $Schema->GetFields(MDFTYPE_TREE);
        foreach ($Fields as $Field)
        {
            if ($Field->Id() != $F_FieldId)
            {
                $SysConfig->BrowsingFieldId($Field->Id());
                break;
            }
        }
    }
    
    # drop the field
    $Field = $Schema->DropField($F_FieldId);

    # remove from OAIFieldMappings too
    $DB = new SPTDatabase();
    $DB->Query("Delete from OAIFieldMappings where SPTFieldId=".$F_FieldId);
}

# function to set DefaultQualifier at all levels in a tree
# if not already set to some other value
function SetQualifierIdForClassifications()
{
    global $Field;

    $F_UsesQualifiers = $_POST["F_UsesQualifiers"];
    $F_HasItemLevelQualifiers = $_POST["F_HasItemLevelQualifiers"];
    $F_DefaultQualifier = $_POST["F_DefaultQualifier"];

    if ($F_UsesQualifiers && $F_DefaultQualifier)
    {
        $ClassFactory = new ClassificationFactory();
        $ClassIds = $ClassFactory->GetItemIds("FieldId = ".$Field->Id());
        foreach ($ClassIds as $Id)
        {
            $Class = new Classification($Id);
            $OldQualifierId = $Class->QualifierId();
            $Qualifier = new Qualifier($OldQualifierId);

            # check if qualifier already assigned and is legit
            if (is_null($OldQualifierId) || $OldQualifierId == 0 ||
                is_null($Qualifier->Name()))
            {
                    $Class->QualifierId($F_DefaultQualifier);
            }
        }
    }
}

# function to set DefaultQualifier for a ControlledName field
# if not already set to some other value
function SetQualifierIdForControlledNames()
{
    global $Field;

    $F_UsesQualifiers = $_POST["F_UsesQualifiers"];
    $F_HasItemLevelQualifiers = $_POST["F_HasItemLevelQualifiers"];
    $F_DefaultQualifier = $_POST["F_DefaultQualifier"];

    if ($F_UsesQualifiers && $F_DefaultQualifier)
    {
        $CNFactory = new ControlledNameFactory();
        $CNFactory->GetItemIds("FieldId = ".$Field->Id());
        foreach ($CNIds as $Id)
        {
            $CN = new ControlledName($Id);

            $OldQualifierId = $CN->QualifierId();
            $Qualifier = new Qualifier($OldQualifierId);

            # check if qualifier already assigned and is legit
            if (is_null($OldQualifierId) || $OldQualifierId == 0 ||
                is_null($Qualifier->Name()))
            {
                    $CN->QualifierId($F_DefaultQualifier);
            }
        }
    }
}

function CheckRequiredFields()
{
    global $ErrorMessage;
    global $Session, $Field;
    global $F_FieldType, $F_FieldName, $F_Enabled, $F_Optional, $F_Viewable;  
    global $F_DefaultValue,$F_UsesQualifiers, $F_HasItemLevelQualifiers;  
    global $F_DefaultQualifier, $F_IncludeInKeywordSearch;  
    global $F_IncludeInAdvancedSearch, $F_SearchWeight, $F_TextFieldSize;  
    global $F_MaxLength, $F_MinValue, $F_MaxValue, $F_DateFormat;
    global $F_ParagraphRows, $F_ParagraphCols, $F_FlagOnLabel, $F_FlagOffLabel;     global $F_AllowMultiple, $F_Description, $F_DefaultAltText, $F_MaxHeight;  
    global $F_MaxWidth, $F_MaxPreviewHeight, $F_MaxPreviewWidth;  
    global $F_MaxThumbnailHeight, $F_MaxThumbnailWidth;  

    if (empty($F_FieldName))
    {
        $ErrorMessage = "ERROR: Missing required FieldName Field.";
        SetErrorMessage();
    }
    if (empty($F_Description))
    {
        $ErrorMessage = "ERROR: Missing required Description Field.";
        SetErrorMessage();
    }

    switch($F_FieldType)
    {
        case MDFTYPE_TEXT:
            if (empty($F_TextFieldSize))
            {
                $ErrorMessage = "ERROR: Missing required TextFieldSize Field.";
                SetErrorMessage();
            }
            if (empty($F_MaxLength))
            {
                $ErrorMessage = "ERROR: Missing required MaxLength Field.";
                SetErrorMessage();
            }
            break;

        case MDFTYPE_PARAGRAPH:
            if (empty($F_ParagraphRows))
            {
                $ErrorMessage = "ERROR: Missing required ParagraphRows Field.";
                SetErrorMessage();
            }
            if (empty($F_ParagraphCols))
            {
                $ErrorMessage = "ERROR: Missing required ParagraphCols Field.";
                SetErrorMessage();
            }
            break;
            
        case MDFTYPE_FLAG:
            if (empty($F_FlagOnLabel))
            {
                $ErrorMessage = "ERROR: Missing required FlagOnLabel Field.";
                SetErrorMessage();
            }
            if (empty($F_FlagOffLabel))
            {
                $ErrorMessage = "ERROR: Missing required FlagOffLabel Field.";
                SetErrorMessage();
            }
            break;
            
        case MDFTYPE_IMAGE:
            if (empty($F_DefaultAltText))
            {
                $ErrorMessage = "ERROR: Missing required DefaultAltText Field.";
                SetErrorMessage();
            }
            break;
    }
}

function SetErrorMessage()
{
    global $Session, $ErrorMessage, $Field, $ErrorMessage;
    global $F_FieldType, $F_FieldName, $F_Enabled, $F_Optional, $F_Viewable;  
    global $F_DefaultValue,$F_UsesQualifiers, $F_HasItemLevelQualifiers;  
    global $F_DefaultQualifier, $F_IncludeInKeywordSearch;  
    global $F_IncludeInAdvancedSearch, $F_SearchWeight, $F_TextFieldSize;  
    global $F_MaxLength, $F_MinValue, $F_MaxValue, $F_DateFormat;
    global $F_ParagraphRows, $F_ParagraphCols, $F_FlagOnLabel, $F_FlagOffLabel;     global $F_AllowMultiple, $F_Description, $F_DefaultAltText, $F_MaxHeight;  
    global $F_MaxWidth, $F_MaxPreviewHeight, $F_MaxPreviewWidth;  
    global $F_MaxThumbnailHeight, $F_MaxThumbnailWidth;  

    $Session->PassVariable("ErrorMessage");
    $Session->PassVariable("F_FieldName");
    $Session->PassVariable("F_FieldType");
    $Session->PassVariable("F_Description");
    $Session->PassVariable("F_Enabled");
    $Session->PassVariable("F_Optional");
    $Session->PassVariable("F_Viewable");
    $Session->PassVariable("F_DefaultValue");
    $Session->PassVariable("F_UsesQualifiers");
    $Session->PassVariable("F_HasItemLevelQualifiers");
    $Session->PassVariable("F_DefaultQualifier");
    $Session->PassVariable("F_IncludeInKeywordSearch");
    $Session->PassVariable("F_IncludeInAdvancedSearch");
    $Session->PassVariable("F_SearchWeight");
    $Session->PassVariable("F_TextFieldSize");
    $Session->PassVariable("F_MaxLength");
    $Session->PassVariable("F_MinValue");
    $Session->PassVariable("F_MaxValue");
    $Session->PassVariable("F_DateFormat");
    $Session->PassVariable("F_ParagraphRows");
    $Session->PassVariable("F_ParagraphCols");
    $Session->PassVariable("F_FlagOnLabel");
    $Session->PassVariable("F_FlagOffLabel");
    $Session->PassVariable("F_AllowMultiple");
    $Session->PassVariable("F_DefaultAltText");
    $Session->PassVariable("F_MaxHeight");
    $Session->PassVariable("F_MaxWidth");
    $Session->PassVariable("F_MaxPreviewHeight");
    $Session->PassVariable("F_MaxPreviewWidth");
    $Session->PassVariable("F_MaxThumbnailHeight");
    $Session->PassVariable("F_MaxThumbnailWidth");
    $Session->PassVariable("F_UseForOaiSets");
    PrintAutoRefreshPage("Add Database Field", "SPT--DBAddField.php");
    exit;
}

# remove Qaulifier assocation for this field
function RemoveQualifierAssociation()
{
    global $F_FieldId, $Schema;

    # Get the field
    $Field = $Schema->GetField($F_FieldId);

    $F_AllowedQualifiers = $_POST["F_AllowedQualifiers"];
    if (isset($F_AllowedQualifiers) && $F_AllowedQualifiers != "--")
        $Field->UnassociateWithQualifier($F_AllowedQualifiers);   
}

# add Qualifier assocation for this field
function AddQualifierAssociation()
{ 
    global $F_FieldId, $Schema;

    # Get the field
    $Field = $Schema->GetField($F_FieldId);
    
    $F_AvailableQualifiers = $_POST["F_AvailableQualifiers"];
    if (isset($F_AvailableQualifiers) && $F_AvailableQualifiers != "--")
        $Field->AssociateWithQualifier($F_AvailableQualifiers);   

}

# ----- MAIN -----------------------------------------------------------------

CheckAuthorization(PRIV_SYSADMIN, PRIV_COLLECTIONADMIN);

$Schema = new MetadataSchema();
$F_FieldId = $Schema->GetCurrentEditedItemId();

# get the field 
{
    $Field = $Schema->GetField($F_FieldId);

    if ($Field->RequiredBySPT())
    {
        $F_FieldName = $Session->Get("F_FieldName");
        $F_Enabled = $Session->Get("F_Enabled");
        $F_Optional = $Session->Get("F_Optional");
    }
    else
    {
        if (isset($_POST["F_FieldName"]))
            $F_FieldName = $_POST["F_FieldName"];
        if (isset($_POST["F_Enabled"]))
            $F_Enabled = $_POST["F_Enabled"];
        if (isset($_POST["F_Optional"]))    
            $F_Optional = $_POST["F_Optional"];
    }
    
    $F_Viewable = NULL; 
    $F_DefaultValue = NULL; 
    $F_UsesQualifiers = NULL; 
    $F_HasItemLevelQualifiers = NULL; 
    $F_DefaultQualifier = NULL; 
    $F_IncludeInKeywordSearch = NULL; 
    $F_IncludeInAdvancedSearch = NULL; 
    $F_SearchWeight = NULL; 
    $F_TextFieldSize = NULL; 
    $F_MaxLength = NULL; 
    $F_MinValue = NULL; 
    $F_MaxValue = NULL; 
    $F_DateFormat = NULL; 
    $F_ParagraphRows = NULL; 
    $F_ParagraphCols = NULL; 
    $F_FlagOnLabel = NULL; 
    $F_FlagOffLabel = NULL; 
    $F_AllowMultiple = NULL; 
    $F_Description = NULL; 
    $F_DefaultAltText = NULL; 
    $F_MaxHeight = NULL; 
    $F_MaxWidth = NULL; 
    $F_MaxPreviewHeight = NULL; 
    $F_MaxPreviewWidth = NULL; 
    $F_MaxThumbnailHeight = NULL; 
    $F_MaxThumbnailWidth = NULL; 
    $F_UseForOaiSets = NULL; 
    
    if (isset($_POST["F_Viewable"]))
        $F_Viewable = $_POST["F_Viewable"];
    if (isset($_POST["F_DefaultValue"]))
        $F_DefaultValue = $_POST["F_DefaultValue"];
    if (isset($_POST["F_UsesQualifiers"]))
        $F_UsesQualifiers = $_POST["F_UsesQualifiers"];
    if (isset($_POST["F_HasItemLevelQualifiers"]))
        $F_HasItemLevelQualifiers = $_POST["F_HasItemLevelQualifiers"];
    if (isset($_POST["F_DefaultQualifier"]))
        $F_DefaultQualifier = $_POST["F_DefaultQualifier"];
    if (isset($_POST["F_IncludeInKeywordSearch"]))
        $F_IncludeInKeywordSearch = $_POST["F_IncludeInKeywordSearch"];
    if (isset($_POST["F_IncludeInAdvancedSearch"]))
        $F_IncludeInAdvancedSearch = $_POST["F_IncludeInAdvancedSearch"];
    if (isset($_POST["F_SearchWeight"]))
        $F_SearchWeight = $_POST["F_SearchWeight"];
    if (isset($_POST["F_TextFieldSize"]))
        $F_TextFieldSize = $_POST["F_TextFieldSize"];
    if (isset($_POST["F_MaxLength"]))
        $F_MaxLength = $_POST["F_MaxLength"];
    if (isset($_POST["F_MinValue"]))
        $F_MinValue = $_POST["F_MinValue"];
    if (isset($_POST["F_MaxValue"]))
        $F_MaxValue = $_POST["F_MaxValue"];
    if (isset($_POST["F_DateFormat"]))
        $F_DateFormat = $_POST["F_DateFormat"];
    if (isset($_POST["F_ParagraphRows"]))
        $F_ParagraphRows = $_POST["F_ParagraphRows"];
    if (isset($_POST["F_ParagraphCols"]))
        $F_ParagraphCols = $_POST["F_ParagraphCols"];
    if (isset($_POST["F_FlagOnLabel"]))
        $F_FlagOnLabel = $_POST["F_FlagOnLabel"];
    if (isset($_POST["F_FlagOffLabel"]))
        $F_FlagOffLabel = $_POST["F_FlagOffLabel"];
    if (isset($_POST["F_AllowMultiple"]))
        $F_AllowMultiple = $_POST["F_AllowMultiple"];
    if (isset($_POST["F_Description"]))
        $F_Description = $_POST["F_Description"];
    if (isset($_POST["F_DefaultAltText"]))
        $F_DefaultAltText = $_POST["F_DefaultAltText"];
    if (isset($_POST["F_MaxHeight"]))
        $F_MaxHeight = $_POST["F_MaxHeight"];
    if (isset($_POST["F_MaxWidth"]))
        $F_MaxWidth = $_POST["F_MaxWidth"];
    if (isset($_POST["F_MaxPreviewHeight"]))
        $F_MaxPreviewHeight = $_POST["F_MaxPreviewHeight"];
    if (isset($_POST["F_MaxPreviewWidth"]))
        $F_MaxPreviewWidth = $_POST["F_MaxPreviewWidth"];
    if (isset($_POST["F_MaxThumbnailHeight"]))
        $F_MaxThumbnailHeight = $_POST["F_MaxThumbnailHeight"];
    if (isset($_POST["F_MaxThumbnailWidth"]))
        $F_MaxThumbnailWidth = $_POST["F_MaxThumbnailWidth"];
    if (isset($_POST["F_UseForOaiSets"]))
        $F_UseForOaiSets = $_POST["F_UseForOaiSets"];
}

if ($_POST["Submit"] == "Add New Field")
{
    SaveFormData();
    AddNewField();
    $Session->PassVariable("F_FieldName");
    PrintAutoRefreshPage("Database Add Field Confirmation", 
        "SPT--DBConfirmAddField.php");
    $Schema->ClearCurrentEditedItemId();
    exit;
}
else if ($_POST["Submit"] == "Update Field")
{
    SaveFormData();
    UpdateField();
    PrintAutoRefreshPage("Database Edit Field", "SPT--DBEditor.php");
    $Schema->ClearCurrentEditedItemId();
    exit;
}
else if ($_POST["Submit"] == "Populate Field")
{
    SaveFormData();
    PrintAutoRefreshPage("Populate Metadata Field", 
            "SPT--PopulateField.php?ID=".$Field->Id());
    exit;
}
else if ($_POST["Submit"] == "Add Another Field")
{
    PrintAutoRefreshPage("Add Database Field", "SPT--DBAddField.php");
    $Schema->ClearCurrentEditedItemId();
    exit;    
}
else if ($_POST["Submit"] == "Edit Fields")
{
    PrintAutoRefreshPage("Database Edit Field", "SPT--DBEditor.php");
    $Schema->ClearCurrentEditedItemId();
    exit;
}
else if (substr($_POST["Submit"], 0, 6) == "Delete")
{
    if (isset($_POST["OkayToDelete"]))
    {
        DeleteField();
        PrintAutoRefreshPage("Database Edit Field", "SPT--DBEditor.php");
        $Schema->ClearCurrentEditedItemId();
        exit;
    }
    else
    {
        $Session->PassVariable("F_FieldName");
        PrintAutoRefreshPage("Confirm Delete Database Field", 
            "SPT--DBConfirmDeleteField.php");
        exit;
    }
}
else if ($_POST["Submit"] == "Cancel")
{
    # delete temporary field and clear current edit id
    if (isset($F_FieldId))
    {
        $Field = $Schema->GetField($F_FieldId);
        if ($Field->IsTempItem())
            DeleteField();
    }
    $Schema->ClearCurrentEditedItemId();
    PrintAutoRefreshPage("Database Edit Field", "SPT--DBEditor.php");
    exit;
}
else if ($_POST["Submit"] == "Remove ==>")
{
    SaveFormData();
    RemoveQualifierAssociation();
}
else if ($_POST["Submit"] == "<== Add")
{
    SaveFormData();
    AddQualifierAssociation();
}
else if ($_POST["Submit"] == "Populate")
{
    $F_PopulateTree = $_POST["F_PopulateTree"];
    if (!empty($F_PopulateTree))
    {
        $Field = $Schema->GetField($F_FieldId);
        if ($Field->Type() == MDFTYPE_TREE)
        {
            $Status = PopulateTree($Field, $F_PopulateTree);
            if ($Status == FALSE)
            {
                $ErrorMessage = "WARNING: Cannot populate tree.".
                "\"$F_PopulateTree\" not found";
            }
            else
            {
                $ErrorMessage = 
                    "Field populated successfully.";
            }
        }
    }
    else
    {
        $ErrorMessage = "You must select a taxonomy.";
    }
    $Session->PassVariable("ErrorMessage", $ErrorMessage);
    PrintAutoRefreshPage("Populate Tree Field", "SPT--DBPopulateTree.php");
    exit;
}
else if (isset($_POST["Submit"]))
{
    SaveFormData();
    $F_FieldType = $_POST["Submit"];
}
$Session->PassVariable("F_FieldType");
PrintAutoRefreshPage("Database Add Field", "SPT--DBAddField.php");

?>
