<?php
#
#   FILE:  SPT--ConfirmDeleteControlledName.php
#
#   FUNCTIONS PROVIDED:
#
#   FUNCTIONS EXPECTED:
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("../include/SPT--Common.php");
require_once("../include/SPT--ControlledName.php");

# print list of controlled names
function PrintControlledNames()
{
    global $Session, $Name, $InUseCount;

    $CNArray = $Session->Get("CNArray");
    $Session->PassVariable("CNArray", $CNArray);

    foreach ($CNArray as $CNId)
    {
        $CN = new ControlledName($CNId);
        $Name = $CN->Name();   
        $InUseCount = $CN->InUse();
        PrintControlledName();
    }
}

# print actual value
function PrintControlledNameInfo()
{
    global $Name, $InUseCount;

    if ($InUseCount > 0)
        print $Name." (This value in use by $InUseCount Resources)";    
    else
        print $Name." (This value is not currently in use)";
}

# print action value
function PrintAction()
{
    global $Action;

    print $Action;
}

# print target value
function PrintTarget()
{
    global $Target;

    print $Target;
}

CheckAuthorization(PRIV_RESOURCEADMIN, PRIV_NAMEADMIN);

$Action = $_GET["action"];
$Target = $_GET["target"];

# pass FieldName through
$Session->PassVariable("FieldName", $Session->Get("FieldName"));

PageTitle("Confirm Delete $Action");
$NavDirCorrection = "../";
include("../include/SPT--StandardHtmlPageLoad.php");

?>
