<?php
#
#   FILE:  SPT--ConfirmDeleteClassification.php
#
#   FUNCTIONS PROVIDED:
#
#   FUNCTIONS EXPECTED:
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("../include/SPT--Common.php");
require_once("../include/SPT--Classification.php");

# print list of controlled names
function PrintClassification()
{
    global $Session, $Name, $InUseCount;

    $ClassId = $Session->Get("ClassId");
    $Session->PassVariable("ClassId", $ClassId);

    $Class = new Classification($ClassId);
    $Name = $Class->FullName();

    $InUseCount = $Class->ResourceCount();
    DisplayClassification();
}

# print actual value
function PrintClassificationInfo()
{
    global $Name, $InUseCount;

    if ($InUseCount > 0)
        print $Name." (This value in use by $InUseCount Resources)";    
    else
        print $Name." (This value is not currently in use)";
}

# print list of children below this classification
function PrintChildrenClasses()
{
    global $Session;
    
    $ClassId = $Session->Get("ClassId");
    $Class = new Classification($ClassId);
    $ChildList = $Class->ChildList();
    foreach ($ChildList as $ChildId)
    {
        $ChildClass = new Classification($ChildId);
        print $ChildClass->FullName()."<br>";
    }
}

# determine if this classification has childern
function ClassHasChildren()
{
    global $Session;
    
    $ClassId = $Session->Get("ClassId");
    $Class = new Classification($ClassId);
    return $Class->ChildCount();
}

# print action value
function PrintAction()
{
    global $Action;

    print $Action;
}

# print target value
function PrintTarget()
{
    global $Target;

    print $Target;
}

CheckAuthorization(PRIV_RESOURCEADMIN, PRIV_NAMEADMIN);

$Action = $_GET["action"];
$Target = $_GET["target"];

# pass FieldName through
$Session->PassVariable("FieldName", $Session->Get("FieldName"));

PageTitle("Confirm Delete $Action");

$NavDirCorrection = "../";

include("../include/SPT--StandardHtmlPageLoad.php");

?>
