<?php
#
#   FILE:  SPT--AssignControlledName.php
#
#   FUNCTIONS PROVIDED:
#       DisplayAddedControlledNames()
#           - displays newly added ControlledNames, updates intersection
#             tables, and updates DateLastModified for affectd Resources 
#
#   FUNCTIONS EXPECTED:
#       None
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--CommonSearch.php");
require_once("include/SPT--ResourceFactory.php");
require_once("include/SPT--ControlledName.php");
require_once("include/SPT--Resource.php");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# process selected controlled names
function ProcessSelectedControlledNames()
{
    global $ResourceId;

    $Schema = new MetadataSchema();

    reset($_POST);
	#Remplazar: while (list($name, $value) = each($directives)) -> foreach($directives as $name => $value)
    #while (list($Var, $Value) = each ($_POST))
	foreach($_POST as $Var => $Value)
    {
        if (preg_match("/cn_([0-9]+)/", $Var, $Regs) )
        {
            $Value = trim($Value);
            if ($Value != "")
            {
                $ControlledName = $Value;
                continue;
            }
        }
        if (preg_match("/cnid_([0-9]+)/", $Var, $Regs) )
        {
            $Value = trim($Value);
            if ($Value != "")
            {
                $ControlledNameId = $Value;
                $CN = new ControlledName($ControlledNameId);
                $Field = $Schema->GetField($CN->FieldId());
                $Resource = new Resource($ResourceId);
                $Resource->Set($Field->Name(), $ControlledNameId);
            }
        }
    }
}

# ----- MAIN -----------------------------------------------------------------

CheckAuthorization(PRIV_RESOURCEADMIN, PRIV_MYRESOURCEADMIN);

# get currently edited resource
$RFactory = new ResourceFactory();
$ResourceId = $RFactory->GetCurrentEditedItemId();

ProcessSelectedControlledNames();

# return to the DB Entry page
$Link = "SPT--DBEntry.php?ResourceId=".$ResourceId;
PrintAutoRefreshPage("Add New Record", $Link);
?>
