<?PHP
#
#   FILE:  NewUser.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2011-2015 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

CheckAuthorization(PRIV_USERADMIN, PRIV_SYSADMIN);

# ----- MAIN -----------------------------------------------------------------

PageTitle("New User Sign-Up");


$MailerPlugin = $GLOBALS["G_PluginManager"]->GetPlugin("Mailer");
$TemplateList[-1] = "--";
$TemplateList = $TemplateList + $MailerPlugin->GetTemplateList();

# excluded fields
$ExcludedFields = array("Password", "PasswordAgain");

# additional FormUI fields
$AdditionalFields = array(
    "UserNotification" => array(
        "Type" => "Heading",
        "Label" => "User Notification (Optional)",
        ),
    "TemplateId" => array(
        "Type" => "Option",
        "Label" => "Mailer template to use",
        "Required" => FALSE,
        "AllowMultiple" => FALSE,
        "Options" => $TemplateList,
        ),
    );

$H_FormUI = new FormUI(UserEditingUI::GetRequestAccountForm(NULL, $ExcludedFields,
                         $AdditionalFields), array("TemplateId" => "-1"));
$H_AccountCreatedSuccessfully = FALSE;

if (isset($_POST["Submit"]) && $_POST["Submit"] == "Create Account")
{
    # generate a random initial password
    $Password = GetRandomCharacters(8);

    # put generated password into form values
    $_POST["F_Password"] = $Password;
    $_POST["F_PasswordAgain"] = $Password;

    # check incoming values for errors
    $UserFactory = new CWUserFactory();
    $UserErrorCodes = $UserFactory->TestNewUserValues(
    $_POST["F_UserName"],
        $Password, $Password,
        $_POST["F_EMail"], $_POST["F_EMailAgain"]);

    # check for and handle errors (by returning)
    if (UserEditingUI::UserFormHasErrors($H_FormUI, $UserErrorCodes))
    {
        return;
    }

    # retrieve form values for account creation
    $H_UserName = $_POST["F_UserName"];

    # create new user
    $NewUser = $UserFactory->CreateNewUser(
        $_POST["F_UserName"],
        $Password, $Password,
        $_POST["F_EMail"], $_POST["F_EMailAgain"],
        array(U_ILLEGALPASSWORD, U_ILLEGALPASSWORDAGAIN));

    # if user creation failed
    if (!is_object($NewUser) || ($NewUser->Status() != U_OKAY))
    {
        # log errors in FormUI
        foreach ($NewUser as $ErrorCode)
        {
            $H_FormUI->LogError($ErrorCode);
        }
        return;
    }

    # save provided attributes and values
    $UEUI = new UserEditingUI($NewUser);
    $UEUI->UpdateUserAttributes($_POST, TRUE);
    $UEUI->UpdateUserFields(CWUser::GetCustomUserFields());

    # set up initial UI setting
    $NewUser->Set("ActiveUI", $GLOBALS["G_SysConfig"]->DefaultActiveUI());

    # set up initial privileges
    foreach ($GLOBALS["G_SysConfig"]->DefaultUserPrivs() as $Privilege)
    {
        $NewUser->GivePriv($Privilege);
    }

    # signal that user has been added
    $GLOBALS["AF"]->SignalEvent("EVENT_USER_ADDED", array(
                         "UserId" => $NewUser->Id(), "Password" => $Password) );

    $H_UserName = $NewUser->Get("UserName");

    $Protocol = isset($_SERVER["HTTPS"]) ? "https://" : "http://";
    $H_ActivationUrl = $Protocol.$_SERVER["SERVER_NAME"]
        .dirname($_SERVER["SCRIPT_NAME"])
        ."/index.php?P=ResetPassword&UN=".urlencode($H_UserName)
        ."&RC=".urlencode($NewUser->GetResetCode());

    $TemplateId = $_POST["F_TemplateId"];
    if ($TemplateId != "-1" )
    {
        $MyResource = new Resource( $_GET["ResourceId"] );

        $Substitutions = array();
        foreach (UserEditingUI::GetActivationEmailSubstitutions($NewUser)
                 as $Key => $Val)
        {
            $Key = preg_replace("/X-([A-Z]+)-X/", "$1", $Key);
            $Substitutions[$Key] = $Val;
        }
        $Substitutions["ACTIVATIONCODE"] = $NewUser->GetActivationCode();
        $Substitutions["MANUALACTIVATIONURL"] = $H_ActivationUrl;

        $MailerPlugin->SendEmail( $TemplateId,
                                  array($NewUser->Id()),
                                  array($MyResource),
                                  $Substitutions );

        $MyPlugin = $GLOBALS["G_PluginManager"]->GetPlugin("UserCreator");
    }

    $H_AccountCreatedSuccessfully = TRUE;
}
elseif (isset($_POST["Submit"]) && $_POST["Submit"]=="Cancel")
{
    print "<script type='text/javascript'>"
        ."window.close();</script>";
}