<?PHP
#
#   FILE:  DeleteRule.php (Rules plugin)
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2016 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis
#

# if rule was not specified
$PFactory = new Rules_RuleFactory();
if (!isset($_GET["ID"]))
{
    # set error display
    $H_DisplayMode = "NoRuleSpecified";
}
# else if specified rule does not exist
elseif (!$PFactory->ItemExists($_GET["ID"]))
{
    # set error display
    $H_DisplayMode = "RuleDoesNotExist";
}
else
{
    # load rule
    $H_Rule = new Rules_Rule($_GET["ID"]);

    # make sure user has privileges to delete rule
    CheckAuthorization(PRIV_SYSADMIN, PRIV_COLLECTIONADMIN);

    # if we are processing confirmation
    if (isset($_GET["AC"]) && ($_GET["AC"] == "Confirmation"))
    {
        # if delete was confirmed
        if (isset($_POST["Submit"]) && ($_POST["Submit"] == "Delete"))
        {
            # hook function to delete rule after HTML is displayed
            $GLOBALS["AF"]->AddPostProcessingCall(function ($Id) {
                        $Rule = new Rules_Rule($Id);
                        $Rule->Delete();
            }, $_GET["ID"]);

            # inform user that rule was deleted
            $H_DisplayMode = "RuleDeleted";
        }
        # else if delete was cancelled
        elseif (isset($_POST["Submit"]) && ($_POST["Submit"] == "Cancel"))
        {
            # return to rule list
            $GLOBALS["AF"]->SetJumpToPage("P_Rules_ListRules");
        }
    }
    # else assume that confirmation is needed
    else
    {
        $H_DisplayMode = "ConfirmationNeeded";
    }
}

