<?PHP
#
#   FILE:  ListFeeds.php (RSSExport plugin)
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012 Edward Almasy and Internet Scout
#   http://scout.wisc.edu/cwis
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

/**
* Gets the action buttons for each feed to be displayed in the ListFeeds table.
* @param object $Feed The Feed object to get the actions for.
* @param bool $CanEdit Whether the user can edit RSS feeds.
* @return string The html for the action buttons of the specified feed.
*/
function GetFeedActions($Feed, $CanEdit)
{
    # get feed ID
    $Id = $Feed->Id();

    # actions are predefined
    if ($CanEdit)
    {
        $Actions = "<a class=\"cw-button cw-button-elegant\""
                . " title=\"View this RSS feed\""
                . " href=\"index.php?P=P_RSSExport_Feed&amp;ID=" . $Id ."\">View</a>" .
        "<a class=\"cw-button cw-button-elegant\""
                . " title=\"Edit the settings for this RSS feed\""
                . " href=\"index.php?P=P_RSSExport_EditFeed&amp;ID=" . $Id . "\">Edit</a>" .
        "<a class=\"cw-button cw-button-elegant\""
                . " title=\"Delete this RSS feed\""
                . " href=\"index.php?P=P_RSSExport_ConfirmDelete&amp;ID=" . $Id . "\">Delete</a>";
    }
    else
    {
        $Actions = "<a class=\"cw-button cw-button-elegant\""
            . "title=\"View this RSS feed\""
            . "href=\"index.php?P=P_RSSExport_Feed&amp;ID=" . $Id . "\">View</a>";
    }

    # return the buttons
    return $Actions;
}

/**
* Gets the feed URL to display. If there is a clean URL available, it will be used.
* @param object $Feed The feed to get the URL of.
* @return string The URL of the feed.
*/
function GetFeedUrl($Feed)
{
    # if there is no feed don't do anything
    if ($Feed == NULL) return NULL;

    # gather up variables
    global $G_PluginManager;
    $Plugin = $G_PluginManager->GetPlugin("RSSExport");
    $CleanUrlPrefix = $Plugin->ConfigSetting("CleanUrlPrefix");
    $CleanUrl = $Feed->CleanUrl();

    # check if we have a clean URL for the feed, and if we do, return it
    if (strlen($CleanUrlPrefix) && strlen($CleanUrl))
    {
        return "/" . trim($CleanUrlPrefix) . "/" . trim($CleanUrl);
    }

    # otherwise return the normal URL
    return "index.php?P=P_RSSExport_Feed&amp;ID=" . $Feed->Id();
}

# ----- MAIN -----------------------------------------------------------------

global $G_PluginManager, $G_User;

# grab a copy of the plugin
$H_Plugin = $G_PluginManager->GetPlugin("RSSExport");

# get feeds from the database
$H_Feeds = $H_Plugin->GetFeeds();

# determine if the user viewing the page can edit feeds
$H_UserCanEdit = $G_User->HasPriv( PRIV_SYSADMIN );
