<?PHP
#
#   FILE:  EditNavigation.php
#
#   Copyright 2011 Internet Scout Project
#   http://scout.wisc.edu/
#

# ----- LOCAL FUNCTIONS ------------------------------------------------------

/**
 * Get a value from the POST variables or NULL if it doesn't exist.
 * @param $Name POST variable name
 * @return the POST variable if set, otherwise NULL
 */
function GetInputValue($Name)
{
    return array_key_exists($Name, $_POST) ? $_POST[$Name] : NULL;
}

/**
 * Set a NavEditor configuration value.
 * @param $Key configuration key
 * @param $Value configuration value
 */
function SetConfigValue($Key, $Value)
{
    global $AF;

    $Parameters = array($Key, $Value);
    $AF->SignalEvent("NAVEDITOR_SET_CONFIGURATION", $Parameters);
}

# ----- MAIN -----------------------------------------------------------------

global $G_ModifyPrimaryNav;
global $G_PrimaryNav;
global $G_ModifySecondaryNav;
global $G_SecondaryNav;
global $G_Configuration;

PageTitle("Edit Navigation");
CheckAuthorization(PRIV_SYSADMIN);

$G_ModifyPrimaryNav = GetInputValue("F_ModifyPrimaryNav");
$G_PrimaryNav = GetInputValue("F_PrimaryNav");
$G_ModifySecondaryNav = GetInputValue("F_ModifySecondaryNav");
$G_SecondaryNav = GetInputValue("F_SecondaryNav");

if (count($_POST) > 0)
{
    SetConfigValue("ModifyPrimaryNav", (!is_null($G_ModifyPrimaryNav)));
    SetConfigValue("ModifySecondaryNav", (!is_null($G_ModifySecondaryNav)));
}

if (!is_null($G_PrimaryNav))
{
    SetConfigValue("PrimaryNav", $G_PrimaryNav);
}

if (!is_null($G_SecondaryNav))
{
    SetConfigValue("SecondaryNav", $G_SecondaryNav);
}

# avoid the "resend variables..." browser message
if (count($_POST) > 0)
{
    $AF->SetJumpToPage("P_NavEditor_EditNavigation");
}

# get the latest configuration values
$G_Configuration = $AF->SignalEvent("NAVEDITOR_GET_CONFIGURATION");
