<?PHP
#
#   FILE:  StoredEmail.php (Mailer plugin)
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2011-2017 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis
#

/**
* Class representing stored Email messages that are waiting for user
* confirmation prior to being sent.
*/
class Mailer_StoredEmail extends Item
{
    /**
    * Create a new StoredEmail.
    * @param Email $Email Email object to store.
    * @param array $Resources Array of Resource objects used to generate this Email.
    * @param int $TemplateId Template used to generate this Email.
    * @return Newly created StoredEmail.
    */
    public static function Create($Email, $Resources, $TemplateId)
    {
        $ResourceIds = [];
        foreach ($Resources as $Resource)
        {
            $ResourceIds[]= $Resource->Id();
        }

        $Item = static::CreateWithValues([
            "Mailer_StoredEmailName" => $Email->Subject(),
            "FromAddr" => $Email->From(),
            "ToAddr" => implode(', ', $Email->To()),
            "TemplateId" => $TemplateId,
            "NumResources" => count($Resources),
            "ResourceIds" => implode(',', $ResourceIds),
            "DateCreated" => date('Y-m-d H:i:s'),
        ]);

        $Item->SetEmail($Email);

        return $Item;
    }

    /**
    * Retrieve the Email object stored with this message.
    * @return Email object.
    */
    public function GetEmail()
    {
        if ($this->Email === NULL)
        {
            $this->Email = unserialize($this->UpdateValue("Email"));
        }
        return $this->Email;
    }

    /**
    * Send the saved Email and destroy this object.
    */
    public function Send()
    {
        $this->GetEmail()->Send();
        $this->Destroy();
    }

    /**
    * Set the Email object to be stored.
    * @param Email $Email Email to store.
    */
    private function SetEmail($Email)
    {
        $this->Email = $Email;
        # need to use DB->Query() here rather than UpdateValue so that
        # we can call EscapeString, which is proof against nulls in
        # serialized objects
        $this->DB->Query(
            'UPDATE Mailer_StoredEmails '
            .'SET Email = "'.$this->DB->EscapeString(serialize($Email)).'" '
            .'WHERE Mailer_StoredEmailId = '.$this->Id);
    }

    private $Email = NULL;
}
