#!/bin/bash

path_prepend(){
  if [ -d "$1" ] && [ "${PATH}" = "${PATH#*$1}" ] ; then
    export PATH="$1:$PATH"
  fi
}

# make sure /usr/local/bin is in $PATH
path_prepend /usr/local/bin

# display environment for debugging
/bin/env

# if we have a system-level wkhtmltoimage, use it
if (which wkhtmltoimage 2> /dev/null >/dev/null); then
    exec wkhtmltoimage --width 800 --height 600 "$1" "$2"
else
    # otherwise, look for a staticly linked one in this folder
    if [ $(uname -m) = 'x86_64' ] ; then
        exec ${0%/*}/wkhtmltoimage-amd64 --width 800 --height 600 "$1" "$2"
    else
        exec ${0%/*}/wkhtmltoimage-i386 --width 800 --height 600 "$1" "$2"
    fi
fi
