<?PHP
#
#   FILE:  TopicMessages.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

PageTitle("Topic Messages");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

/**
* Check if current user is forum moderator or system admin.
* @param Forum $Forum Forum of the topic.
* @return True if the current user is either one.
*/
function CheckForModeratorOrSysAdmin($Forum)
{
    global $G_User;

    return
        ($G_User->Get("UserId") == $Forum->ModeratorId() &&
         $G_User->HasPriv(PRIV_FORUMADMIN))
        || $G_User->HasPriv(PRIV_SYSADMIN) ;
}


/**
* Display messages.
* @param Topic $Topic Topic of the messages to display.
*/
function DisplayMessages($Topic)
{
    global $G_User;

    $Messages = $Topic->GetMessageList();
    $MessageCount = count($Messages);

    foreach ($Messages as $MessageId => $Message)
    {
        if ((new CWUserFactory())->UserExists(intval($Message->PosterId())))
        {
            $Poster = new SPTUser(intval($Message->PosterId()));
        }
        $EditOkay = CheckForEdit( $Message->PosterId(), $Topic );
        $EditLink = "index.php?P=PostMessage"
            ."&amp;TI=".$Topic->TopicId()
            ."&amp;MI=".$MessageId;
        $DeleteLink = "index.php?P=PostMessage"
            ."&amp;TI=".$Topic->TopicId()
            ."&amp;MI=".$MessageId;

        # see if this user has permission to remove posting privileges
        if (CheckForRemovePostPrivilege()
            && ($Message->PosterId() != $G_User->Id()) && isset($Poster)
            && in_array(strval(PRIV_POSTTOFORUMS), $Poster->GetPrivList()))
        {
            $RemovePostPrivLink = "index.php?P=CleanSpam"
                ."&amp;TI=".$Topic->TopicId()."&amp;PI=".$Message->PosterId() ;
        }
        else
        {
            $RemovePostPrivLink = NULL;
        }

        PrintForumMessageWithMessage($Message, $EditOkay, $EditLink, $DeleteLink,
                          $RemovePostPrivLink, FALSE, NULL, TRUE);
    }
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

/**
* Check if the user has permission to edit the message.
* @param int $PosterId Id of the poster.
* @param Topic $Topic Topic to check.
*/
function CheckForEdit($PosterId, $Topic)
{
    global $G_User;

    $Forum = new Forum($Topic->ForumId());

    return
        $G_User->Get("UserId") == $Forum->ModeratorId() ||
        ($G_User->Get("UserId") == $PosterId && $G_User->HasPriv(PRIV_POSTTOFORUMS)) ||
        $G_User->HasPriv(PRIV_FORUMADMIN) ;
}

/**
* check if user can remove post privilege
* @return TRUE if the user can, FALSE otherwise.
*/
function CheckForRemovePostPrivilege()
{
    global $G_User;

    return
        $G_User->HasPriv(PRIV_FORUMADMIN) && $G_User->HasPriv(PRIV_USERADMIN) ;
}

# ----- MAIN -----------------------------------------------------------------

if (!$GLOBALS["G_SysConfig"]->ForumsEnabled())
{
    CheckAuthorization(-1);
}

if (!isset($_GET["TI"]) )
{
    $H_ErrorMessages[]= "No topic specified";
    return;
}

if (!Topic::ItemExists(intval($_GET["TI"])))
{
    $H_ErrorMessages[]= "No such topic";
    return;
}


$H_Topic = new Topic( intval($_GET["TI"]) );
$H_Forum = new Forum( $H_Topic->ForumId() );

# update the viewcount every time page is loaded
$H_Topic->ViewCount( $H_Topic->ViewCount() + 1);
