<?PHP
#
#   FILE:  Plugins.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

PageTitle("CWIS Plugins");

# check that the user has sufficient privileges
if (!CheckAuthorization(PRIV_SYSADMIN)) {  return;  }

/**
* Enable or disable plugin, enabling prequisite plugins as needed.
* @param object $Plugin Plugin.
* @param bool $Enable TRUE to enable, or FALSE to disable.
* @param array $StatusMsgs Current list of status messages.
* @param string $Dependent Plugin that depends on this one, that is causing
*       it to be enabled.  (OPTIONAL)
*/
function TogglePlugin($Plugin, $Enable, &$StatusMsgs, $Dependent = NULL)
{
    # if plugin is to be enabled
    if ($Enable)
    {
        # retrieve list of plugins it depends on
        $RequiredPlugins = $Plugin->GetDependencies();

        # for each plugin
        foreach ($RequiredPlugins as $RequiredPluginName => $RequiredPluginVersion)
        {
            # if required plugin exists and is not enabled
            $ReqPlugin = $GLOBALS["G_PluginManager"]->GetPlugin(
                    $RequiredPluginName, TRUE);
            if (($ReqPlugin !== NULL) && !$ReqPlugin->IsEnabled())
            {
                # enable plugin
                TogglePlugin($ReqPlugin, TRUE, $StatusMsgs, $Plugin);
            }
        }
    }

    # update plugin status
    $Plugin->IsEnabled($Enable);

    # record message about change
    $PluginName = $Plugin->GetBaseName();
    $Msg = "Plugin <b>".$Plugin->GetName()."</b> has been "
            .($Enable ? "enabled" : "disabled").".";
    if ($Dependent)
    {
        $Msg .= "  (Required by <b>".$Dependent->GetName()."</b>.)";
    }
    $StatusMsgs[$PluginName][] = $Msg;
}

# if form was submitted
if (isset($_POST["SUBMITTED"]))
{
    # for each plugin
    $StatusMsgs = array();
    $Plugins = $GLOBALS["G_PluginManager"]->GetPlugins();
    foreach ($Plugins as $PluginName => $Plugin)
    {
        # never disable core plugin
        if ($PluginName == "CWISCore") {  continue;  }

        # if plugin has been enabled or disabled
        $FField = "EnabledCheckbox-".$PluginName;
        $PEnabledCurrent = $Plugin->IsEnabled() ? TRUE : FALSE;
        $PEnabledNew = isset($_POST[$FField]) ? TRUE : FALSE;
        if ($PEnabledNew != $PEnabledCurrent)
        {
            # updated enable/disable setting to reflect form checkboxes
            TogglePlugin($Plugin, $PEnabledNew, $StatusMsgs);

            # note that plugin has been enabled/disabled
            $PEnabledChange = TRUE;
        }
    }

    # if plugin enabled/disabled status has changed
    if (isset($PEnabledChange))
    {
        # clear page cache
        $GLOBALS["AF"]->ClearPageCache();
    }

    # save any resulting status messages before page is reloaded
    $_SESSION["PluginManagerStatusMessages"] = $StatusMsgs;

    # reload page so that correct set of plugins are loaded
    $GLOBALS["AF"]->SetJumpToPage("Plugins");
}
else
{
    # load any status or error messages
    global $H_ErrMsgs;
    global $H_StatusMsgs;
    $H_ErrMsgs = $GLOBALS["G_PluginManager"]->GetErrorMessages();
    if (array_key_exists("PluginManagerStatusMessages", $_SESSION))
    {
        $H_StatusMsgs = $_SESSION["PluginManagerStatusMessages"];
        unset($_SESSION["PluginManagerStatusMessages"]);
    }
}

