<?PHP
#
#   FILE:  Home.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2003-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

PageTitle("Home");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

/**
* Check whether announcements are enabled.
* @return TRUE if announcements are enabled.
*/
function AnnouncementsEnabled()
{
    return $GLOBALS["G_SysConfig"]->AnnouncementsEnabled();
}

/**
* Print link for the previous resource.
*/
function PrintPrevResourceLink()
{
    global $ResourceOffset;

    $NumResources = $GLOBALS["G_SysConfig"]->NumResourcesOnHomePage();
    $Offset = $ResourceOffset + $NumResources;

    print "index.php?P=Home&amp;ResourceOffset=".$Offset;
}

/**
* Print the link for the next resource.
*/
function PrintNextResourceLink()
{
    global $ResourceOffset;

    $NumResources = $GLOBALS["G_SysConfig"]->NumResourcesOnHomePage();
    $Offset = $ResourceOffset - $NumResources;

    print "index.php?P=Home&amp;ResourceOffset=".$Offset;
}

/**
* Check if next reources are available.
* @return TRUE if they are, FALSE otherwise.
*/
function NextResourcesAvailable()
{
    global $ResourceOffset;

    $NumResources = $GLOBALS["G_SysConfig"]->NumResourcesOnHomePage();
    return ($ResourceOffset >= $NumResources) ? TRUE : FALSE;
}

/**
* Check if previouss are available.
* @return TRUE if they are, FALSE otherwise.
*/
function PreviousResourcesAvailable()
{
    global $MoreResources;
    return $MoreResources;
}

/**
* Print number of resources.
*/
function PrintNumberOfResources()
{
    print $GLOBALS["G_SysConfig"]->NumResourcesOnHomePage();
}

/**
* Print rows of new resource.
*/
function PrintNewResourceTableRows()
{
    global $MoreResources;
    global $ResourceOffset;

    $MaxDescriptionLength = 250;
    $MaxUrlLength = 60;

    if (is_null($ResourceOffset))
    {
        $ResourceOffset = 0;
    }

    # default values
    $MaxNumberOfResourcesToDisplay = $GLOBALS["G_SysConfig"]->NumResourcesOnHomePage();
    $MaxNumberOfDaysToGoBackForResources = 7300;

    # retrieve resources using factory
    # NOTE:  Retrieves one more resource than is needed because we need
    #       to know if there are more resources.)
    $ResourceFact = new ResourceFactory();
    $Resources = $ResourceFact->GetRecentlyReleasedResources(
        ($MaxNumberOfResourcesToDisplay + 1),
        $ResourceOffset, $MaxNumberOfDaysToGoBackForResources);

    # determine whether "Previous" link should be displayed
    $ResourceCount = count($Resources);
    $MoreResources = ($ResourceCount <= $MaxNumberOfResourcesToDisplay) ? FALSE : TRUE;

    # if resources found
    if ($ResourceCount)
    {
        # drop last resource if we have one more than is needed
        if ($ResourceCount > $MaxNumberOfResourcesToDisplay) {  array_pop($Resources);  }

        # for each resource
        foreach ($Resources as $Resource)
        {
            # display resource
            PrintNewResourceRow($Resource,
                    "index.php?P=FullRecord&amp;ID=".$Resource->Id(),
                    $Resource->UserCanEdit($GLOBALS["G_User"]),
                    "index.php?P=EditResource&amp;ID=".$Resource->Id(),
                    $Resource->ScaledCumulativeRating());
        }
    }
    else
    {
        # print row with "no resources" notice
        PrintNoResourcesMessage();
    }
}


# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $AnnouncementOffset;
global $MoreResources;
global $ResourceOffset;
global $ReleaseResourceTotal;

# get the total number of released resources
$ResourceFactory = new ResourceFactory();
$ReleaseResourceTotal = $ResourceFactory->GetReleasedResourceTotal();

if (isset($_GET["ResourceOffset"]))
{
    $ResourceOffset = intval($_GET["ResourceOffset"]);
}
else
{
    $ResourceOffset = 0;
}

if (isset($_GET["AnnouncementOffset"]))
{
    $AnnouncementOffset = intval($_GET["AnnouncementOffset"]);
}
else
{
    $AnnouncementOffset = 0;
}
