<?PHP
#
#   FILE:  EditControlledName.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2011-2016 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

PageTitle("Edit Controlled Names");

# ----- MAIN -----------------------------------------------------------------

if (!CheckAuthorization(PRIV_NAMEADMIN)) {  return;  }

if (isset($_POST["Submit"]) && $_POST["Submit"] == "Cancel")
{
    $GLOBALS["AF"]->SetJumpToPage("MDHome");
    return;
}

# get the schema ID or use the default one if not specified
$SchemaId = GetFormValue("SC", MetadataSchema::SCHEMAID_DEFAULT);
$F_ControlledName = GetFormValue("F_ControlledName", "");
$Submit = GetFormValue("Submit", "");

$H_RecordsPerPage = 10;

$H_Schema = new MetadataSchema($SchemaId);

switch ($Submit)
{
    case ">":
        $Submit = "Search ".$_POST["F_FieldName"];
        $H_StartRec = $_POST["F_StartRec"] + $H_RecordsPerPage;
        break;

    case "<":
        $Submit = "Search ".$_POST["F_FieldName"];
        $H_StartRec = max(0, $_POST["F_StartRec"] - $H_RecordsPerPage);
        break;

    default:
        $H_StartRec = 0;
        break;
}



if (preg_match("/^Search (.*)/", $Submit, $Matches))
{
    $H_Field = $H_Schema->GetField($Matches[1]);
    $CNFact = new ControlledNameFactory($H_Field->Id());

    # if the F_ControlledName is empty (because the user just pushed
    # "search"), then return all CNames in the given field
    $SearchString = strlen($F_ControlledName) ? $F_ControlledName : "*";
    $H_MatchingControlledNames = $CNFact->ControlledNameSearch($SearchString);
    $H_NumResults = count($H_MatchingControlledNames);
    $H_SearchEntered = TRUE;
}
else
{
    $H_MatchingControlledNames = [];
    $H_NumResults = 0;
    $H_SearchEntered = FALSE;
}
