<?PHP
#
#   FILE:  ConfirmDeleteClassification.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2004-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

/**
* Print list of controlled names
* @param Integer $ClassId The id of the class we're
* printing
*/
function PrintClassification($ClassId)
{
    global $Name, $InUseCount;

    $Class = new Classification($ClassId);
    $Name = $Class->FullName();

    $InUseCount = $Class->ResourceCount();

    print $Name;
}

/**
* Print actual value
*/
function PrintClassificationInfo()
{
    global $Name, $InUseCount;

    if ($InUseCount > 0)
    {
        print $Name." (This value in use by $InUseCount Resources)";
    }
    else
    {
        print $Name." (This value is not currently in use)";
    }
}

/**
* Print list of children below this classification
* @param Integer $ClassId The id of the class we're
* requesting information about
*/
function PrintChildrenClasses($ClassId)
{
    $Class = new Classification($ClassId);
    $ChildList = $Class->ChildList();
    foreach ($ChildList as $ChildId)
    {
        $ChildClass = new Classification($ChildId);
        print $ChildClass->FullName()."<br>";
    }
}

/**
* Determine if this classification has childern
* @param Integer $ClassId The id of the class we're
* requesting information about
* @return Integer NumberofChildren
*/
function ClassHasChildren($ClassId)
{
    $Class = new Classification($ClassId);
    return $Class->ChildCount();
}

# non-standard global variables
global $InUseCount;
global $Name;

if (!CheckAuthorization(PRIV_RESOURCEADMIN, PRIV_NAMEADMIN)) {  return;  }
PageTitle("Confirm Delete Classification");

$H_ClassId = intval($_GET["ClassId"]);

# compute parameters for page jump
$H_JumpParams =
    (array_key_exists('SQ', $_GET) ?
     "&amp;SQ=".urlencode($_GET['SQ']) : "" )
    .(array_key_exists('ParentId', $_GET) ?
      "&amp;ParentId=".intval($_GET["ParentId"]) : "" )
    .(array_key_exists('SL', $_GET) ?
      "&amp;SL=".urlencode($_GET['SL']) : "" );
