<?PHP
#
#   FILE:  AddForum.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

/**
* Display a list of users
* @param OptionList $Moderator OptionList Containing the user options
*/
function DisplayUserList($Moderator)
{
    global $H_ForumId;

    $Selected = NULL;

    $UFactory = new CWUserFactory();
    $Items = $UFactory->GetUsersWithPrivileges(PRIV_FORUMADMIN);

    # display selected moderator
    if (!is_null($H_ForumId))
    {
        $Forum = new Forum($H_ForumId);
        $Selected = $Forum->ModeratorId();
    }
    if (count($Items))
    {
        $OptList = new HtmlOptionList($Moderator, $Items, $Selected);
        $OptList->PrintIfEmpty(FALSE);
        $OptList->PrintHtml();
    }
    else
    {
        print("(NO USERS AVAILABLE WITH FORUM ADMIN PRIVILEGES!)");
    }
}

/**
* Fetch the forums as forum objects
* @return an array of forums indexed by forum id
*/
function GetForums()
{
    $Database = new Database();

    $Query = "SELECT * FROM Forums ORDER BY ForumName";
    $Database->Query($Query);

    $Forums = array();

    while (FALSE !== ($Row = $Database->FetchRow()))
    {
        $ForumId = $Row["ForumId"];
        $Forums[$ForumId] = new Forum($ForumId);
    }

    return $Forums;
}

/**
* Fetch the number of forums in this CWIS install
* @return int $Count the number of forums
*/
function GetForumCount()
{
    $Database = new Database();

    $Query = "SELECT * FROM Forums ORDER BY ForumName";
    $Database->Query($Query);

    $Count = $Database->NumRowsSelected();

    return $Count;
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

/**
* Get variable value from _SESSION, if not present,
*       get it from _GET, otherwise return default value.
* @param str $Name Name of the variable to retrieve.
* @param mixed $Default Value to return if vairable is
*       not found in either (OPTIONAL, default to NULL).
* @return Variable value from SESSION, if there is one,
*       or from GET, or default value if none found.
*       (Note if SESSION contains the variable, this
*       will not try to access GET.)
*/
function GetValue($Name, $Default = NULL)
{
    if (isset($_SESSION[$Name]))
    {
        return $_SESSION[$Name];
    }
    else if (isset($_GET[$Name]))
    {
        return $_GET[$Name];
    }
    else
    {
        return $Default;
    }
}

# ----- MAIN -----------------------------------------------------------------

PageTitle("Add/Remove Forums");

CheckAuthorization(PRIV_SYSADMIN, PRIV_FORUMADMIN);

# try to get editing information from either session or url query
#       (if it's set, we are editing forum instead of adding new forum)
$H_Edit = GetValue("Edit", 0);
$H_ForumId = GetValue("F_ForumId");
$H_ForumName = GetValue("F_ForumName", "");
$H_ForumDescription = GetValue("F_ForumDescription", "");
# if editing information is passed through session, clear these session variables
if (isset($_SESSION["Edit"]))
{
    unset($_SESSION["Edit"]);
}
if (isset($_SESSION["F_ForumId"]))
{
    unset($_SESSION["F_ForumId"]);
}
if (isset($_SESSION["F_ForumName"]))
{
    unset($_SESSION["F_ForumName"]);
}
if (isset($_SESSION["F_ForumDescription"]))
{
    unset($_SESSION["F_ForumDescription"]);
}

# retrieve error messages from session to display (set if either
#       Add or Update forum has failed), then clear the session variable
$H_ErrorMessages = array();
if (isset($_SESSION["ErrorMessages"]))
{
    $H_ErrorMessages = $_SESSION["ErrorMessages"];
    unset($_SESSION["ErrorMessages"]);
}
