<?PHP
#
#   FILE:  AddClassification.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2011-2016 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

/**
* Print Qualifier option list
* @param int $FieldId ID of metadata field for classification.
*/
function PrintQualifierList($FieldId)
{
    $Field = new MetadataField($FieldId);

    if ($Field->HasItemLevelQualifiers())
    {
        # first value is "--"
        $Items = $Field->AssociatedQualifierList();
        $Items["--"] = "--";
        ksort($Items);

        $OptList = new HtmlOptionList("F_QualifierId", $Items,
                $Field->DefaultQualifier());
        $OptList->PrintIfEmpty(FALSE);
        $OptList->PrintHtml();
    }
    else if ($Field->DefaultQualifier() > 0)
    {
        $Qualifier = new Qualifier($Field->DefaultQualifier());
        if (is_object($Qualifier)) {
            print $Qualifier->Name(); }
    }
    else {
        print "None"; }
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

if (!CheckAuthorization(PRIV_CLASSADMIN)) {  return;  }

$H_ParentId = GetFormValue("ParentId", Classification::NOPARENT);
$H_FieldId = GetFormValue("FieldId", FALSE);
$H_ErrMsgs = array();
if (isset($_SESSION["ErrorMessages"]))
{
    $H_ErrMsgs = $_SESSION["ErrorMessages"];
    unset($_SESSION["ErrorMessages"]);
}
