<?PHP

#
#   FILE:  Privilege.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2007-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

/**
* User rights management framework allowing custom privege definition
* \nosubgrouping
*/
class Privilege
{

    # ---- PUBLIC INTERFACE --------------------------------------------------

    /** @name Setup/Initialization/Destruction */
    /*@{*/

    /**
    * Object Constructor
    * Pass in a value for the name and a NULL id to make a new privilege
    * @param int $Id Privilege ID number
    * @param string $Name Privilege name
    */
    public function __construct($Id, $Name = NULL)
    {
        global $G_PrivDescriptions;

        # if caller requested creation of new entry
        if ($Id === NULL)
        {
            # get highest current ID
            $DB = new Database();
            $HighestId = $DB->Query("SELECT Id FROM CustomPrivileges"
                    ." ORDER BY Id DESC LIMIT 1", "Id");

            # select new ID
            $this->Id = max(100, ($HighestId + 1));

            # add new entry to database
            $DB->Query("INSERT INTO CustomPrivileges (Id, Name)"
                    ." VALUES (".$this->Id.", '".addslashes($Name)."')");
            $this->Name = $Name;
        }
        else
        {
            # save ID
            $this->Id = intval($Id);

            # if ID indicates predefined privilege
            if ($this->IsPredefined())
            {
                # load privilege info from predefined priv array
                $this->Name = $G_PrivDescriptions[$this->Id];
            }
            else
            {
                # load privilege info from database
                $DB = new Database();
                $this->Name = $DB->Query("SELECT Name FROM CustomPrivileges"
                        ." WHERE Id = ".$this->Id, "Name");
            }
        }
    }

    /**
    * Delete this privelege from the DB
    * NOTE: the object should not be used after calling this
    */
    public function Delete()
    {
        if (!$this->IsPredefined())
        {
            $DB = new Database();
            $DB->Query("DELETE FROM CustomPrivileges"
                       ." WHERE Id = ".$this->Id);
        }
    }

    /*@}*/

    /** @name Accessors */
    /*@{*/

    /** Get Id @return Id */
    public function Id()
    {
        return $this->Id;
    }

    /**
    * Get or set Name
    * @param string $NewValue New value (OPTIONAL)
    * @return Current setting of the name
    */
    public function Name($NewValue = NULL)
    {
        if (($NewValue !== NULL) && !$this->IsPredefined())
        {
            $DB = new Database();
            $DB->Query("UPDATE CustomPrivileges"
                    ." SET Name = '".addslashes($NewValue)."'"
                    ." WHERE Id = ".$this->Id);
            $this->Name = $NewValue;
        }
        return $this->Name;
    }

    /**
    * Report whether privilege is predefined or custom
    * Can be called as Privilege::IsPredefind(ID)
    * @param int $Id Privilege ID (OPTIONAL)
    * @return TRUE for predefined values, FALSE otherwise
    */
    public function IsPredefined($Id = NULL)
    {
        if ($Id === NULL)
        {
            $Id = $this->Id;
        }
        return (($Id > 0) && ($Id < 100)) ? TRUE : FALSE;
    }

    /*@}*/

    # ---- PRIVATE INTERFACE -------------------------------------------------

    private $Id;
    private $Name;
}
