<?PHP
#
#   FILE:  MetadataSchema--Test.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2002-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis
#

PageTitle("Metadata Schema Unit Test");


# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# ----- LOCAL FUNCTIONS ------------------------------------------------------

/**
* List fields in specified schema.
* @param object $Schema Schema.
*/
function ListFields(&$Schema)
{
    $Fields = $Schema->GetFields();
    foreach ($Fields as $Field)
    {
        printf("Id: %d<br>\n", $Field->Id());
        printf("Name: %s<br>\n", $Field->Name());
        printf("Type: %s<br>\n", $Field->Type());
    }
}

/**
* Perform unit test.
*/
function UnitTest()
{
    print("<br>Creating schema...<br>");
    $Schema = new MetadataSchema();

    print("<br>Listing fields...<br>");
    ListFields($Schema);

    print("<br>Adding field...<br>");
    $Schema->AddField("TestFieldOne", MetadataSchema::MDFTYPE_NUMBER);
    $Schema->AddField("TestFieldTwo", MetadataSchema::MDFTYPE_PARAGRAPH);

    print("<br>Listing fields...<br>");
    ListFields($Schema);

    print("<br>Dropping field...<br>");
    $Field = $Schema->GetFieldByName("TestFieldOne");
    $Schema->DropField($Field->Id());
    $Field = $Schema->GetFieldByName("TestFieldTwo");
    $Schema->DropField($Field->Id());

    print("<br>Listing fields...<br>");
    ListFields($Schema);
}


# ----- MAIN -----------------------------------------------------------------

UnitTest();

