<?PHP
#
#   FILE:  TransportControlsUI.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2015 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

/**
* Class to provide support for transport controls (used for paging back
* and forth through a list) in the user interface.  This is a child class,
* that provides just the constants defining the $_GET variable names for
* values and the method that actually prints the HTML for the controls.
* The intent is to provide the ability to customize that HTML by replacing
* just this child class in a different (custom, active) interface.
*/
class TransportControlsUI extends TransportControlsUI_Base
{
    # ---- PUBLIC INTERFACE --------------------------------------------------

    # parameter ($_GET) variable names
    const PNAME_REVERSESORT = "RS";
    const PNAME_SORTFIELD = "SF";
    const PNAME_STARTINGINDEX = "SI";
    const PNAME_ACTIVETAB = "AT";

    /**
    * Print transport control HTML.
    * @param int $ItemType ID of type of item that controls are for.
    * @param string $BaseLink Base URL for links.
    * @param string $Message Text to display between transport buttons.
    *       (May contain HTML.) (OPTIONAL)
    */
    public function PrintControls($ItemType, $BaseLink, $Message = "")
    {
        $this->SetItemType($ItemType);
        $this->SetBaseLink($BaseLink);

        if (isset($this->ItemTypeNames[$ItemType]))
        {
            $TypeName = StdLib::Pluralize($this->ItemTypeNames[$ItemType]);
        }

        if ($this->ShowAnyReverseButtons()
                || $this->ShowAnyForwardButtons()
                || strlen($Message))
        {
            if($this->ShowAnyReverseButtons() || $this->ShowAnyForwardButtons())
            {
                ?><div class="cw-transport-controls clearfix">
                <?PHP
                if ($this->ShowAnyReverseButtons())
                {
                    $TitleAttrib = "Go to first page";
                    if (isset($TypeName)) {  $TitleAttrib .= " of ".$TypeName;  }
                    ?><div class="cw-transport-controls-left">
                    <a class="StyledButton NavStyledButton"
                            href="<?PHP  print $this->GoToStartLink();  ?>"
                            title="<?= $TitleAttrib ?>">&#124;<span
                            style="position:relative; bottom: 1px;">&lt;</span></a>
                    <?PHP

                    if ($this->ShowFastReverseButton())
                    {
                        $TitleAttrib = "Jump back";
                        if (isset($TypeName)) {  $TitleAttrib .= " in ".$TypeName;  }
                        ?><a class="StyledButton NavStyledButton"
                                href="<?PHP  print $this->FastReverseLink();  ?>"
                                title="<?= $TitleAttrib ?>">&lt;&lt;</a> <?PHP
                    }

                    if ($this->ShowReverseButton())
                    {
                        $TitleAttrib = "Go to previous page";
                        if (isset($TypeName)) {  $TitleAttrib .= " of ".$TypeName;  }
                        ?><a class="StyledButton NavStyledButton"
                                href="<?PHP  print $this->ReverseLink();  ?>"
                                title="<?= $TitleAttrib ?>">&lt;</a> <?PHP
                    }

                    ?></div><?PHP
                }

                if ($this->ShowAnyForwardButtons())
                {
                    ?><div class="cw-transport-controls-right">
                    <?PHP

                    if ($this->ShowForwardButton())
                    {
                        $TitleAttrib = "Go to next page";
                        if (isset($TypeName)) {  $TitleAttrib .= " of ".$TypeName;  }
                        ?><a class="StyledButton NavStyledButton"
                                href="<?PHP  print $this->ForwardLink();  ?>"
                                title="<?= $TitleAttrib ?>">&gt;</a> <?PHP
                    }

                    if ($this->ShowFastForwardButton())
                    {
                        $TitleAttrib = "Jump forward";
                        if (isset($TypeName)) {  $TitleAttrib .= " in ".$TypeName;  }
                        ?><a class="StyledButton NavStyledButton"
                                href="<?PHP  print $this->FastForwardLink();  ?>"
                                title="<?= $TitleAttrib ?>">&gt;&gt;</a> <?PHP
                    }

                    $TitleAttrib = "Go to last page";
                    if (isset($TypeName)) {  $TitleAttrib .= " of ".$TypeName;  }
                    ?><a class="StyledButton NavStyledButton"
                            href="<?PHP  print $this->GoToEndLink();  ?>"
                            title="<?= $TitleAttrib ?>">&gt;<span
                            style="position:relative; bottom: 1px;">&#124;</span></a>
                    </div><?PHP
                }

                if($this->ShowAnyReverseButtons() && !$this->ShowAnyForwardButtons())
                {
                    ?><div class="cw-transport-controls-msg-left-only clearfix"><?PHP
                    print strlen($Message) ? $Message : "&nbsp;";
                    ?></div><?PHP
                }
                elseif(!$this->ShowAnyReverseButtons()
                        && $this->ShowAnyForwardButtons())
                {
                    ?><div class="cw-transport-controls-msg-right-only clearfix"><?PHP
                    print strlen($Message) ? $Message : "&nbsp;";
                    ?></div><?PHP
                }
                else
                {
                    ?><div class="cw-transport-controls-msg clearfix"><?PHP
                    print strlen($Message) ? $Message : "&nbsp;";
                    ?></div><?PHP
                }

                ?></div><?PHP
            }
            else
            {
                print strlen($Message) ? $Message : "&nbsp;";
            }
        }
    }
}

