
-- new column in users table to explicitly indicate login status
ALTER TABLE APUsers ADD COLUMN LoggedIn INT DEFAULT 0;

-- new column in ApplicationFramework table to allow disabling task execution
ALTER TABLE ApplicationFrameworkSettings 
        ADD COLUMN TaskExecutionEnabled INT DEFAULT 1;

-- folders for storing groups of items
CREATE TABLE IF NOT EXISTS Folders (
        FolderId                INT NOT NULL AUTO_INCREMENT,
        PreviousFolderId        INT,
        NextFolderId            INT,
        OwnerId                 INT NOT NULL,
        FolderName              TEXT,
        NormalizedName          TEXT,
        FolderNote              TEXT,
        IsShared                INT DEFAULT 0,
        ContentType             INT DEFAULT -1,
        INDEX                   (OwnerId),
        INDEX                   (FolderId)
        );

-- intersection table indicating which items are in which folders
CREATE TABLE IF NOT EXISTS FolderItemInts (
        FolderId                INT NOT NULL,
        ItemId                  INT NOT NULL,
        ItemTypeId              INT DEFAULT -1,
        PreviousItemId          INT DEFAULT -1,
        PreviousItemTypeId      INT DEFAULT -1,
        NextItemId              INT DEFAULT -1,
        NextItemTypeId          INT DEFAULT -1,
        ItemNote                TEXT,
        INDEX                   (FolderId),
        INDEX                   (ItemId)
        );

-- mapping of item type names to numerical item type IDs
CREATE TABLE IF NOT EXISTS FolderContentTypes (
        TypeId                  INT NOT NULL AUTO_INCREMENT,
        TypeName                TEXT,
        NormalizedTypeName      TEXT,
        INDEX                   (TypeId)
        );

